/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.factories;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.buddyreplication.NextMemberBuddyLocator;
import org.jboss.cache.config.BuddyReplicationConfig;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionPolicyConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.config.MissingPolicyException;
import org.jboss.cache.eviction.EvictionPolicy;
import org.jboss.cache.util.BeanUtils;
import org.jboss.cache.util.Util;
import org.jboss.cache.xml.XmlHelper;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlConfigurationParser {
    private static Log log = LogFactory.getLog(XmlConfigurationParser.class);
    public static final String ATTR = "attribute";
    public static final String NAME = "name";

    public Configuration parseFile(String filename) {
        InputStream is = this.getAsInputStreamFromClassLoader(filename);
        if (is == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unable to find configuration file " + filename + " in classpath; searching for this file on the filesystem instead."));
            }
            try {
                is = new FileInputStream(filename);
            }
            catch (FileNotFoundException e) {
                throw new ConfigurationException("Unable to find config file " + filename + " either in classpath or on the filesystem!", e);
            }
        }
        return this.parseStream(is);
    }

    public Configuration parseStream(InputStream stream) {
        Element root = XmlHelper.getDocumentRoot(stream);
        Element mbeanElement = this.getMBeanElement(root);
        return this.parseConfiguration(mbeanElement);
    }

    public Configuration parseConfiguration(Element configurationRoot) {
        ParsedAttributes attributes = XmlConfigurationParser.extractAttributes(configurationRoot);
        this.handleRemovedAttributes(attributes);
        this.handleRenamedAttributes(attributes);
        Configuration c = new Configuration();
        XmlConfigurationParser.setValues(c, attributes.stringAttribs, false);
        this.setXmlValues(c, attributes.xmlAttribs);
        return c;
    }

    protected void handleRemovedAttributes(ParsedAttributes attributes) {
        String evictionPolicy = attributes.stringAttribs.remove("EvictionPolicyClass");
        if (evictionPolicy != null) {
            throw new ConfigurationException("XmlConfigurationParser does not support the JBC 1.x attribute EvictionPolicyClass. Set the default eviction policy via the policyClass element in the EvictionConfig section");
        }
        String multiplexerService = attributes.stringAttribs.remove("MultiplexerService");
        if (multiplexerService != null) {
            throw new ConfigurationException("XmlConfigurationParser does not support the JBC 1.x attribute MultiplexerService. Inject the multiplexer directly using Configuration.getRuntimeConfig().setMuxChannelFactory()");
        }
        String serviceName = attributes.stringAttribs.remove("ServiceName");
        if (serviceName != null) {
            log.warn((Object)"XmlConfigurationParser does not support the deprecated attribute ServiceName. If JMX registration is needed, register a CacheJmxWrapper or PojoCacheJmxWrapper in JMX with the desired name");
        }
    }

    private void handleRenamedAttributes(ParsedAttributes attributes) {
        Element clc;
        String keepStats = attributes.stringAttribs.remove("UseInterceptorMbeans");
        if (keepStats != null && attributes.stringAttribs.get("ExposeManagementStatistics") == null) {
            log.warn((Object)"Found non-existent JBC 1.x attribute 'UseInterceptorMbeans' and replaced with 'ExposeManagementStatistics'. Please update your config to use the new attribute name");
            attributes.stringAttribs.put("ExposeManagementStatistics", keepStats);
        }
        if ((clc = attributes.xmlAttribs.remove("CacheLoaderConfiguration")) != null && attributes.xmlAttribs.get("CacheLoaderConfig") == null) {
            log.warn((Object)"Found non-existent JBC 1.x attribute 'CacheLoaderConfiguration' and replaced with 'CacheLoaderConfig'. Please update your config to use the new attribute name");
            attributes.xmlAttribs.put("CacheLoaderConfig", clc);
        }
    }

    protected InputStream getAsInputStreamFromClassLoader(String filename) {
        InputStream is;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = is = cl == null ? null : cl.getResourceAsStream(filename);
        if (is == null) {
            is = this.getClass().getClassLoader().getResourceAsStream(filename);
        }
        return is;
    }

    protected Element getMBeanElement(Element root) {
        NodeList list = root.getElementsByTagName("mbean");
        if (list == null) {
            throw new ConfigurationException("Can't find mbean tag");
        }
        if (list.getLength() > 1) {
            throw new ConfigurationException("Has multiple mbean tag");
        }
        Node node = list.item(0);
        Element element = null;
        if (node.getNodeType() != 1) {
            throw new ConfigurationException("Can't find mbean element");
        }
        element = (Element)node;
        return element;
    }

    protected static void setValues(Object target, Map<?, ?> attribs, boolean isXmlAttribs) {
        Class<?> objectClass = target.getClass();
        for (Map.Entry<?, ?> entry : attribs.entrySet()) {
            String propName = (String)entry.getKey();
            String setter = BeanUtils.setterName(propName);
            try {
                Method method;
                if (isXmlAttribs) {
                    method = objectClass.getMethod(setter, Element.class);
                    method.invoke(target, entry.getValue());
                    continue;
                }
                method = objectClass.getMethod(setter, String.class);
                method.invoke(target, entry.getValue());
                continue;
            }
            catch (NoSuchMethodException me) {
            }
            catch (Exception e) {
                throw new ConfigurationException("Unable to invoke setter " + setter + " on " + objectClass, e);
            }
            for (Method m : objectClass.getMethods()) {
                if (!setter.equals(m.getName())) continue;
                Class<?>[] paramTypes = m.getParameterTypes();
                if (paramTypes.length != 1) {
                    throw new ConfigurationException("Setter " + setter + " does not contain the expected number of params.  Has " + paramTypes.length + " instead of just 1.");
                }
                Class<?> parameterType = paramTypes[0];
                PropertyEditor editor = PropertyEditorManager.findEditor(parameterType);
                if (editor == null) {
                    throw new ConfigurationException("Couldn't find a property editor for parameter type " + parameterType);
                }
                editor.setAsText((String)attribs.get(propName));
                Object parameter = editor.getValue();
                try {
                    m.invoke(target, parameter);
                }
                catch (Exception e) {
                    throw new ConfigurationException("Unable to invoke setter " + setter + " on " + objectClass, e);
                }
            }
        }
    }

    protected void setXmlValues(Configuration conf, Map<String, Element> attribs) {
        for (Map.Entry<String, Element> entry : attribs.entrySet()) {
            String propname = entry.getKey();
            if ("BuddyReplicationConfiguration".equals(propname) || "BuddyReplicationConfig".equals(propname)) {
                BuddyReplicationConfig brc = XmlConfigurationParser.parseBuddyReplicationConfig(entry.getValue());
                conf.setBuddyReplicationConfig(brc);
                continue;
            }
            if ("CacheLoaderConfiguration".equals(propname) || "CacheLoaderConfig".equals(propname)) {
                CacheLoaderConfig clc = XmlConfigurationParser.parseCacheLoaderConfig(entry.getValue());
                conf.setCacheLoaderConfig(clc);
                continue;
            }
            if ("EvictionPolicyConfiguration".equals(propname) || "EvictionPolicyConfig".equals(propname)) {
                EvictionConfig ec = XmlConfigurationParser.parseEvictionConfig(entry.getValue());
                conf.setEvictionConfig(ec);
                continue;
            }
            if ("ClusterConfig".equals(propname)) {
                String jgc = XmlConfigurationParser.parseClusterConfigXml(entry.getValue());
                conf.setClusterConfig(jgc);
                continue;
            }
            throw new ConfigurationException("Unknown configuration element " + propname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BuddyReplicationConfig parseBuddyReplicationConfig(Element element) {
        BuddyReplicationConfig brc;
        block11: {
            brc = new BuddyReplicationConfig();
            brc.setEnabled(XmlHelper.readBooleanContents(element, "buddyReplicationEnabled"));
            brc.setDataGravitationRemoveOnFind(XmlHelper.readBooleanContents(element, "dataGravitationRemoveOnFind", true));
            brc.setDataGravitationSearchBackupTrees(XmlHelper.readBooleanContents(element, "dataGravitationSearchBackupTrees", true));
            brc.setAutoDataGravitation(brc.isEnabled() && XmlHelper.readBooleanContents(element, "autoDataGravitation", false));
            String strBuddyCommunicationTimeout = XmlHelper.readStringContents(element, "buddyCommunicationTimeout");
            try {
                Object var5_3;
                try {
                    brc.setBuddyCommunicationTimeout(Integer.parseInt(strBuddyCommunicationTimeout));
                }
                catch (Exception e) {
                    var5_3 = null;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Using buddy communication timeout of " + brc.getBuddyCommunicationTimeout() + " millis"));
                    }
                    break block11;
                }
                var5_3 = null;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using buddy communication timeout of " + brc.getBuddyCommunicationTimeout() + " millis"));
                }
                throw throwable;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using buddy communication timeout of " + brc.getBuddyCommunicationTimeout() + " millis"));
            }
        }
        String buddyPoolName = XmlHelper.readStringContents(element, "buddyPoolName");
        if ("".equals(buddyPoolName)) {
            buddyPoolName = null;
        }
        brc.setBuddyPoolName(buddyPoolName);
        String buddyLocatorClass = XmlHelper.readStringContents(element, "buddyLocatorClass");
        if (buddyLocatorClass == null || buddyLocatorClass.length() == 0) {
            buddyLocatorClass = NextMemberBuddyLocator.class.getName();
        }
        Properties props = null;
        try {
            props = XmlHelper.readPropertiesContents(element, "buddyLocatorProperties");
        }
        catch (IOException e) {
            log.warn((Object)"Caught exception reading buddyLocatorProperties", (Throwable)e);
            log.error((Object)("Unable to read buddyLocatorProperties specified!  Using defaults for [" + buddyLocatorClass + "]"));
        }
        BuddyReplicationConfig.BuddyLocatorConfig blc = new BuddyReplicationConfig.BuddyLocatorConfig();
        blc.setBuddyLocatorClass(buddyLocatorClass);
        blc.setBuddyLocatorProperties(props);
        brc.setBuddyLocatorConfig(blc);
        return brc;
    }

    public static CacheLoaderConfig parseCacheLoaderConfig(Element element) {
        CacheLoaderConfig clc = new CacheLoaderConfig();
        clc.setPassivation(XmlHelper.readBooleanContents(element, "passivation"));
        clc.setPreload(XmlHelper.readStringContents(element, "preload"));
        clc.setShared(XmlHelper.readBooleanContents(element, "shared"));
        NodeList cacheLoaderNodes = element.getElementsByTagName("cacheloader");
        for (int i = 0; i < cacheLoaderNodes.getLength(); ++i) {
            Node node = cacheLoaderNodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element indivElement = (Element)node;
            CacheLoaderConfig.IndividualCacheLoaderConfig iclc = new CacheLoaderConfig.IndividualCacheLoaderConfig();
            iclc.setAsync(XmlHelper.readBooleanContents(indivElement, "async", false));
            iclc.setIgnoreModifications(XmlHelper.readBooleanContents(indivElement, "ignoreModifications", false));
            iclc.setFetchPersistentState(XmlHelper.readBooleanContents(indivElement, "fetchPersistentState", false));
            iclc.setPurgeOnStartup(XmlHelper.readBooleanContents(indivElement, "purgeOnStartup", false));
            iclc.setClassName(XmlHelper.readStringContents(indivElement, "class"));
            try {
                iclc.setProperties(XmlHelper.readPropertiesContents(indivElement, "properties"));
            }
            catch (IOException e) {
                throw new ConfigurationException("Problem loader cache loader properties", e);
            }
            CacheLoaderConfig.IndividualCacheLoaderConfig.SingletonStoreConfig ssc = XmlConfigurationParser.parseSingletonStoreConfig(indivElement);
            if (ssc != null) {
                iclc.setSingletonStoreConfig(ssc);
            }
            clc.addIndividualCacheLoaderConfig(iclc);
        }
        return clc;
    }

    private static CacheLoaderConfig.IndividualCacheLoaderConfig.SingletonStoreConfig parseSingletonStoreConfig(Element cacheLoaderelement) {
        Node singletonStoreNode = cacheLoaderelement.getElementsByTagName("singletonStore").item(0);
        if (singletonStoreNode != null && singletonStoreNode.getNodeType() == 1) {
            Element singletonStoreElement = (Element)singletonStoreNode;
            boolean singletonStoreEnabled = XmlHelper.readBooleanContents(singletonStoreElement, "enabled");
            String singletonStoreClass = XmlHelper.readStringContents(singletonStoreElement, "class");
            Properties singletonStoreproperties = null;
            try {
                singletonStoreproperties = XmlHelper.readPropertiesContents(singletonStoreElement, "properties");
            }
            catch (IOException e) {
                throw new ConfigurationException("Problem loading singleton store properties", e);
            }
            CacheLoaderConfig.IndividualCacheLoaderConfig.SingletonStoreConfig ssc = new CacheLoaderConfig.IndividualCacheLoaderConfig.SingletonStoreConfig();
            ssc.setSingletonStoreEnabled(singletonStoreEnabled);
            ssc.setSingletonStoreClass(singletonStoreClass);
            ssc.setSingletonStoreproperties(singletonStoreproperties);
            return ssc;
        }
        return null;
    }

    public static EvictionConfig parseEvictionConfig(Element element) {
        EvictionConfig ec = new EvictionConfig();
        if (element != null) {
            String temp = XmlHelper.getTagContents(element, "policyClass", ATTR, NAME);
            if (temp != null && temp.length() > 0) {
                ec.setDefaultEvictionPolicyClass(temp);
            }
            temp = XmlHelper.getTagContents(element, "wakeUpIntervalSeconds", ATTR, NAME);
            int wakeupIntervalSeconds = 0;
            if (temp != null) {
                wakeupIntervalSeconds = Integer.parseInt(temp);
            }
            if (wakeupIntervalSeconds <= 0) {
                wakeupIntervalSeconds = 5;
            }
            ec.setWakeupIntervalSeconds(wakeupIntervalSeconds);
            int eventQueueSize = 0;
            temp = XmlHelper.getTagContents(element, "eventQueueSize", ATTR, NAME);
            if (temp != null) {
                eventQueueSize = Integer.parseInt(temp);
            }
            if (eventQueueSize <= 0) {
                eventQueueSize = 200000;
            }
            ec.setDefaultEventQueueSize(eventQueueSize);
            NodeList list = element.getElementsByTagName("region");
            if (list != null && list.getLength() > 0) {
                ArrayList<EvictionRegionConfig> regionConfigs = new ArrayList<EvictionRegionConfig>(list.getLength());
                for (int i = 0; i < list.getLength(); ++i) {
                    Node node = list.item(i);
                    if (node.getNodeType() != 1) continue;
                    try {
                        regionConfigs.add(XmlConfigurationParser.parseEvictionRegionConfig((Element)node, ec.getDefaultEvictionPolicyClass(), eventQueueSize));
                        continue;
                    }
                    catch (MissingPolicyException ignored) {
                        LogFactory.getLog(EvictionConfig.class).warn((Object)ignored.getLocalizedMessage());
                    }
                }
                ec.setEvictionRegionConfigs(regionConfigs);
            }
        }
        return ec;
    }

    public static EvictionRegionConfig parseEvictionRegionConfig(Element element, String defaultEvictionClass, int defaultQueueCapacity) {
        EvictionRegionConfig erc = new EvictionRegionConfig();
        erc.setRegionName(element.getAttribute(NAME));
        String temp = element.getAttribute("eventQueueSize");
        if (temp != null && temp.length() > 0) {
            erc.setEventQueueSize(Integer.parseInt(temp));
        } else {
            erc.setEventQueueSize(defaultQueueCapacity);
        }
        String evictionClass = element.getAttribute("policyClass");
        if (!(evictionClass != null && evictionClass.length() != 0 || (evictionClass = defaultEvictionClass) != null && evictionClass.length() != 0)) {
            throw new MissingPolicyException("There is no Eviction Policy Class specified on the region or for the entire cache!");
        }
        EvictionPolicy policy = null;
        try {
            policy = (EvictionPolicy)Util.loadClass(evictionClass).newInstance();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Eviction class is not properly loaded in classloader", e);
        }
        EvictionPolicyConfig epc = null;
        try {
            epc = policy.getEvictionConfigurationClass().newInstance();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate eviction configuration of class " + policy.getEvictionConfigurationClass(), e);
        }
        XmlConfigurationParser.parseEvictionPolicyConfig(element, epc);
        erc.setEvictionPolicyConfig(epc);
        return erc;
    }

    public static void parseEvictionPolicyConfig(Element element, EvictionPolicyConfig target) {
        target.reset();
        ParsedAttributes attributes = XmlConfigurationParser.extractAttributes(element);
        XmlConfigurationParser.setValues(target, attributes.stringAttribs, false);
        XmlConfigurationParser.setValues(target, attributes.xmlAttribs, true);
        target.validate();
    }

    public static String parseClusterConfigXml(Element config) {
        StringBuffer buffer = new StringBuffer();
        NodeList stack = config.getChildNodes();
        int length = stack.getLength();
        for (int s = 0; s < length; ++s) {
            Node node = stack.item(s);
            if (node.getNodeType() != 1) continue;
            Element tag = (Element)node;
            String protocol = tag.getTagName();
            buffer.append(protocol);
            NamedNodeMap attrs = tag.getAttributes();
            int attrLength = attrs.getLength();
            if (attrLength > 0) {
                buffer.append('(');
            }
            for (int a = 0; a < attrLength; ++a) {
                Attr attr = (Attr)attrs.item(a);
                String name = attr.getName();
                String value = attr.getValue();
                buffer.append(name);
                buffer.append('=');
                buffer.append(value);
                if (a >= attrLength - 1) continue;
                buffer.append(';');
            }
            if (attrLength > 0) {
                buffer.append(')');
            }
            buffer.append(':');
        }
        buffer.setLength(buffer.length() - 1);
        return buffer.toString();
    }

    protected static ParsedAttributes extractAttributes(Element source) {
        HashMap<String, String> stringAttribs = new HashMap<String, String>();
        HashMap<String, Element> xmlAttribs = new HashMap<String, Element>();
        NodeList list = source.getElementsByTagName(ATTR);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Attribute size: " + list.getLength()));
        }
        for (int loop = 0; loop < list.getLength(); ++loop) {
            Node node = list.item(loop);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String name = element.getAttribute(NAME);
            String valueStr = XmlHelper.getElementContent(element, true);
            Element valueXml = null;
            if (valueStr.length() == 0) {
                valueXml = XmlHelper.getConfigSubElement(element);
            }
            if (valueStr.length() > 0) {
                stringAttribs.put(name, valueStr);
            }
            if (valueXml == null) continue;
            xmlAttribs.put(name, valueXml);
        }
        return new ParsedAttributes(stringAttribs, xmlAttribs);
    }

    static class ParsedAttributes {
        Map<String, String> stringAttribs;
        Map<String, Element> xmlAttribs;

        ParsedAttributes(Map strings, Map elements) {
            this.stringAttribs = strings;
            this.xmlAttribs = elements;
        }
    }
}

