/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.config.Option;
import org.jboss.cache.interceptors.BaseTransactionalContextInterceptor;
import org.jboss.cache.interceptors.InvocationContextInterceptorMBean;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.transaction.GlobalTransaction;

public class InvocationContextInterceptor
extends BaseTransactionalContextInterceptor
implements InvocationContextInterceptorMBean {
    public InvocationContextInterceptor() {
        this.initLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(InvocationContext ctx) throws Throwable {
        Object object;
        boolean resumeSuspended;
        Transaction suspendedTransaction;
        block20: {
            Object th2;
            block18: {
                block19: {
                    MethodCall call = ctx.getMethodCall();
                    Option optionOverride = ctx.getOptionOverrides();
                    boolean suppressExceptions = false;
                    suspendedTransaction = null;
                    resumeSuspended = false;
                    if (this.trace) {
                        this.log.trace((Object)("Invoked with InvocationContext [" + ctx + "]"));
                    }
                    if (MethodDeclarations.isBlockUnblockMethod(call.getMethodId())) {
                        return this.nextInterceptor(ctx);
                    }
                    try {
                        Object retval;
                        Transaction tx = this.getTransaction();
                        this.setTransactionalContext(tx, this.getGlobalTransaction(tx, call), ctx);
                        if (optionOverride != null && optionOverride.isFailSilently()) {
                            this.log.debug((Object)"FAIL_SILENTLY Option is present - suspending any ongoing transaction.");
                            suppressExceptions = true;
                            if (ctx.getTransaction() != null) {
                                suspendedTransaction = this.txManager.suspend();
                                this.setTransactionalContext(null, null, ctx);
                                if (this.trace) {
                                    this.log.trace((Object)("Suspending transaction " + suspendedTransaction));
                                }
                                resumeSuspended = true;
                            } else if (this.trace) {
                                this.log.trace((Object)"No ongoing transaction to suspend");
                            }
                        }
                        try {
                            retval = this.nextInterceptor(ctx);
                        }
                        catch (Throwable th2) {
                            retval = th2;
                        }
                        if (retval instanceof Throwable) {
                            if (!suppressExceptions) {
                                Throwable t = (Throwable)retval;
                                if (!(t instanceof RuntimeException)) throw t;
                                if (t.getCause() == null) throw t;
                                throw t.getCause();
                            }
                            th2 = null;
                            Object var11_13 = null;
                            if (!this.trace) break block18;
                            break block19;
                        }
                        object = retval;
                        break block20;
                    }
                    catch (Throwable throwable) {
                        Object var11_15 = null;
                        if (this.trace) {
                            this.log.trace((Object)"Resetting invocation-scope options");
                        }
                        ctx.getOptionOverrides().reset();
                        if (resumeSuspended) {
                            this.txManager.resume(suspendedTransaction);
                            throw throwable;
                        }
                        if (ctx.getTransaction() == null) throw throwable;
                        if (!this.isValid(ctx.getTransaction())) throw throwable;
                        this.copyInvocationScopeOptionsToTxScope(ctx);
                        throw throwable;
                    }
                }
                this.log.trace((Object)"Resetting invocation-scope options");
            }
            ctx.getOptionOverrides().reset();
            if (resumeSuspended) {
                this.txManager.resume(suspendedTransaction);
                return th2;
            }
            if (ctx.getTransaction() == null) return th2;
            if (!this.isValid(ctx.getTransaction())) return th2;
            this.copyInvocationScopeOptionsToTxScope(ctx);
            return th2;
        }
        Object var11_14 = null;
        if (this.trace) {
            this.log.trace((Object)"Resetting invocation-scope options");
        }
        ctx.getOptionOverrides().reset();
        if (resumeSuspended) {
            this.txManager.resume(suspendedTransaction);
            return object;
        }
        if (ctx.getTransaction() == null) return object;
        if (!this.isValid(ctx.getTransaction())) return object;
        this.copyInvocationScopeOptionsToTxScope(ctx);
        return object;
    }

    private GlobalTransaction getGlobalTransaction(Transaction tx, MethodCall call) {
        GlobalTransaction gtx = this.findGlobalTransaction(call.getArgs());
        if (gtx == null) {
            gtx = this.cache.getCurrentTransaction(tx, false);
        }
        if (gtx != null) {
            gtx.setRemote(this.isRemoteGlobalTx(gtx));
        }
        return gtx;
    }

    private Transaction getTransaction() throws SystemException {
        if (this.txManager == null) {
            if (this.trace) {
                this.log.trace((Object)"no transaction manager configured, setting tx as null.");
            }
            return null;
        }
        return this.txManager.getTransaction();
    }

    protected GlobalTransaction findGlobalTransaction(Object[] params) {
        int clue = 0;
        if (params[clue] instanceof GlobalTransaction) {
            return (GlobalTransaction)params[clue];
        }
        for (Object param : params) {
            if (!(param instanceof GlobalTransaction)) continue;
            return (GlobalTransaction)param;
        }
        return null;
    }

    private boolean isRemoteGlobalTx(GlobalTransaction gtx) {
        return gtx != null && gtx.getAddress() != null && !gtx.getAddress().equals(this.cache.getLocalAddress());
    }
}

