/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.Transaction;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.interceptors.MethodDispacherInterceptor;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.lock.LockingException;
import org.jboss.cache.lock.NodeLock;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.TransactionEntry;
import org.jboss.cache.transaction.TransactionTable;
import org.jgroups.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PessimisticLockInterceptor
extends MethodDispacherInterceptor {
    private TransactionTable tx_table;
    private CacheImpl cacheImpl;
    private NodeSPI rootNode;
    private long lock_acquisition_timeout;

    public PessimisticLockInterceptor() {
        this.initLogger();
    }

    @Inject
    public void injectDependencies(Configuration configuration, CacheImpl cacheImpl, TransactionTable txTable) {
        this.lock_acquisition_timeout = configuration.getLockAcquisitionTimeout();
        this.cacheImpl = cacheImpl;
        this.tx_table = txTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(InvocationContext ctx) throws Throwable {
        Transaction tx2;
        Object object;
        if (this.rootNode == null) {
            this.rootNode = this.cache.getRoot();
        }
        try {
            object = super.invoke(ctx);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Transaction tx2;
            Object var4_4 = null;
            if (!(ctx.getOptionOverrides() != null && ctx.getOptionOverrides().isSuppressLocking() || (tx2 = ctx.getTransaction()) != null && this.isValid(tx2))) {
                List<NodeLock> locks = ctx.getInvocationLocksAcquired();
                if (this.trace) {
                    this.log.trace((Object)("Attempting to release locks on current thread.  Locks for the invocation is " + locks));
                }
                if (locks != null && locks.size() > 0) {
                    Thread currentThread = Thread.currentThread();
                    try {
                        for (int i = locks.size() - 1; i > -1; --i) {
                            NodeLock nl = locks.get(i);
                            if (this.trace) {
                                this.log.trace((Object)("releasing lock for " + nl.getFqn() + ": " + nl));
                            }
                            nl.release(currentThread);
                        }
                        Object var11_17 = null;
                        ctx.clearInvocationLocksAcquired();
                    }
                    catch (Throwable throwable2) {
                        Object var11_18 = null;
                        ctx.clearInvocationLocksAcquired();
                        throw throwable2;
                    }
                }
            }
            throw throwable;
        }
        if (!(ctx.getOptionOverrides() != null && ctx.getOptionOverrides().isSuppressLocking() || (tx2 = ctx.getTransaction()) != null && this.isValid(tx2))) {
            List<NodeLock> locks = ctx.getInvocationLocksAcquired();
            if (this.trace) {
                this.log.trace((Object)("Attempting to release locks on current thread.  Locks for the invocation is " + locks));
            }
            if (locks != null && locks.size() > 0) {
                Thread currentThread = Thread.currentThread();
                try {
                    for (int i = locks.size() - 1; i > -1; --i) {
                        NodeLock nl = locks.get(i);
                        if (this.trace) {
                            this.log.trace((Object)("releasing lock for " + nl.getFqn() + ": " + nl));
                        }
                        nl.release(currentThread);
                    }
                    Object var11_15 = null;
                    ctx.clearInvocationLocksAcquired();
                }
                catch (Throwable throwable) {
                    Object var11_16 = null;
                    ctx.clearInvocationLocksAcquired();
                    throw throwable;
                }
            }
        }
        return object;
    }

    private void releaseLocks(InvocationContext ctx) {
    }

    @Override
    protected Object handlePutDataMethod(InvocationContext ctx, GlobalTransaction tx, Fqn fqn, Map data, boolean createUndoOps) throws Throwable {
        return this.handlePutMethod(ctx, fqn);
    }

    @Override
    protected Object handlePutDataEraseMethod(InvocationContext ctx, GlobalTransaction gt, Fqn fqn, Map newData, boolean createUndoOps, boolean eraseContents) throws Throwable {
        return this.handlePutMethod(ctx, fqn);
    }

    @Override
    protected Object handlePutKeyValueMethod(InvocationContext ctx, GlobalTransaction gtx, Fqn fqn, Object key, Object value, boolean createUndoOps) throws Throwable {
        return this.handlePutMethod(ctx, fqn);
    }

    private Object handlePutMethod(InvocationContext ctx, Fqn fqn) throws Throwable {
        if (ctx.getOptionOverrides() != null && ctx.getOptionOverrides().isSuppressLocking() || this.configuration.getIsolationLevel() == IsolationLevel.NONE) {
            if (this.trace) {
                this.log.trace((Object)"Suppressing locking, creating nodes if necessary");
            }
            int treeNodeSize = fqn.size();
            NodeSPI n = this.rootNode;
            for (int i = 0; i < treeNodeSize; ++i) {
                Object childName = fqn.get(i);
                Fqn<Object> childFqn = new Fqn<Object>(childName);
                NodeSPI child_node = n.getChildDirect(childFqn);
                if (child_node == null) {
                    child_node = n.addChildDirect(childFqn);
                }
                this.manageReverseRemove(ctx.getGlobalTransaction(), child_node, true);
                n = child_node;
            }
        } else {
            this.acquireLocksWithTimeout(ctx, fqn, NodeLock.LockType.WRITE, true, false, false, true, null, false);
        }
        return this.nextInterceptor(ctx);
    }

    @Override
    protected boolean skipMethodCall(InvocationContext ctx) {
        return ctx.getOptionOverrides() != null && ctx.getOptionOverrides().isSuppressLocking() && !MethodDeclarations.isPutMethod(ctx.getMethodCall().getMethodId());
    }

    @Override
    protected Object handleLockMethod(InvocationContext ctx, Fqn fqn, NodeLock.LockType lockType, boolean recursive) throws Throwable {
        this.acquireLocksWithTimeout(ctx, fqn, lockType, false, false, false, false, null, false);
        if (recursive) {
            this.acquireLocksOnChildren(this.peekNode(ctx, fqn, false, false, false), lockType, ctx);
        }
        return null;
    }

    @Override
    protected Object handlePrepareMethod(InvocationContext ctx, GlobalTransaction gtx, List modification, Address coordinator, boolean onePhaseCommit) throws Throwable {
        if (!onePhaseCommit) {
            return this.nextInterceptor(ctx);
        }
        this.commit(ctx.getGlobalTransaction());
        Object retVal = this.nextInterceptor(ctx);
        this.tx_table.cleanup(ctx.getGlobalTransaction());
        return retVal;
    }

    @Override
    protected Object handleOptimisticPrepareMethod(InvocationContext ctx, GlobalTransaction gtx, List modifications, Map data, Address address, boolean onePhaseCommit) throws Throwable {
        throw new UnsupportedOperationException("Optimistic prepare methods should never be received by the pessimistic lock interceptor!!");
    }

    @Override
    protected Object handleCommitMethod(InvocationContext ctx, GlobalTransaction globalTransaction) throws Throwable {
        this.commit(globalTransaction);
        if (this.trace) {
            this.log.trace((Object)"bypassed locking as method commit() doesn't require locking");
        }
        Object retVal = this.nextInterceptor(ctx);
        this.tx_table.cleanup(globalTransaction);
        return retVal;
    }

    @Override
    protected Object handleRollbackMethod(InvocationContext ctx, GlobalTransaction globalTransaction) throws Throwable {
        TransactionEntry entry = this.tx_table.get(globalTransaction);
        if (this.trace) {
            this.log.trace((Object)("called to rollback cache with GlobalTransaction=" + globalTransaction));
        }
        if (entry == null) {
            this.log.error((Object)("entry for transaction " + globalTransaction + " not found (transaction has possibly already been rolled back)"));
        } else {
            for (Fqn f : entry.getRemovedNodes()) {
                this.cacheImpl.realRemove(f, false);
            }
            entry.undoOperations(this.cache);
        }
        if (this.trace) {
            this.log.trace((Object)"bypassed locking as method rollback() doesn't require locking");
        }
        Object retVal = this.nextInterceptor(ctx);
        this.tx_table.cleanup(globalTransaction);
        return retVal;
    }

    @Override
    protected Object handleMoveMethod(InvocationContext ctx, Fqn from, Fqn to) throws Throwable {
        long timeout = ctx.getContextLockAcquisitionTimeout(this.lock_acquisition_timeout);
        if (this.trace) {
            this.log.trace((Object)("Attempting to get WL on node to be moved [" + from + "]"));
        }
        if (from != null && this.configuration.getIsolationLevel() != IsolationLevel.NONE) {
            this.lock(ctx, from, NodeLock.LockType.WRITE, false, timeout, true, false, null, false);
            if (ctx.getGlobalTransaction() != null) {
                this.cache.getTransactionTable().get(ctx.getGlobalTransaction()).addRemovedNode(from);
            }
            this.acquireLocksOnChildren(this.peekNode(ctx, from, false, true, false), NodeLock.LockType.WRITE, ctx);
        }
        if (to != null && this.configuration.getIsolationLevel() != IsolationLevel.NONE) {
            if (this.trace) {
                this.log.trace((Object)("Attempting to get RL on new parent [" + to + "]"));
            }
            this.lock(ctx, to, NodeLock.LockType.READ, false, timeout, false, false, null, false);
            this.acquireLocksOnChildren(this.peekNode(ctx, to, false, true, false), NodeLock.LockType.READ, ctx);
        }
        Object retValue = this.nextInterceptor(ctx);
        NodeSPI n = this.peekNode(ctx, from, false, true, false);
        if (n != null) {
            n.getLock().releaseAll(Thread.currentThread());
        }
        return retValue;
    }

    @Override
    protected Object handleRemoveNodeMethod(InvocationContext ctx, GlobalTransaction tx, Fqn fqn, boolean createUndoOps) throws Throwable {
        LinkedList<NodeSPI> createdNodes = new LinkedList<NodeSPI>();
        boolean created = this.acquireLocksWithTimeout(ctx, fqn, NodeLock.LockType.WRITE, true, false, true, false, createdNodes, true);
        if (ctx.getGlobalTransaction() != null) {
            TransactionEntry entry = this.tx_table.get(ctx.getGlobalTransaction());
            entry.addRemovedNode(fqn);
            for (NodeSPI nodeSPI : createdNodes) {
                entry.addRemovedNode(nodeSPI.getFqn());
                nodeSPI.markAsDeleted(true);
            }
        }
        this.acquireLocksOnChildren(this.peekNode(ctx, fqn, false, false, false), NodeLock.LockType.WRITE, ctx);
        if (!createdNodes.isEmpty()) {
            if (this.trace) {
                this.log.trace((Object)"There were new nodes created, skiping notification on delete");
            }
            Object[] args = ctx.getMethodCall().getArgs();
            if (this.trace) {
                this.log.trace((Object)("Changing 'skipNotification' for method '_remove' from " + args[args.length - 1] + " to true"));
            }
            args[args.length - 1] = Boolean.TRUE;
        }
        Object retVal = this.nextInterceptor(ctx);
        if (ctx.getGlobalTransaction() == null) {
            for (NodeSPI nodeSPI : createdNodes) {
                this.cacheImpl.realRemove(nodeSPI.getFqn(), true);
            }
            this.cacheImpl.realRemove(fqn, true);
            NodeSPI n = this.peekNode(ctx, fqn, false, true, false);
            if (n != null) {
                n.getLock().releaseAll(Thread.currentThread());
            }
        }
        return created ? Boolean.valueOf(false) : retVal;
    }

    @Override
    protected Object handlePutForExternalReadMethod(InvocationContext ctx, GlobalTransaction tx, Fqn fqn, Object key, Object value) throws Throwable {
        this.acquireLocksWithTimeout(ctx, fqn, NodeLock.LockType.READ, true, true, false, true, null, false);
        return this.nextInterceptor(ctx);
    }

    @Override
    protected Object handleRemoveKeyMethod(InvocationContext ctx, GlobalTransaction tx, Fqn fqn, Object key, boolean createUndoOps) throws Throwable {
        return this.handleRemoveDataMethod(ctx, tx, fqn, createUndoOps);
    }

    @Override
    protected Object handleRemoveDataMethod(InvocationContext ctx, GlobalTransaction tx, Fqn fqn, boolean createUndoOps) throws Throwable {
        this.acquireLocksWithTimeout(ctx, fqn, NodeLock.LockType.WRITE, false, false, false, false, null, false);
        return this.nextInterceptor(ctx);
    }

    @Override
    protected Object handleAddChildMethod(InvocationContext ctx, GlobalTransaction tx, Fqn parentFqn, Object childName, Node cn, boolean createUndoOps) throws Throwable {
        this.acquireLocksWithTimeout(ctx, parentFqn, NodeLock.LockType.READ, false, false, false, false, null, false);
        return this.nextInterceptor(ctx);
    }

    @Override
    protected Object handleEvictMethod(InvocationContext ctx, Fqn fqn) throws Throwable {
        this.acquireLocksWithTimeout(ctx, fqn, NodeLock.LockType.WRITE, false, true, false, false, null, false);
        return this.nextInterceptor(ctx);
    }

    @Override
    protected Object handleGetKeyValueMethod(InvocationContext ctx, Fqn fqn, Object key, boolean sendNodeEvent) throws Throwable {
        this.acquireLocksWithTimeout(ctx, fqn, NodeLock.LockType.READ, false, false, false, false, null, false);
        return this.nextInterceptor(ctx);
    }

    @Override
    protected Object handleGetNodeMethod(InvocationContext ctx, Fqn fqn) throws Throwable {
        this.acquireLocksWithTimeout(ctx, fqn, NodeLock.LockType.READ, false, false, false, false, null, false);
        return this.nextInterceptor(ctx);
    }

    @Override
    protected Object handleGetKeysMethod(InvocationContext ctx, Fqn fqn) throws Throwable {
        this.acquireLocksWithTimeout(ctx, fqn, NodeLock.LockType.READ, false, false, false, false, null, false);
        return this.nextInterceptor(ctx);
    }

    @Override
    protected Object handleGetChildrenNamesMethod(InvocationContext ctx, Fqn fqn) throws Throwable {
        this.acquireLocksWithTimeout(ctx, fqn, NodeLock.LockType.READ, false, false, false, false, null, false);
        return this.nextInterceptor(ctx);
    }

    @Override
    protected Object handlePrintMethod(InvocationContext ctx, Fqn fqn) throws Throwable {
        this.acquireLocksWithTimeout(ctx, fqn, NodeLock.LockType.READ, false, false, false, false, null, false);
        return this.nextInterceptor(ctx);
    }

    @Override
    protected Object handleReleaseAllLocksMethod(InvocationContext ctx, Fqn fqn) throws Throwable {
        this.acquireLocksWithTimeout(ctx, fqn, NodeLock.LockType.READ, false, false, false, false, null, false);
        return this.nextInterceptor(ctx);
    }

    private boolean acquireLocksWithTimeout(InvocationContext ctx, Fqn fqn, NodeLock.LockType lockType, boolean createIfNotExists, boolean zeroLockTimeout, boolean acquireLockOnParent, boolean reverseRemoveCheck, List<NodeSPI> createdNodes, boolean skipNotification) throws InterruptedException {
        boolean created;
        if (fqn == null || this.configuration.getIsolationLevel() == IsolationLevel.NONE) {
            return false;
        }
        long timeout = zeroLockTimeout ? 0L : ctx.getContextLockAcquisitionTimeout(this.lock_acquisition_timeout);
        long cutoffTime = System.currentTimeMillis() + timeout;
        boolean firstTry = true;
        do {
            if (!firstTry && System.currentTimeMillis() > cutoffTime) {
                throw new TimeoutException("Unable to acquire lock on Fqn " + fqn + " after " + timeout + " millis");
            }
            created = this.lock(ctx, fqn, lockType, createIfNotExists, timeout, acquireLockOnParent, reverseRemoveCheck, createdNodes, skipNotification);
            firstTry = false;
        } while (createIfNotExists && this.peekNode(ctx, fqn, false, true, false) == null);
        return created;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean lock(InvocationContext ctx, Fqn fqn, NodeLock.LockType lockType, boolean createIfNotExists, long timeout, boolean acquireWriteLockOnParent, boolean reverseRemoveCheck, List<NodeSPI> createdNodes, boolean skipNotification) throws TimeoutException, LockingException, InterruptedException {
        Object owner;
        Thread currentThread = Thread.currentThread();
        GlobalTransaction gtx = ctx.getGlobalTransaction();
        boolean created = false;
        if (gtx != null) {
            this.assertTransactionValid(ctx);
        }
        Object object = owner = gtx != null ? gtx : currentThread;
        if (this.trace) {
            this.log.trace((Object)("Attempting to lock node " + fqn + " for owner " + owner));
        }
        long expiryTime = System.currentTimeMillis() + timeout;
        NodeSPI currentNode = this.rootNode;
        NodeSPI parent = null;
        Object childName = null;
        int currentIndex = -1;
        int targetFqnSize = fqn.size();
        while (true) {
            if (currentNode == null) {
                if (!createIfNotExists) {
                    if (!this.trace) return false;
                    this.log.trace((Object)("failed to find or create child " + childName + " of node " + currentNode));
                    return false;
                }
                currentNode = parent.addChildDirect((Object)childName, !skipNotification);
                created = true;
                if (this.trace) {
                    this.log.trace((Object)("Child node was null, so created child node " + childName));
                }
                if (createdNodes != null) {
                    createdNodes.add(currentNode);
                }
            } else if (!currentNode.isValid() && createIfNotExists) {
                currentNode.setValid(true, false);
            }
            NodeLock.LockType lockTypeRequired = NodeLock.LockType.READ;
            if (created || this.writeLockNeeded(ctx, lockType, currentIndex, acquireWriteLockOnParent, createIfNotExists, fqn, currentNode)) {
                lockTypeRequired = NodeLock.LockType.WRITE;
            }
            Fqn currentNodeFqn = currentNode.getFqn();
            this.acquireNodeLock(ctx, currentNode, owner, gtx, lockTypeRequired, timeout);
            this.manageReverseRemove(gtx, currentNode, reverseRemoveCheck);
            NodeSPI repeek = this.peekNode(ctx, currentNodeFqn, true, true, true);
            if (currentNode != repeek) {
                if (this.trace) {
                    this.log.trace((Object)"Was waiting for and obtained a lock on a node that doesn't exist anymore!  Attempting lock acquisition again.");
                }
                currentNode.getLock().releaseAll(owner);
                if (parent == null || this.peekNode(ctx, parent.getFqn(), true, true, true) == null) {
                    if (this.trace) {
                        this.log.trace((Object)"Parent has been deleted again.  Go through the lock method all over again.");
                    }
                    currentNode = this.rootNode;
                    currentIndex = -1;
                    parent = null;
                    continue;
                }
                currentNode = parent;
                --currentIndex;
                parent = null;
                if (System.currentTimeMillis() > expiryTime) {
                    throw new TimeoutException("Unable to acquire lock on child node " + new Fqn<Object>(currentNode.getFqn(), new Object[]{childName}) + " after " + timeout + " millis.");
                }
                if (!this.trace) continue;
                this.log.trace((Object)("Moving one level up, current node is :" + currentNode));
                continue;
            }
            if (++currentIndex == targetFqnSize) {
                return created;
            }
            if (!fqn.isChildOrEquals(currentNode.getFqn())) {
                String message = new StringBuffer("currentNode instance changed the FQN(").append(currentNode.getFqn()).append(") and do not match the FQN on which we want to acquire lock(").append(fqn).append(")").toString();
                this.log.trace((Object)message);
                throw new LockingException(message);
            }
            parent = currentNode;
            childName = fqn.get(currentIndex);
            currentNode = currentNode.getChildDirect((Object)childName);
        }
    }

    private void acquireLocksOnChildren(NodeSPI parentNode, NodeLock.LockType lockType, InvocationContext ctx) throws InterruptedException {
        if (parentNode == null) {
            return;
        }
        long timeout = ctx.getContextLockAcquisitionTimeout(this.lock_acquisition_timeout);
        GlobalTransaction gtx = ctx.getGlobalTransaction();
        Object owner = gtx != null ? gtx : Thread.currentThread();
        Set<NodeLock> acquiredLocks = parentNode.getLock().acquireAll(owner, timeout, lockType);
        if (acquiredLocks.size() > 0) {
            if (gtx != null) {
                this.cache.getTransactionTable().addLocks(gtx, acquiredLocks);
            } else {
                ctx.addInvocationLocksAcquired(acquiredLocks);
            }
        }
    }

    private boolean writeLockNeeded(InvocationContext ctx, NodeLock.LockType lockType, int currentNodeIndex, boolean acquireWriteLockOnParent, boolean createIfNotExists, Fqn targetFqn, NodeSPI currentNode) {
        boolean isTargetNode;
        int treeNodeSize = targetFqn.size();
        boolean bl = isTargetNode = currentNodeIndex == treeNodeSize - 1;
        if (isTargetNode && ctx.getOptionOverrides().isForceWriteLock()) {
            return true;
        }
        if (currentNode.isLockForChildInsertRemove()) {
            if (acquireWriteLockOnParent && currentNodeIndex == treeNodeSize - 2) {
                return true;
            }
            if (!isTargetNode && this.peekNode(ctx, targetFqn.getAncestor(currentNodeIndex + 2), false, false, false) == null) {
                return createIfNotExists;
            }
        }
        return lockType == NodeLock.LockType.WRITE && isTargetNode;
    }

    private void acquireNodeLock(InvocationContext ctx, NodeSPI node, Object owner, GlobalTransaction gtx, NodeLock.LockType lockType, long lockTimeout) throws LockingException, TimeoutException, InterruptedException {
        NodeLock lock = node.getLock();
        boolean acquired = lock.acquire(owner, lockTimeout, lockType);
        if (acquired) {
            if (gtx != null) {
                this.cache.getTransactionTable().recordNodeLock(gtx, lock);
            } else {
                ctx.addInvocationLockAcquired(lock);
            }
        }
    }

    private void manageReverseRemove(GlobalTransaction gtx, NodeSPI childNode, boolean reverseRemoveCheck) {
        boolean needToReverseRemove;
        boolean bl = needToReverseRemove = reverseRemoveCheck && childNode.isDeleted() && this.tx_table.isNodeRemovedInTx(gtx, childNode.getFqn());
        if (gtx != null && needToReverseRemove) {
            childNode.markAsDeleted(false);
        }
    }

    private void commit(GlobalTransaction gtx) {
        TransactionEntry entry;
        if (this.trace) {
            this.log.trace((Object)("committing cache with gtx " + gtx));
        }
        if ((entry = this.tx_table.get(gtx)) == null) {
            this.log.error((Object)("entry for transaction " + gtx + " not found (maybe already committed)"));
            return;
        }
        for (Fqn f : entry.getRemovedNodes()) {
            this.cacheImpl.realRemove(f, false);
        }
    }
}

