/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.AbstractCacheLoader;
import org.jboss.cache.loader.FileCacheLoaderConfig;
import org.jboss.cache.lock.StripedLock;
import org.jboss.util.stream.MarshalledValueInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class FileCacheLoader
extends AbstractCacheLoader {
    File root = null;
    String rootPath = null;
    Log log = LogFactory.getLog(this.getClass());
    protected final StripedLock lock = new StripedLock();
    private FileCacheLoaderConfig config;
    public static final String DATA = "data.dat";
    public static final String DIR_SUFFIX = "fdb";
    public static final Pattern PATH_PATTERN = Pattern.compile("[\\*<>|\"?]");
    public static final Pattern FQN_PATTERN = Pattern.compile("[\\\\\\/:*<>|\"?]");
    private static boolean isOldWindows;

    public FileCacheLoader() {
        float osVersion = -1.0f;
        try {
            osVersion = Float.parseFloat(System.getProperty("os.version").trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        isOldWindows = System.getProperty("os.name").toLowerCase().startsWith("windows") && osVersion < 4.0f;
    }

    @Override
    public void setConfig(CacheLoaderConfig.IndividualCacheLoaderConfig base) {
        String location;
        if (base instanceof FileCacheLoaderConfig) {
            this.config = (FileCacheLoaderConfig)base;
        } else if (base != null) {
            this.config = new FileCacheLoaderConfig(base);
        }
        String string = location = this.config != null ? this.config.getLocation() : null;
        if (location != null && location.length() > 0) {
            this.root = new File(location);
            this.rootPath = this.root.getAbsolutePath() + File.separator;
        }
    }

    @Override
    public CacheLoaderConfig.IndividualCacheLoaderConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create() throws Exception {
        this.lock.acquireLock(Fqn.ROOT, true);
        try {
            if (this.root == null) {
                String tmpLocation = System.getProperty("java.io.tmpdir", "C:\\tmp");
                this.root = new File(tmpLocation);
                this.rootPath = this.root.getAbsolutePath() + File.separator;
            }
            if (!this.root.exists()) {
                boolean created;
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Creating cache loader location " + this.root));
                }
                if (this.config.isCheckCharacterPortability()) {
                    this.isCharacterPortableLocation(this.root.getAbsolutePath());
                }
                if (!(created = this.root.mkdirs())) {
                    throw new IOException("Unable to create cache loader location " + this.root);
                }
            }
            if (!this.root.isDirectory()) {
                throw new IOException("Cache loader location [" + this.root + "] is not a directory!");
            }
            Object var3_3 = null;
            this.lock.releaseLock(Fqn.ROOT);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.lock.releaseLock(Fqn.ROOT);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getChildrenNames(Fqn fqn) throws Exception {
        File parent;
        block4: {
            this.lock.acquireLock(fqn, true);
            parent = this.getDirectory(fqn, false);
            if (parent != null) break block4;
            Set<String> set = null;
            Object var11_5 = null;
            this.lock.releaseLock(fqn);
            return set;
        }
        try {
            File[] children = parent.listFiles();
            HashSet<String> s = new HashSet<String>();
            for (File child : children) {
                if (!child.isDirectory() || !child.getName().endsWith(DIR_SUFFIX)) continue;
                String child_name = child.getName();
                child_name = child_name.substring(0, child_name.lastIndexOf(DIR_SUFFIX) - 1);
                s.add(child_name);
            }
            HashSet<String> hashSet = s.size() == 0 ? null : s;
            Object var11_6 = null;
            this.lock.releaseLock(fqn);
            return hashSet;
        }
        catch (Throwable throwable) {
            Object var11_7 = null;
            this.lock.releaseLock(fqn);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map get(Fqn fqn) throws Exception {
        this.lock.acquireLock(fqn, true);
        try {
            Map map = this.loadAttributes(fqn);
            Object var4_3 = null;
            this.lock.releaseLock(fqn);
            return map;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lock.releaseLock(fqn);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(Fqn fqn) throws Exception {
        this.lock.acquireLock(fqn, true);
        try {
            File f = this.getDirectory(fqn, false);
            boolean bl = f != null;
            Object var5_4 = null;
            this.lock.releaseLock(fqn);
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.lock.releaseLock(fqn);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(Fqn fqn, Object key, Object value) throws Exception {
        this.lock.acquireLock(fqn, true);
        try {
            HashMap<Object, Object> m = this.loadAttributes(fqn);
            if (m == null) {
                m = new HashMap<Object, Object>();
            }
            Object retval = m.put(key, value);
            this.storeAttributes(fqn, m);
            Object object = retval;
            Object var8_7 = null;
            this.lock.releaseLock(fqn);
            return object;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.lock.releaseLock(fqn);
            throw throwable;
        }
    }

    public void put(Fqn fqn, Map attributes) throws Exception {
        this.put(fqn, attributes, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Fqn fqn, Map attributes, boolean erase) throws Exception {
        this.lock.acquireLock(fqn, true);
        try {
            Map m;
            Map map = m = erase ? new HashMap() : this.loadAttributes(fqn);
            if (m == null) {
                m = new HashMap();
            }
            if (attributes != null) {
                m.putAll(attributes);
            }
            this.storeAttributes(fqn, m);
            Object var6_5 = null;
            this.lock.releaseLock(fqn);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.lock.releaseLock(fqn);
            throw throwable;
        }
    }

    void put(Fqn fqn) throws Exception {
        this.getDirectory(fqn, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(Fqn fqn, Object key) throws Exception {
        Map m;
        block3: {
            this.lock.acquireLock(fqn, true);
            try {
                m = this.loadAttributes(fqn);
                if (m != null) break block3;
                Object var5_4 = null;
                Object var7_6 = null;
                this.lock.releaseLock(fqn);
                return var5_4;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.lock.releaseLock(fqn);
                throw throwable;
            }
        }
        Object retval = m.remove(key);
        this.storeAttributes(fqn, m);
        Object v = retval;
        Object var7_7 = null;
        this.lock.releaseLock(fqn);
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Fqn fqn) throws Exception {
        this.lock.acquireLock(fqn, true);
        try {
            boolean flag;
            File dir = this.getDirectory(fqn, false);
            if (dir != null && !(flag = this.removeDirectory(dir, true))) {
                this.log.warn((Object)("failed removing " + fqn));
            }
            Object var5_4 = null;
            this.lock.releaseLock(fqn);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.lock.releaseLock(fqn);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeData(Fqn fqn) throws Exception {
        this.lock.acquireLock(fqn, true);
        try {
            boolean flag;
            File data;
            File f = this.getDirectory(fqn, false);
            if (f != null && (data = new File(f, DATA)).exists() && !(flag = data.delete())) {
                this.log.warn((Object)("failed removing file " + data.getName()));
            }
            Object var6_5 = null;
            this.lock.releaseLock(fqn);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.lock.releaseLock(fqn);
            throw throwable;
        }
    }

    File getDirectory(Fqn fqn, boolean create) {
        File f = new File(this.getFullPath(fqn));
        if (!f.exists()) {
            if (create) {
                f.mkdirs();
            } else {
                return null;
            }
        }
        return f;
    }

    boolean removeDirectory(File dir, boolean include_start_dir) {
        File[] subdirs;
        boolean success = true;
        for (File file : subdirs = dir.listFiles()) {
            if (file.isFile() && file.getName().equals(DATA)) {
                if (file.delete()) continue;
                success = false;
                continue;
            }
            if (!file.isDirectory() || !file.getName().endsWith(DIR_SUFFIX)) continue;
            if (!this.removeDirectory(file, false)) {
                success = false;
            }
            if (file.delete()) continue;
            success = false;
        }
        if (include_start_dir && !dir.equals(this.root)) {
            if (dir.delete()) {
                return success;
            }
            success = false;
        }
        return success;
    }

    String getFullPath(Fqn fqn) {
        StringBuffer sb = new StringBuffer(this.rootPath);
        for (int i = 0; i < fqn.size(); ++i) {
            Object tmp = fqn.get(i);
            String tmp_dir = tmp.toString();
            sb.append(tmp_dir).append(".").append(DIR_SUFFIX).append(File.separator);
        }
        return sb.toString();
    }

    protected Map loadAttributes(Fqn fqn) throws Exception {
        File f = this.getDirectory(fqn, false);
        if (f == null) {
            return null;
        }
        File child = new File(f, DATA);
        if (!child.exists()) {
            return new HashMap(0);
        }
        Map m = null;
        try {
            m = (Map)this.regionAwareUnmarshall(fqn, child);
        }
        catch (FileNotFoundException fnfe) {
            m = Collections.emptyMap();
        }
        return m;
    }

    protected void storeAttributes(Fqn fqn, Map attrs) throws Exception {
        this.regionAwareMarshall(fqn, attrs);
    }

    @Override
    protected void doMarshall(Fqn fqn, Object toMarshall) throws Exception {
        Map attrs = (Map)toMarshall;
        File f = this.getDirectory(fqn, true);
        File child = new File(f, DATA);
        if (!child.exists()) {
            if (this.config.isCheckCharacterPortability()) {
                this.isLengthPortablePath(child.getAbsolutePath());
                this.isCharacterPortableTree(fqn);
            }
            if (!child.createNewFile()) {
                throw new IOException("Unable to create file: " + child);
            }
        }
        FileOutputStream fileOut = new FileOutputStream(child);
        ObjectOutputStream output = new ObjectOutputStream(fileOut);
        this.getMarshaller().objectToObjectStream(attrs, output);
        output.close();
    }

    @Override
    protected Object doUnmarshall(Fqn fqn, Object fromFile) throws Exception {
        FileInputStream fileIn = new FileInputStream((File)fromFile);
        MarshalledValueInputStream input = new MarshalledValueInputStream((InputStream)fileIn);
        Object unmarshalledObj = this.getMarshaller().objectFromObjectStream((ObjectInputStream)input);
        input.close();
        return unmarshalledObj;
    }

    protected boolean isCharacterPortableLocation(String fileAbsolutePath) {
        Matcher matcher = PATH_PATTERN.matcher(fileAbsolutePath);
        if (matcher.find()) {
            this.log.warn((Object)("Cache loader location ( " + fileAbsolutePath + " ) contains one of these characters: '*' '<' '>' '|' '\"' '?'"));
            this.log.warn((Object)"Directories containing these characters are illegal in some operative systems and could lead to portability issues");
            return false;
        }
        return true;
    }

    protected boolean isCharacterPortableTree(Fqn fqn) {
        List elements = fqn.peekElements();
        for (Object anElement : elements) {
            Matcher matcher = FQN_PATTERN.matcher(anElement.toString());
            if (!matcher.find()) continue;
            this.log.warn((Object)("One of the Fqn ( " + fqn + " ) elements contains one of these characters: '*' '<' '>' '|' '\"' '?' '\\' '/' ':' "));
            this.log.warn((Object)"Directories containing these characters are illegal in some operating systems and could lead to portability issues");
            return false;
        }
        return true;
    }

    protected boolean isLengthPortablePath(String absoluteFqnPath) {
        if (isOldWindows && absoluteFqnPath.length() > 255) {
            this.log.warn((Object)("The full absolute path to the fqn that you are trying to store is bigger than 255 characters, this could lead to problems on certain Windows systems: " + absoluteFqnPath));
            return false;
        }
        return true;
    }
}

