/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.loader.AdjListJDBCCacheLoaderConfig;
import org.jboss.cache.loader.ConnectionFactory;

class NonManagedConnectionFactory
implements ConnectionFactory {
    private static final Log log = LogFactory.getLog(NonManagedConnectionFactory.class);
    static final ThreadLocal<Connection> connection = new ThreadLocal();
    private String url;
    private String usr;
    private String pwd;
    private String driverClass;

    NonManagedConnectionFactory() {
    }

    public void setConfig(AdjListJDBCCacheLoaderConfig config) {
        this.url = config.getJdbcURL();
        this.usr = config.getJdbcUser();
        this.pwd = config.getJdbcPassword();
        this.driverClass = config.getDriverClass();
    }

    public void start() throws Exception {
        this.loadDriver(this.driverClass);
    }

    public void prepare(Object tx) {
        Connection con = this.getConnection();
        try {
            if (con.getAutoCommit()) {
                con.setAutoCommit(false);
            }
        }
        catch (Exception e) {
            this.reportAndRethrowError("Failed to set auto-commit", e);
        }
        connection.set(con);
        if (log.isTraceEnabled()) {
            log.trace((Object)("opened tx connection: tx=" + tx + ", con=" + con));
        }
    }

    public Connection getConnection() {
        Connection con = connection.get();
        if (con == null) {
            try {
                con = this.checkoutConnection();
            }
            catch (SQLException e) {
                this.reportAndRethrowError("Failed to get connection for url=" + this.url + ", user=" + this.usr + ", password=" + this.pwd, e);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("using connection: " + con));
        }
        return con;
    }

    public Connection checkoutConnection() throws SQLException {
        return DriverManager.getConnection(this.url, this.usr, this.pwd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Object tx) {
        Connection con = connection.get();
        if (con == null) {
            throw new IllegalStateException("Failed to commit: thread is not associated with the connection!");
        }
        try {
            block5: {
                try {
                    con.commit();
                    if (!log.isTraceEnabled()) break block5;
                    log.trace((Object)("committed tx=" + tx + ", con=" + con));
                }
                catch (SQLException e) {
                    this.reportAndRethrowError("Failed to commit", e);
                    Object var5_4 = null;
                    this.closeTxConnection(con);
                }
            }
            Object var5_3 = null;
            this.closeTxConnection(con);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.closeTxConnection(con);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Object tx) {
        Connection con = connection.get();
        if (con == null) {
            throw new IllegalStateException("Failed to rollback: thread is not associated with the connection!");
        }
        try {
            block5: {
                try {
                    con.rollback();
                    if (!log.isTraceEnabled()) break block5;
                    log.trace((Object)("rolledback tx=" + tx + ", con=" + con));
                }
                catch (SQLException e) {
                    this.reportAndRethrowError("Failed to rollback", e);
                    Object var5_4 = null;
                    this.closeTxConnection(con);
                }
            }
            Object var5_3 = null;
            this.closeTxConnection(con);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.closeTxConnection(con);
            throw throwable;
        }
    }

    public void close(Connection con) {
        if (con != null && con != connection.get()) {
            try {
                con.close();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("closed non tx connection: " + con));
                }
            }
            catch (SQLException e) {
                log.warn((Object)("Failed to close connection " + con), (Throwable)e);
            }
        }
    }

    public void stop() {
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsr() {
        return this.usr;
    }

    public String getPwd() {
        return this.pwd;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    protected void loadDriver(String drv) {
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Attempting to load driver: " + drv));
            }
            Class.forName(drv).newInstance();
        }
        catch (Exception e) {
            this.reportAndRethrowError("Failed to load driver " + drv, e);
        }
    }

    private void closeTxConnection(Connection con) {
        this.safeClose(con);
        connection.set(null);
    }

    private void safeClose(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e) {
                log.warn((Object)"Failed to close connection", (Throwable)e);
            }
        }
    }

    private void reportAndRethrowError(String message, Exception cause) throws IllegalStateException {
        log.error((Object)message, (Throwable)cause);
        throw new IllegalStateException(message, cause);
    }
}

