/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.AbstractCacheLoader;
import org.jboss.cache.loader.TcpDelegatingCacheLoaderConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TcpDelegatingCacheLoader
extends AbstractCacheLoader {
    private Socket sock;
    private TcpDelegatingCacheLoaderConfig config;
    ObjectInputStream in;
    ObjectOutputStream out;
    private static Log log = LogFactory.getLog(TcpDelegatingCacheLoader.class);
    private static Method GET_CHILDREN_METHOD;
    private static Method GET_METHOD;
    private static Method PUT_KEY_METHOD;
    private static Method PUT_DATA_METHOD;
    private static Method REMOVE_KEY_METHOD;
    private static Method REMOVE_METHOD;
    private static Method PUT_MODS_METHOD;
    private static Method EXISTS_METHOD;
    private static Method REMOVE_DATA_METHOD;

    @Override
    public void setConfig(CacheLoaderConfig.IndividualCacheLoaderConfig base) {
        this.config = base instanceof TcpDelegatingCacheLoaderConfig ? (TcpDelegatingCacheLoaderConfig)base : new TcpDelegatingCacheLoaderConfig(base);
    }

    @Override
    public CacheLoaderConfig.IndividualCacheLoaderConfig getConfig() {
        return this.config;
    }

    protected Object invokeWithRetries(Method m, Object ... params) {
        long endTime = System.currentTimeMillis() + (long)this.config.getTimeout();
        do {
            try {
                return m.invoke((Object)this, params);
            }
            catch (IllegalAccessException e) {
                log.error((Object)"Should never get here!", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof IOException) {
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Caught IOException.  Retrying.", (Throwable)e);
                        }
                        Thread.sleep(this.config.getReconnectWaitTime());
                        this.restart();
                    }
                    catch (IOException e1) {
                    }
                    catch (InterruptedException e1) {}
                    continue;
                }
                throw new CacheException("Problems invoking method call!", e);
            }
        } while (System.currentTimeMillis() < endTime);
        throw new CacheException("Unable to communicate with TCPCacheServer(" + this.config.getHost() + ":" + this.config.getPort() + ") after " + this.config.getTimeout() + " millis, with reconnects every " + this.config.getReconnectWaitTime() + " millis.");
    }

    @Override
    public Set<?> getChildrenNames(Fqn fqn) throws Exception {
        return (Set)this.invokeWithRetries(GET_CHILDREN_METHOD, fqn);
    }

    @Override
    public Map<Object, Object> get(Fqn name) throws Exception {
        return (Map)this.invokeWithRetries(GET_METHOD, name);
    }

    @Override
    public boolean exists(Fqn name) throws Exception {
        return (Boolean)this.invokeWithRetries(EXISTS_METHOD, name);
    }

    @Override
    public Object put(Fqn name, Object key, Object value) throws Exception {
        return this.invokeWithRetries(PUT_KEY_METHOD, name, key, value);
    }

    @Override
    public void put(Fqn name, Map<Object, Object> attributes) throws Exception {
        this.invokeWithRetries(PUT_DATA_METHOD, name, attributes);
    }

    @Override
    public void put(List<Modification> modifications) throws Exception {
        this.invokeWithRetries(PUT_MODS_METHOD, modifications);
    }

    @Override
    public Object remove(Fqn fqn, Object key) throws Exception {
        return this.invokeWithRetries(REMOVE_KEY_METHOD, fqn, key);
    }

    @Override
    public void remove(Fqn fqn) throws Exception {
        this.invokeWithRetries(REMOVE_METHOD, fqn);
    }

    @Override
    public void removeData(Fqn fqn) throws Exception {
        this.invokeWithRetries(REMOVE_DATA_METHOD, fqn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<?> _getChildrenNames(Fqn fqn) throws Exception {
        Set cn;
        ObjectOutputStream objectOutputStream = this.out;
        synchronized (objectOutputStream) {
            this.out.reset();
            this.out.writeByte(1);
            this.out.writeObject(fqn);
            this.out.flush();
            Object retval = this.in.readObject();
            if (retval instanceof Exception) {
                throw (Exception)retval;
            }
            cn = (Set)retval;
        }
        if (cn.isEmpty()) {
            return null;
        }
        return cn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<Object, Object> _get(Fqn name) throws Exception {
        ObjectOutputStream objectOutputStream = this.out;
        synchronized (objectOutputStream) {
            this.out.reset();
            this.out.writeByte(3);
            this.out.writeObject(name);
            this.out.flush();
            Object retval = this.in.readObject();
            if (retval instanceof Exception) {
                throw (Exception)retval;
            }
            return (Map)retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean _exists(Fqn name) throws Exception {
        ObjectOutputStream objectOutputStream = this.out;
        synchronized (objectOutputStream) {
            this.out.reset();
            this.out.writeByte(4);
            this.out.writeObject(name);
            this.out.flush();
            Object retval = this.in.readObject();
            if (retval instanceof Exception) {
                throw (Exception)retval;
            }
            return (Boolean)retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object _put(Fqn name, Object key, Object value) throws Exception {
        ObjectOutputStream objectOutputStream = this.out;
        synchronized (objectOutputStream) {
            this.out.reset();
            this.out.writeByte(5);
            this.out.writeObject(name);
            this.out.writeObject(key);
            this.out.writeObject(value);
            this.out.flush();
            Object retval = this.in.readObject();
            if (retval instanceof Exception) {
                throw (Exception)retval;
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _put(Fqn name, Map<Object, Object> attributes) throws Exception {
        ObjectOutputStream objectOutputStream = this.out;
        synchronized (objectOutputStream) {
            this.out.reset();
            this.out.writeByte(6);
            this.out.writeObject(name);
            this.out.writeObject(attributes);
            this.out.flush();
            Object retval = this.in.readObject();
            if (retval instanceof Exception) {
                throw (Exception)retval;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _put(List<Modification> modifications) throws Exception {
        ObjectOutputStream objectOutputStream = this.out;
        synchronized (objectOutputStream) {
            this.out.reset();
            this.out.writeByte(12);
            int length = modifications.size();
            this.out.writeInt(length);
            for (Modification m : modifications) {
                m.writeExternal(this.out);
            }
            this.out.flush();
            Object retval = this.in.readObject();
            if (retval instanceof Exception) {
                throw (Exception)retval;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object _remove(Fqn fqn, Object key) throws Exception {
        ObjectOutputStream objectOutputStream = this.out;
        synchronized (objectOutputStream) {
            this.out.reset();
            this.out.writeByte(7);
            this.out.writeObject(fqn);
            this.out.writeObject(key);
            this.out.flush();
            Object retval = this.in.readObject();
            if (retval instanceof Exception) {
                throw (Exception)retval;
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _remove(Fqn fqn) throws Exception {
        ObjectOutputStream objectOutputStream = this.out;
        synchronized (objectOutputStream) {
            this.out.reset();
            this.out.writeByte(8);
            this.out.writeObject(fqn);
            this.out.flush();
            Object retval = this.in.readObject();
            if (retval instanceof Exception) {
                throw (Exception)retval;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _removeData(Fqn fqn) throws Exception {
        ObjectOutputStream objectOutputStream = this.out;
        synchronized (objectOutputStream) {
            this.out.reset();
            this.out.writeByte(9);
            this.out.writeObject(fqn);
            this.out.flush();
            Object retval = this.in.readObject();
            if (retval instanceof Exception) {
                throw (Exception)retval;
            }
        }
    }

    @Override
    public void start() throws IOException {
        this.sock = new Socket(this.config.getHost(), this.config.getPort());
        this.out = new ObjectOutputStream(new BufferedOutputStream(this.sock.getOutputStream()));
        this.out.flush();
        this.in = new ObjectInputStream(new BufferedInputStream(this.sock.getInputStream()));
    }

    @Override
    public void stop() {
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (this.sock != null) {
                this.sock.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void restart() throws IOException {
        this.stop();
        this.start();
    }

    @Override
    public void loadEntireState(ObjectOutputStream os) throws Exception {
        throw new UnsupportedOperationException("operation is not currently supported - need to define semantics first");
    }

    @Override
    public void loadState(Fqn subtree, ObjectOutputStream os) throws Exception {
        throw new UnsupportedOperationException("operation is not currently supported - need to define semantics first");
    }

    @Override
    public void storeEntireState(ObjectInputStream is) throws Exception {
        throw new UnsupportedOperationException("operation is not currently supported - need to define semantics first");
    }

    @Override
    public void storeState(Fqn subtree, ObjectInputStream is) throws Exception {
        throw new UnsupportedOperationException("operation is not currently supported - need to define semantics first");
    }

    static {
        try {
            GET_CHILDREN_METHOD = TcpDelegatingCacheLoader.class.getDeclaredMethod("_getChildrenNames", Fqn.class);
            GET_METHOD = TcpDelegatingCacheLoader.class.getDeclaredMethod("_get", Fqn.class);
            EXISTS_METHOD = TcpDelegatingCacheLoader.class.getDeclaredMethod("_exists", Fqn.class);
            PUT_KEY_METHOD = TcpDelegatingCacheLoader.class.getDeclaredMethod("_put", Fqn.class, Object.class, Object.class);
            PUT_DATA_METHOD = TcpDelegatingCacheLoader.class.getDeclaredMethod("_put", Fqn.class, Map.class);
            REMOVE_KEY_METHOD = TcpDelegatingCacheLoader.class.getDeclaredMethod("_remove", Fqn.class, Object.class);
            REMOVE_DATA_METHOD = TcpDelegatingCacheLoader.class.getDeclaredMethod("_removeData", Fqn.class);
            REMOVE_METHOD = TcpDelegatingCacheLoader.class.getDeclaredMethod("_remove", Fqn.class);
            PUT_MODS_METHOD = TcpDelegatingCacheLoader.class.getDeclaredMethod("_put", List.class);
        }
        catch (Exception e) {
            log.fatal((Object)"Unable to initialise reflection methods", (Throwable)e);
        }
    }
}

