/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.lock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.lock.LockMap;
import org.jboss.cache.lock.LockStrategy;
import org.jboss.cache.lock.LockStrategyFactory;
import org.jboss.cache.lock.LockStrategyReadCommitted;
import org.jboss.cache.lock.LockingException;
import org.jboss.cache.lock.NodeLock;
import org.jboss.cache.lock.OwnerNotExistedException;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.lock.UpgradeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityLock
implements NodeLock {
    private boolean PRINT_LOCK_DETAILS = Boolean.getBoolean("print_lock_details");
    private static final Log log = LogFactory.getLog(IdentityLock.class);
    private static boolean trace = log.isTraceEnabled();
    private final LockStrategy lock_;
    private final LockMap map_;
    private final boolean mustReacquireRead_;
    private NodeSPI<?, ?> node;

    public IdentityLock(NodeSPI node) {
        this(LockStrategyFactory.getLockStrategy(), node);
        log.trace((Object)"Using default lock level");
    }

    public IdentityLock(IsolationLevel level, NodeSPI node) {
        this(LockStrategyFactory.getLockStrategy(level), node);
    }

    private IdentityLock(LockStrategy strategy, NodeSPI node) {
        this.lock_ = strategy;
        this.mustReacquireRead_ = strategy instanceof LockStrategyReadCommitted;
        this.map_ = new LockMap();
        this.node = node;
    }

    public Node getNode() {
        return this.node;
    }

    @Override
    public Fqn getFqn() {
        if (this.node == null) {
            return null;
        }
        return this.node.getFqn();
    }

    @Override
    public Collection<Object> getReaderOwners() {
        return this.map_.readerOwners();
    }

    @Override
    public Object getWriterOwner() {
        return this.map_.writerOwner();
    }

    @Override
    public boolean acquireWriteLock(Object caller, long timeout) throws LockingException, TimeoutException, InterruptedException {
        if (trace) {
            log.trace((Object)new StringBuffer("acquiring WL: fqn=").append(this.getFqn()).append(", caller=").append(caller).append(", lock=").append(this.toString(this.PRINT_LOCK_DETAILS)));
        }
        boolean flag = this.acquireWriteLock0(caller, timeout);
        if (trace) {
            log.trace((Object)new StringBuffer("acquired WL: fqn=").append(this.getFqn()).append(", caller=").append(caller).append(", lock=").append(this.toString(this.PRINT_LOCK_DETAILS)));
        }
        return flag;
    }

    private boolean acquireWriteLock0(Object caller, long timeout) throws LockingException, TimeoutException, InterruptedException {
        if (caller == null) {
            throw new IllegalArgumentException("acquireWriteLock(): null caller");
        }
        if (this.map_.isOwner(caller, 2)) {
            if (trace) {
                log.trace((Object)("acquireWriteLock(): caller already owns lock for " + this.getFqn() + " (caller=" + caller + ')'));
            }
            return false;
        }
        if (this.map_.isOwner(caller, 1)) {
            Lock wLock;
            try {
                if (trace) {
                    log.trace((Object)("upgrading RL to WL for " + caller + ", timeout=" + timeout + ", locks: " + this.map_.printInfo()));
                }
                wLock = this.lock_.upgradeLockAttempt(timeout);
            }
            catch (UpgradeException ue) {
                String errStr = "acquireWriteLock(): lock upgrade failed for " + this.getFqn() + " (caller=" + caller + ", lock info: " + this.toString(true) + ')';
                log.trace((Object)errStr, (Throwable)ue);
                throw new UpgradeException(errStr, ue);
            }
            if (wLock == null) {
                this.release(caller);
                this.map_.removeReader(caller);
                String errStr = "upgrade lock for " + this.getFqn() + " could not be acquired after " + timeout + " ms." + " Lock map ownership " + this.map_.printInfo() + " (caller=" + caller + ", lock info: " + this.toString(true) + ')';
                log.trace((Object)errStr);
                throw new UpgradeException(errStr);
            }
            try {
                if (trace) {
                    log.trace((Object)("upgrading lock for " + this.getFqn()));
                }
                this.map_.upgrade(caller);
            }
            catch (OwnerNotExistedException ex) {
                throw new UpgradeException("Can't upgrade lock to WL for " + this.getFqn() + ", error in LockMap.upgrade()", ex);
            }
        }
        boolean rc = this.lock_.writeLock().tryLock(timeout, TimeUnit.MILLISECONDS);
        if (!rc) {
            String errStr = "write lock for " + this.getFqn() + " could not be acquired after " + timeout + " ms. " + "Locks: " + this.map_.printInfo() + " (caller=" + caller + ", lock info: " + this.toString(true) + ')';
            log.trace((Object)errStr);
            throw new TimeoutException(errStr);
        }
        this.map_.setWriterIfNotNull(caller);
        return true;
    }

    @Override
    public boolean acquireReadLock(Object caller, long timeout) throws LockingException, TimeoutException, InterruptedException {
        if (trace) {
            log.trace((Object)new StringBuffer("acquiring RL: fqn=").append(this.getFqn()).append(", caller=").append(caller).append(", lock=").append(this.toString(this.PRINT_LOCK_DETAILS)));
        }
        boolean flag = this.acquireReadLock0(caller, timeout);
        if (trace) {
            log.trace((Object)new StringBuffer("acquired RL: fqn=").append(this.getFqn()).append(", caller=").append(caller).append(", lock=").append(this.toString(this.PRINT_LOCK_DETAILS)));
        }
        return flag;
    }

    private boolean acquireReadLock0(Object caller, long timeout) throws LockingException, TimeoutException, InterruptedException {
        if (caller == null) {
            throw new IllegalArgumentException("owner is null");
        }
        boolean hasRead = false;
        boolean hasRequired = false;
        if (this.mustReacquireRead_) {
            hasRequired = this.map_.isOwner(caller, 2);
            if (!hasRequired) {
                hasRead = this.map_.isOwner(caller, 1);
            }
        } else if (this.map_.isOwner(caller, 0)) {
            hasRequired = true;
        }
        if (hasRequired) {
            if (trace) {
                StringBuffer sb = new StringBuffer(64);
                sb.append("acquireReadLock(): caller ").append(caller).append(" already owns lock for ").append(this.getFqn());
                log.trace((Object)sb.toString());
            }
            return false;
        }
        boolean rc = this.lock_.readLock().tryLock(timeout, TimeUnit.MILLISECONDS);
        if (!rc) {
            StringBuffer sb = new StringBuffer();
            sb.append("read lock for ").append(this.getFqn()).append(" could not be acquired by ").append(caller);
            sb.append(" after ").append(timeout).append(" ms. Locks: ").append(this.map_.printInfo());
            sb.append(", lock info: ").append(this.toString(true));
            String errMsg = sb.toString();
            log.trace((Object)errMsg);
            throw new TimeoutException(errMsg);
        }
        if (!hasRead) {
            this.map_.addReader(caller);
        }
        return true;
    }

    @Override
    public void release(Object caller) {
        if (caller == null) {
            throw new IllegalArgumentException("IdentityLock.release(): null owner object.");
        }
        if (this.map_.isOwner(caller, 1)) {
            this.map_.removeReader(caller);
            this.lock_.readLock().unlock();
        } else if (this.map_.isOwner(caller, 2)) {
            this.map_.removeWriter();
            this.lock_.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseAll() {
        try {
            if (this.map_.writerOwner() != null) {
                this.lock_.writeLock().unlock();
            }
            this.map_.releaseReaderOwners(this.lock_);
            Object var2_1 = null;
            this.map_.removeAll();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.map_.removeAll();
            throw throwable;
        }
    }

    public void releaseForce() {
        this.releaseAll();
    }

    @Override
    public boolean isReadLocked() {
        return this.map_.isReadLocked();
    }

    @Override
    public boolean isWriteLocked() {
        return this.map_.writerOwner() != null;
    }

    @Override
    public boolean isLocked() {
        return this.isReadLocked() || this.isWriteLocked();
    }

    @Override
    public boolean isOwner(Object o) {
        return this.map_.isOwner(o, 0);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean print_lock_details) {
        StringBuffer sb = new StringBuffer();
        this.toString(sb, print_lock_details);
        return sb.toString();
    }

    public void toString(StringBuffer sb) {
        this.toString(sb, false);
    }

    public void toString(StringBuffer sb, boolean print_lock_details) {
        Object write_owner;
        Collection<Object> read_owners;
        boolean printed_read_owners = false;
        Collection<Object> collection = read_owners = this.lock_ != null ? this.getReaderOwners() : null;
        if (read_owners != null && read_owners.size() > 0) {
            Iterator<Object> iter = read_owners.iterator();
            read_owners = new ArrayList<Object>(read_owners.size());
            while (iter.hasNext()) {
                read_owners.add(iter.next());
            }
            sb.append("read owners=").append(read_owners);
            printed_read_owners = true;
        } else {
            read_owners = null;
        }
        Object object = write_owner = this.lock_ != null ? this.getWriterOwner() : null;
        if (write_owner != null) {
            if (printed_read_owners) {
                sb.append(", ");
            }
            sb.append("write owner=").append(write_owner);
        }
        if (read_owners == null && write_owner == null) {
            sb.append("<unlocked>");
        }
        if (print_lock_details) {
            sb.append(" (").append(this.lock_.toString()).append(')');
        }
    }

    @Override
    public boolean acquire(Object caller, long timeout, NodeLock.LockType lock_type) throws LockingException, TimeoutException, InterruptedException {
        try {
            if (lock_type == NodeLock.LockType.NONE) {
                return true;
            }
            if (lock_type == NodeLock.LockType.READ) {
                return this.acquireReadLock(caller, timeout);
            }
            return this.acquireWriteLock(caller, timeout);
        }
        catch (UpgradeException e) {
            StringBuffer buf = new StringBuffer("failure upgrading lock: fqn=").append(this.getFqn()).append(", caller=").append(caller).append(", lock=").append(this.toString(true));
            if (trace) {
                log.trace((Object)buf.toString());
            }
            throw new UpgradeException(buf.toString(), e);
        }
        catch (LockingException e) {
            StringBuffer buf = new StringBuffer("failure acquiring lock: fqn=").append(this.getFqn()).append(", caller=").append(caller).append(", lock=").append(this.toString(true));
            if (trace) {
                log.trace((Object)buf.toString());
            }
            throw new LockingException(buf.toString(), e);
        }
        catch (TimeoutException e) {
            StringBuffer buf = new StringBuffer("failure acquiring lock: fqn=").append(this.getFqn()).append(", caller=").append(caller).append(", lock=").append(this.toString(true));
            if (trace) {
                log.trace((Object)buf.toString());
            }
            throw new TimeoutException(buf.toString(), e);
        }
    }

    @Override
    public Set<NodeLock> acquireAll(Object caller, long timeout, NodeLock.LockType lock_type) throws LockingException, TimeoutException, InterruptedException {
        return this.acquireAll(caller, timeout, lock_type, false);
    }

    @Override
    public Set<NodeLock> acquireAll(Object caller, long timeout, NodeLock.LockType lock_type, boolean excludeInternalFqns) throws LockingException, TimeoutException, InterruptedException {
        if (lock_type == NodeLock.LockType.NONE || excludeInternalFqns && this.node.getCache().getInternalFqns().contains(this.getFqn())) {
            return Collections.emptySet();
        }
        HashSet<NodeLock> retval = new HashSet<NodeLock>();
        boolean acquired = this.acquire(caller, timeout, lock_type);
        if (acquired) {
            retval.add(this);
        }
        for (NodeSPI<?, ?> n : this.node.getChildrenDirect()) {
            retval.addAll(n.getLock().acquireAll(caller, timeout, lock_type, excludeInternalFqns));
        }
        return retval;
    }

    @Override
    public void releaseAll(Object owner) {
        for (NodeSPI<?, ?> n : this.node.getChildrenDirect()) {
            n.getLock().releaseAll(owner);
        }
        this.release(owner);
    }

    private void printIndent(StringBuffer sb, int indent) {
        if (sb != null) {
            for (int i = 0; i < indent; ++i) {
                sb.append(" ");
            }
        }
    }

    @Override
    public void printLockInfo(StringBuffer sb, int indent) {
        boolean locked = this.isLocked();
        this.printIndent(sb, indent);
        sb.append("/").append(this.node.getFqn().getLastElement());
        if (locked) {
            sb.append("\t(");
            this.toString(sb);
            sb.append(")");
        }
        for (NodeSPI<?, ?> n : this.node.getChildrenDirect()) {
            sb.append("\n");
            n.getLock().printLockInfo(sb, indent + 4);
        }
    }
}

