/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall.io;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.marshall.io.ReusableObjectInputStream;
import org.jboss.cache.marshall.io.ReusableObjectOutputStream;

public class ObjectStreamPool {
    BlockingQueue<ReusableObjectOutputStream> outputStreams;
    BlockingQueue<ReusableObjectInputStream> inputStreams;
    int numOutputStreams = 1;
    int numInputStreams = 1;
    Configuration configuration;
    Log log = LogFactory.getLog(ObjectStreamPool.class);

    @Inject
    void injectDependencies(Configuration configuration) {
        this.configuration = configuration;
    }

    @Start
    void start() throws InterruptedException, IOException {
        int i;
        if (this.configuration != null) {
            this.numInputStreams = this.configuration.getObjectInputStreamPoolSize();
            this.numOutputStreams = this.configuration.getObjectOutputStreamPoolSize();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Using stream sizes from configuration as input: " + this.numInputStreams + " and output: " + this.numOutputStreams));
            }
        }
        this.outputStreams = new LinkedBlockingQueue<ReusableObjectOutputStream>();
        this.inputStreams = new LinkedBlockingQueue<ReusableObjectInputStream>();
        long start = 0L;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Creating " + this.numOutputStreams + " ReusableObjectOutputStreams and " + this.numInputStreams + " ReusableObjectInputStreams for pool"));
            start = System.currentTimeMillis();
        }
        for (i = 0; i < this.numOutputStreams; ++i) {
            this.outputStreams.put(new ReusableObjectOutputStream());
        }
        for (i = 0; i < this.numInputStreams; ++i) {
            this.inputStreams.put(new ReusableObjectInputStream());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Initialised object stream pool in " + (System.currentTimeMillis() - start) + " millis"));
        }
    }

    public ReusableObjectOutputStream getOutputStream() throws InterruptedException {
        ReusableObjectOutputStream roos = this.outputStreams.take();
        roos.init();
        return roos;
    }

    public ObjectInputStream getInputStream(byte[] buf) throws IOException, InterruptedException {
        ReusableObjectInputStream rois = this.inputStreams.take();
        rois.init(buf);
        return rois;
    }

    public void returnStreamToPool(ReusableObjectOutputStream stream) throws IOException, InterruptedException {
        stream.reset();
        this.outputStreams.put(stream);
    }

    public void returnStreamToPool(ObjectInputStream stream) throws InterruptedException, IOException {
        stream.reset();
        this.inputStreams.put((ReusableObjectInputStream)((Object)stream));
    }
}

