/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.cache.CacheException;
import org.jboss.util.stream.MarshalledValueInputStream;

public class ReusableObjectInputStream
extends MarshalledValueInputStream {
    public static final byte[] INIT_BYTES = new byte[]{-84, -19, 0, 5, 119, 0};
    ResettableByteArrayInputStream bytes;

    public ReusableObjectInputStream() throws IOException, SecurityException {
        this(new ResettableByteArrayInputStream());
    }

    protected ReusableObjectInputStream(ResettableByteArrayInputStream in) throws IOException {
        super((InputStream)in);
        this.bytes = in;
    }

    public void reset() throws IOException {
        this.bytes.reset();
        this.bytes.clear();
    }

    public void init(byte[] buf) throws IOException {
        this.bytes.init(buf);
    }

    static class ResettableByteArrayInputStream
    extends ByteArrayInputStream {
        ResettableByteArrayInputStream() {
            super(INIT_BYTES);
        }

        public void clear() {
            this.buf = null;
        }

        public void init(byte[] b) {
            if (b.length < 4) {
                throw new CacheException("No header bytes!");
            }
            this.buf = b;
            this.count = this.buf.length;
            this.pos = 4;
        }
    }
}

