/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.buddyreplication;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.buddyreplication.BuddyGroupAssignmentTest;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.buddyreplication.BuddyReplicationTestsBase;
import org.jboss.cache.misc.TestingUtil;
import org.jboss.cache.notifications.annotation.CacheBlocked;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.CacheUnblocked;
import org.jboss.cache.notifications.event.Event;
import org.jboss.cache.util.CachePrinter;
import org.jgroups.Address;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"})
public class BuddyReplicationContentTest
extends BuddyReplicationTestsBase {
    private String key = "key";
    private String value = "value";
    private Log log = LogFactory.getLog(BuddyGroupAssignmentTest.class);

    private void assertNoStaleLocks(List<CacheSPI<Object, Object>> caches) {
        for (CacheSPI<Object, Object> cache : caches) {
            this.assertNoStaleLocks(cache);
        }
    }

    private void assertNoStaleLocks(CacheSPI<Object, Object> cache) {
        AssertJUnit.assertEquals((String)("Number of locks in cache instance " + cache + " should be 0"), (int)0, (int)cache.getNumberOfLocksHeld());
    }

    public void testSimplePut() throws Exception {
        this.log.debug((Object)"Running testSimplePut");
        this.caches = this.createCaches(3, false);
        String fqn = "/test";
        String backupFqn = "/_BUDDY_BACKUP_/" + BuddyManager.getGroupNameFromAddress((Object)((CacheSPI)this.caches.get(0)).getLocalAddress()) + fqn;
        this.assertNoStaleLocks(this.caches);
        ((CacheSPI)this.caches.get(0)).put(fqn, (Object)this.key, (Object)this.value);
        this.assertNoStaleLocks(this.caches);
        AssertJUnit.assertEquals((Object)this.value, (Object)((CacheSPI)this.caches.get(0)).get(fqn, (Object)this.key));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheSPI)this.caches.get(1)).get(fqn, (Object)this.key));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheSPI)this.caches.get(2)).get(fqn, (Object)this.key));
        AssertJUnit.assertEquals((String)"Buddy should have data in backup tree", (Object)this.value, (Object)((CacheSPI)this.caches.get(1)).get(backupFqn, (Object)this.key));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheSPI)this.caches.get(2)).get(backupFqn, (Object)this.key));
        this.assertNoStaleLocks(this.caches);
        System.out.println("Cache 0 = " + CachePrinter.printCacheLockingInfo((Cache)((Cache)this.caches.get(0))));
        System.out.println("Cache 1 = " + CachePrinter.printCacheLockingInfo((Cache)((Cache)this.caches.get(1))));
        System.out.println("Cache 2 = " + CachePrinter.printCacheLockingInfo((Cache)((Cache)this.caches.get(2))));
    }

    public void testPutAndRemove() throws Exception {
        this.log.debug((Object)"Running testPutAndRemove");
        this.caches = this.createCaches(3, false);
        String fqn = "/test";
        String backupFqn = "/_BUDDY_BACKUP_/" + BuddyManager.getGroupNameFromAddress((Object)((CacheSPI)this.caches.get(0)).getLocalAddress()) + fqn;
        this.assertNoStaleLocks(this.caches);
        ((CacheSPI)this.caches.get(0)).put(fqn, (Object)this.key, (Object)this.value);
        this.assertNoStaleLocks(this.caches);
        AssertJUnit.assertEquals((Object)this.value, (Object)((CacheSPI)this.caches.get(0)).get(fqn, (Object)this.key));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheSPI)this.caches.get(1)).get(fqn, (Object)this.key));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheSPI)this.caches.get(2)).get(fqn, (Object)this.key));
        AssertJUnit.assertEquals((String)"Buddy should have data in backup tree", (Object)this.value, (Object)((CacheSPI)this.caches.get(1)).get(backupFqn, (Object)this.key));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheSPI)this.caches.get(2)).get(backupFqn, (Object)this.key));
        this.assertNoStaleLocks(this.caches);
        ((CacheSPI)this.caches.get(0)).removeNode(fqn);
        this.assertNoStaleLocks(this.caches);
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheSPI)this.caches.get(0)).get(fqn, (Object)this.key));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheSPI)this.caches.get(1)).get(fqn, (Object)this.key));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheSPI)this.caches.get(2)).get(fqn, (Object)this.key));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheSPI)this.caches.get(0)).get(backupFqn, (Object)this.key));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheSPI)this.caches.get(1)).get(backupFqn, (Object)this.key));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheSPI)this.caches.get(2)).get(backupFqn, (Object)this.key));
        this.assertNoStaleLocks(this.caches);
    }

    public void testPutAndRemove2() throws Exception {
        this.log.debug((Object)"Running testPutAndRemove2");
        this.caches = this.createCaches(2, 4, false);
        String fqn = "/test";
        String backupFqn = "/_BUDDY_BACKUP_/" + BuddyManager.getGroupNameFromAddress((Object)((CacheSPI)this.caches.get(0)).getLocalAddress()) + fqn;
        this.assertNoStaleLocks(this.caches);
        ((CacheSPI)this.caches.get(0)).put(fqn, (Object)this.key, (Object)this.value);
        this.assertNoStaleLocks(this.caches);
        AssertJUnit.assertEquals((Object)this.value, (Object)((CacheSPI)this.caches.get(0)).get(fqn, (Object)this.key));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheSPI)this.caches.get(1)).get(fqn, (Object)this.key));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheSPI)this.caches.get(2)).get(fqn, (Object)this.key));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheSPI)this.caches.get(3)).get(fqn, (Object)this.key));
        AssertJUnit.assertEquals((String)"Buddy should have data in backup tree", (Object)this.value, (Object)((CacheSPI)this.caches.get(1)).get(backupFqn, (Object)this.key));
        AssertJUnit.assertEquals((String)"Buddy should have data in backup tree", (Object)this.value, (Object)((CacheSPI)this.caches.get(2)).get(backupFqn, (Object)this.key));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheSPI)this.caches.get(3)).get(backupFqn, (Object)this.key));
        this.assertNoStaleLocks(this.caches);
        ((CacheSPI)this.caches.get(0)).removeNode(fqn);
        this.assertNoStaleLocks(this.caches);
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheSPI)this.caches.get(0)).get(fqn, (Object)this.key));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheSPI)this.caches.get(1)).get(fqn, (Object)this.key));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheSPI)this.caches.get(2)).get(fqn, (Object)this.key));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheSPI)this.caches.get(3)).get(fqn, (Object)this.key));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheSPI)this.caches.get(0)).get(backupFqn, (Object)this.key));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheSPI)this.caches.get(1)).get(backupFqn, (Object)this.key));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheSPI)this.caches.get(2)).get(backupFqn, (Object)this.key));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheSPI)this.caches.get(3)).get(backupFqn, (Object)this.key));
        this.assertNoStaleLocks(this.caches);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBuddyJoin() throws Exception {
        this.log.debug((Object)"Running testBuddyJoin");
        this.caches = this.createCaches(2, false);
        CacheSPI<Object, Object> cache2 = null;
        try {
            Fqn fqn = Fqn.fromString((String)"/test");
            Fqn backupFqn = BuddyManager.getBackupFqn((Address)((CacheSPI)this.caches.get(1)).getLocalAddress(), (Fqn)fqn);
            this.assertNoStaleLocks(this.caches);
            ((CacheSPI)this.caches.get(1)).put(fqn, (Object)this.key, (Object)this.value);
            this.assertNoStaleLocks(this.caches);
            AssertJUnit.assertEquals((Object)this.value, (Object)((CacheSPI)this.caches.get(1)).get(fqn, (Object)this.key));
            AssertJUnit.assertFalse((String)"Should be false", (boolean)((CacheSPI)this.caches.get(0)).exists(fqn));
            AssertJUnit.assertEquals((String)"Buddy should have data in backup tree", (Object)this.value, (Object)((CacheSPI)this.caches.get(0)).get(backupFqn, (Object)this.key));
            this.assertNoStaleLocks(this.caches);
            cache2 = this.createCache(1, null);
            TestingUtil.blockUntilViewsReceived(3000L, new Cache[]{(Cache)this.caches.get(0), (Cache)this.caches.get(1), cache2});
            TestingUtil.sleepThread(2000L);
            ArrayList<CacheSPI<Object, Object>> dump = new ArrayList<CacheSPI<Object, Object>>(this.caches);
            dump.add(cache2);
            this.dumpCacheContents(dump);
            this.assertIsBuddy((Cache)this.caches.get(1), (Cache)cache2, true);
            this.assertIsBuddy((Cache)this.caches.get(0), (Cache)this.caches.get(1), true);
            this.assertIsBuddy((Cache)cache2, (Cache)this.caches.get(0), true);
            AssertJUnit.assertFalse((String)"This backup data should have been removed", (boolean)((CacheSPI)this.caches.get(0)).exists(backupFqn));
            AssertJUnit.assertEquals((String)"Backup state should have been transferred to this new cache instance", (Object)this.value, (Object)cache2.get(backupFqn, (Object)this.key));
            ((CacheSPI)this.caches.get(1)).removeNode(fqn);
            this.assertNoStaleLocks(this.caches);
            AssertJUnit.assertFalse((String)"Should be null", (boolean)((CacheSPI)this.caches.get(0)).exists(fqn));
            AssertJUnit.assertFalse((String)"Should be null", (boolean)((CacheSPI)this.caches.get(1)).exists(fqn));
            AssertJUnit.assertFalse((String)"Should be null", (boolean)cache2.exists(fqn));
            AssertJUnit.assertFalse((String)"Should be null", (boolean)((CacheSPI)this.caches.get(0)).exists(backupFqn));
            AssertJUnit.assertFalse((String)"Should be null", (boolean)((CacheSPI)this.caches.get(1)).exists(backupFqn));
            AssertJUnit.assertFalse((String)"Should be null", (boolean)cache2.exists(backupFqn));
            this.assertNoStaleLocks(this.caches);
        }
        finally {
            if (cache2 != null) {
                cache2.stop();
            }
        }
    }

    public void testCompleteStateSurvival() throws Exception {
        this.log.debug((Object)"Running testCompleteStateSurvival");
        this.caches = null;
        this.caches = this.createCaches(3, false, true);
        CacheBlockListener blockListener = new CacheBlockListener();
        ((CacheSPI)this.caches.get(0)).addCacheListener((Object)blockListener);
        ((CacheSPI)this.caches.get(1)).addCacheListener((Object)blockListener);
        ((CacheSPI)this.caches.get(2)).addCacheListener((Object)blockListener);
        ((CacheSPI)this.caches.get(0)).put("/0", (Object)"key", (Object)"value");
        ((CacheSPI)this.caches.get(1)).put("/1", (Object)"key", (Object)"value");
        ((CacheSPI)this.caches.get(2)).put("/2", (Object)"key", (Object)"value");
        blockListener.blockUntilAllCachesAreUnblocked(((CacheSPI)this.caches.get(0)).getConfiguration().getStateRetrievalTimeout() * 3L);
        this.log.info((Object)"stopping 2");
        ((CacheSPI)this.caches.get(2)).stop();
        blockListener.blockUntilAllCachesAreUnblocked(((CacheSPI)this.caches.get(0)).getConfiguration().getStateRetrievalTimeout() * 5L);
        AssertJUnit.assertEquals((Object)"value", (Object)((CacheSPI)this.caches.get(0)).get("/2", (Object)"key"));
        blockListener.blockUntilAllCachesAreUnblocked(((CacheSPI)this.caches.get(0)).getConfiguration().getStateRetrievalTimeout() * 5L);
        ((CacheSPI)this.caches.get(1)).stop();
        AssertJUnit.assertEquals((Object)"value", (Object)((CacheSPI)this.caches.get(0)).get("/0", (Object)"key"));
        try {
            AssertJUnit.assertEquals((Object)"value", (Object)((CacheSPI)this.caches.get(0)).get("/1", (Object)"key"));
        }
        catch (RuntimeException e) {
            AssertJUnit.assertEquals(IllegalArgumentException.class, e.getCause().getClass());
        }
        System.out.println("Cache contents " + CachePrinter.printCacheDetails((Cache)((Cache)this.caches.get(0))));
        AssertJUnit.assertEquals((Object)"value", (Object)((CacheSPI)this.caches.get(0)).get("/1", (Object)"key"));
        AssertJUnit.assertEquals((Object)"value", (Object)((CacheSPI)this.caches.get(0)).get("/2", (Object)"key"));
    }

    @CacheListener
    public static class CacheBlockListener {
        private int blocks = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CacheBlocked
        public void processBlock(Event e) {
            if (e.isPre()) {
                System.out.println(">>>>>>>> Got BLOCK on cache " + e.getCache().getLocalAddress());
                CacheBlockListener cacheBlockListener = this;
                synchronized (cacheBlockListener) {
                    ++this.blocks;
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CacheUnblocked
        public void processUnblock(Event e) {
            if (e.isPre()) {
                System.out.println(">>>>>>>> Got UNBLOCK on cache " + e.getCache().getLocalAddress());
                CacheBlockListener cacheBlockListener = this;
                synchronized (cacheBlockListener) {
                    --this.blocks;
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void blockUntilAllCachesAreUnblocked(long maxWait) throws InterruptedException {
            CacheBlockListener cacheBlockListener = this;
            synchronized (cacheBlockListener) {
                if (this.blocks > 1) {
                    this.wait(maxWait);
                }
                this.blocks = 0;
            }
        }
    }
}

