/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.config;

import java.util.HashSet;
import java.util.List;
import org.jboss.cache.Fqn;
import org.jboss.cache.RegionManager;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionPolicyConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.EvictionPolicy;
import org.jboss.cache.eviction.LRUPolicy;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional", "jgroups", "transaction"})
public class EvictionRegionConfigurationTest {
    public void testDuplicateDefaultRegion() throws Exception {
        EvictionConfig ec = new EvictionConfig();
        ec.setDefaultEvictionPolicyClass(LRUPolicy.class.getName());
        List ercs = ec.getEvictionRegionConfigs();
        EvictionRegionConfig erc = new EvictionRegionConfig();
        erc.setRegionFqn(RegionManager.DEFAULT_REGION);
        EvictionPolicy policy = (EvictionPolicy)LRUPolicy.class.newInstance();
        erc.setEvictionPolicyConfig((EvictionPolicyConfig)policy.getEvictionConfigurationClass().newInstance());
        ercs.add(erc);
        ec.setEvictionRegionConfigs(ercs);
        ercs = ec.getEvictionRegionConfigs();
        HashSet<Fqn> fqns = new HashSet<Fqn>();
        for (EvictionRegionConfig cfg : ercs) {
            if (fqns.contains(cfg.getRegionFqn())) {
                AssertJUnit.fail((String)("duplicate region fqn " + cfg.getRegionFqn()));
            }
            fqns.add(cfg.getRegionFqn());
        }
    }
}

