/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.config.EvictionPolicyConfig;
import org.jboss.cache.eviction.MRUConfiguration;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.xml.XmlHelper;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

@Test(groups={"functional"})
public class MRUConfigurationTest {
    MRUConfiguration config = null;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.config = new MRUConfiguration();
    }

    public void testXMLParsing() throws Exception {
        String xml = "<region name=\"/org/jboss/data\">\n<attribute name=\"maxNodes\">5000</attribute>\n</region>";
        Element element = XmlHelper.stringToElement((String)xml);
        XmlConfigurationParser.parseEvictionPolicyConfig((Element)element, (EvictionPolicyConfig)this.config);
        AssertJUnit.assertEquals((int)5000, (int)this.config.getMaxNodes());
    }

    public void testXMLParsing2() throws Exception {
        String xml = "<region name=\"/Test/\">\n<attribute name=\"maxNodes\">10000</attribute>\n</region>";
        Element element = XmlHelper.stringToElement((String)xml);
        XmlConfigurationParser.parseEvictionPolicyConfig((Element)element, (EvictionPolicyConfig)this.config);
        AssertJUnit.assertEquals((int)10000, (int)this.config.getMaxNodes());
    }

    public void testXMLParsing3() throws Exception {
        String xml = "<region name=\"/Test/\">\n</region>";
        Element element = XmlHelper.stringToElement((String)xml);
        boolean caught = false;
        try {
            XmlConfigurationParser.parseEvictionPolicyConfig((Element)element, (EvictionPolicyConfig)this.config);
        }
        catch (ConfigurationException ce) {
            caught = true;
        }
        AssertJUnit.assertTrue((String)"Configure exception should have been caught, maxNodes is required", (boolean)caught);
        xml = "<region name=\"/Test/\">\n<attribute name=\"maxNodes\">10000</attribute>\n</region>";
        element = XmlHelper.stringToElement((String)xml);
        XmlConfigurationParser.parseEvictionPolicyConfig((Element)element, (EvictionPolicyConfig)this.config);
        AssertJUnit.assertEquals((int)10000, (int)this.config.getMaxNodes());
    }
}

