/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.invalidation;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.misc.TestingUtil;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"functional", "jgroups"})
public class VersionInconsistencyTest {
    private Cache cache1;
    private Cache cache2;
    private TransactionManager tm1;
    private TransactionManager tm2;
    private Fqn node = Fqn.fromString((String)"/a");

    @BeforeTest
    public void setUp() {
        this.cache1 = new DefaultCacheFactory().createCache(false);
        this.cache2 = new DefaultCacheFactory().createCache(false);
        this.cache1.getConfiguration().setCacheMode(Configuration.CacheMode.INVALIDATION_SYNC);
        this.cache2.getConfiguration().setCacheMode(Configuration.CacheMode.INVALIDATION_SYNC);
        this.cache1.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        this.cache2.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        this.cache1.getConfiguration().setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        this.cache2.getConfiguration().setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        this.cache1.start();
        this.cache2.start();
        this.tm1 = this.cache1.getConfiguration().getRuntimeConfig().getTransactionManager();
        this.tm2 = this.cache2.getConfiguration().getRuntimeConfig().getTransactionManager();
        TestingUtil.blockUntilViewsReceived(1000L, this.cache1, this.cache2);
    }

    @AfterTest
    public void tearDown() {
        this.cache1.stop();
        this.cache2.stop();
    }

    public void dataInconsistency() throws Exception {
        this.tm1.begin();
        this.cache1.put(this.node, (Object)"k", (Object)"v-older");
        Transaction t1 = this.tm1.suspend();
        this.tm2.begin();
        this.cache2.put(this.node, (Object)"k", (Object)"v-newer");
        this.tm2.commit();
        this.tm1.resume(t1);
        try {
            this.tm1.commit();
            assert (false) : "Should not be allowed to commit with older data!!";
        }
        catch (Exception good) {
            // empty catch block
        }
        Object val = this.cache1.get(this.node, (Object)"k");
        System.out.println("val = " + val);
        assert (val == null) : "Older data should not have committed";
        val = this.cache2.get(this.node, (Object)"k");
        System.out.println("val = " + val);
        assert (val.equals("v-newer"));
        NodeSPI n = ((CacheSPI)this.cache1).peek(this.node, true, true);
        assert (((DefaultDataVersion)n.getVersion()).getRawVersion() == 1L) : "Version should be 1";
    }
}

