/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.io.File;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.loader.CacheLoaderTestsBase;
import org.jboss.cache.misc.TestingUtil;
import org.jboss.cache.xml.XmlHelper;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

@Test(groups={"functional"})
public class ChainingCacheLoaderBasicTest
extends CacheLoaderTestsBase {
    private String loc1 = System.getProperty("java.io.tmpdir", ".") + File.separator + "JBossCache-ChainingCacheLoaderBasicTest-1";
    private String loc2 = System.getProperty("java.io.tmpdir", ".") + File.separator + "JBossCache-ChainingCacheLoaderBasicTest-2";

    public ChainingCacheLoaderBasicTest() {
        File dir1 = new File(this.loc1);
        File dir2 = new File(this.loc2);
        if (!dir1.exists()) {
            dir1.mkdirs();
        }
        if (!dir2.exists()) {
            dir2.mkdirs();
        }
    }

    protected void configureCache() throws Exception {
        this.cache.getConfiguration().setCacheLoaderConfig(this.getCacheLoaderConfig(this.loc1, this.loc2));
        TestingUtil.recursiveFileRemove(this.loc1);
        TestingUtil.recursiveFileRemove(this.loc2);
    }

    protected CacheLoaderConfig getCacheLoaderConfig(String loc1, String loc2) throws Exception {
        String xml = "<config>\n<passivation>false</passivation>\n<preload></preload>\n<cacheloader>\n<class>org.jboss.cache.loader.FileCacheLoader</class>\n<properties> location=" + loc1 + "\n" + "</properties>\n" + "<async>false</async>\n" + "<fetchPersistentState>true</fetchPersistentState>\n" + "</cacheloader>\n" + "<cacheloader>\n" + "<class>org.jboss.cache.loader.FileCacheLoader</class>\n" + "<properties>" + " location=" + loc2 + "\n" + "</properties>\n" + "<async>false</async>\n" + "<fetchPersistentState>false</fetchPersistentState>\n" + "</cacheloader>\n" + "</config>";
        Element element = XmlHelper.stringToElement((String)xml);
        return XmlConfigurationParser.parseCacheLoaderConfig((Element)element);
    }
}

