/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.util.Properties;
import org.jboss.cache.Fqn;
import org.jboss.cache.loader.CacheLoaderTestsBase;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class JDBCCacheLoaderTest
extends CacheLoaderTestsBase {
    protected void configureCache() throws Exception {
        Properties prop = this.getProperties();
        String props = "cache.jdbc.driver =" + prop.getProperty("cache.jdbc.driver") + "\n" + "cache.jdbc.url=" + prop.getProperty("cache.jdbc.url") + "\n" + "cache.jdbc.user=" + prop.getProperty("cache.jdbc.user") + "\n" + "cache.jdbc.password=" + prop.getProperty("cache.jdbc.password") + "\n" + "cache.jdbc.node.type=" + prop.getProperty("cache.jdbc.node.type") + "\n" + "cache.jdbc.sql-concat=" + prop.getProperty("cache.jdbc.sql-concat") + "\n" + "cache.jdbc.table.name=" + prop.getProperty("cache.jdbc.table.name") + "\n" + "cache.jdbc.table.drop=false";
        this.cache.getConfiguration().setCacheLoaderConfig(this.getSingleCacheLoaderConfig("", "org.jboss.cache.loader.JDBCCacheLoader", props, false, true, false));
    }

    public void testLargeObject() {
        try {
            String key = "LargeObj";
            StringBuffer text = new StringBuffer("LargeObject");
            while (text.toString().getBytes().length < 102400) {
                text.append(text);
            }
            String initialValue = text.toString();
            this.loader.remove(Fqn.fromString((String)"/"));
            Object retVal = this.loader.put(FQN, (Object)key, (Object)initialValue);
            AssertJUnit.assertNull((Object)retVal);
            this.addDelay();
            AssertJUnit.assertEquals((String)initialValue, (String)((String)this.loader.get(FQN).get(key)));
            String updatedValue = initialValue.concat("UpdatedValue");
            retVal = this.loader.put(FQN, (Object)key, (Object)updatedValue);
            AssertJUnit.assertEquals((String)initialValue, (String)((String)retVal));
            AssertJUnit.assertEquals((String)updatedValue, (String)((String)this.loader.get(FQN).get(key)));
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
    }

    protected Properties getProperties() throws Exception {
        Properties properties = new Properties();
        try {
            properties.load(this.getClass().getClassLoader().getResourceAsStream("cache-jdbc.properties"));
            return properties;
        }
        catch (Exception e) {
            throw new Exception("Error loading jdbc properties ", e);
        }
    }

    public void testRootIsCreated() throws Exception {
        this.loader.put(Fqn.fromString((String)"/a/b/c"), (Object)"a", (Object)"b");
        AssertJUnit.assertTrue((boolean)this.loader.exists(Fqn.ROOT));
    }
}

