/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.loader.AbstractCacheLoaderTestBase;
import org.jboss.cache.loader.AbstractDelegatingCacheLoader;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.DummyInMemoryCacheLoader;
import org.jboss.cache.loader.SingletonStoreCacheLoader;
import org.jboss.cache.loader.SingletonStoreDefaultConfig;
import org.jboss.cache.xml.XmlHelper;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"})
public class SingletonStoreCacheLoaderTest
extends AbstractCacheLoaderTestBase {
    private static final Log log = LogFactory.getLog(SingletonStoreCacheLoaderTest.class);
    private CacheSPI<Object, Object> cache1;
    private CacheSPI<Object, Object> cache2;
    private CacheSPI<Object, Object> cache3;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.cache1 = (CacheSPI)new DefaultCacheFactory().createCache(UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_SYNC), false);
        this.cache2 = (CacheSPI)new DefaultCacheFactory().createCache(UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_SYNC), false);
        this.cache3 = (CacheSPI)new DefaultCacheFactory().createCache(UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_SYNC), false);
    }

    public void testPutCacheLoaderWithNoPush() throws Exception {
        this.initSingletonNonPushCache(this.cache1);
        this.initSingletonNonPushCache(this.cache2);
        this.initSingletonNonPushCache(this.cache3);
        this.createCaches();
        this.statCaches();
        this.cache1.put(this.fqn("/test1"), (Object)"key", (Object)"value");
        this.cache2.put(this.fqn("/test2"), (Object)"key", (Object)"value");
        this.cache3.put(this.fqn("/test3"), (Object)"key", (Object)"value");
        CacheLoader cl1 = this.getDelegatingCacheLoader(this.cache1);
        CacheLoader cl2 = this.getDelegatingCacheLoader(this.cache2);
        CacheLoader cl3 = this.getDelegatingCacheLoader(this.cache3);
        AssertJUnit.assertTrue((String)"/test1 should have been entered in cl1", (boolean)cl1.exists(this.fqn("/test1")));
        AssertJUnit.assertTrue((String)"/test2 should have been entered in cl1", (boolean)cl1.exists(this.fqn("/test2")));
        AssertJUnit.assertTrue((String)"/test3 should have been entered in cl1", (boolean)cl1.exists(this.fqn("/test3")));
        AssertJUnit.assertFalse((String)"/test1 should not be in cl2", (boolean)cl2.exists(this.fqn("/test1")));
        AssertJUnit.assertFalse((String)"/test2 should not be in cl2", (boolean)cl2.exists(this.fqn("/test2")));
        AssertJUnit.assertFalse((String)"/test3 should not be in cl2", (boolean)cl2.exists(this.fqn("/test3")));
        AssertJUnit.assertFalse((String)"/test1 should not be in cl3", (boolean)cl3.exists(this.fqn("/test1")));
        AssertJUnit.assertFalse((String)"/test2 should not be in cl3", (boolean)cl3.exists(this.fqn("/test2")));
        AssertJUnit.assertFalse((String)"/test3 should not be in cl3", (boolean)cl3.exists(this.fqn("/test3")));
        this.stopCache1();
        this.cache2.put(this.fqn("/test4"), (Object)"key", (Object)"value");
        this.cache3.put(this.fqn("/test5"), (Object)"key", (Object)"value");
        AssertJUnit.assertTrue((String)"/test4 should have been entered in cl2", (boolean)cl2.exists(this.fqn("/test4")));
        AssertJUnit.assertTrue((String)"/test5 should have been entered in cl2", (boolean)cl2.exists(this.fqn("/test5")));
        AssertJUnit.assertFalse((String)"/test4 should not be in cl3", (boolean)cl3.exists(this.fqn("/test4")));
        AssertJUnit.assertFalse((String)"/test5 should not be in cl3", (boolean)cl3.exists(this.fqn("/test5")));
        this.stopCache2();
        this.cache3.put(this.fqn("/test6"), (Object)"key", (Object)"value");
        AssertJUnit.assertTrue((String)"/test5 should have been entered in cl3", (boolean)cl3.exists(Fqn.fromString((String)"/test6")));
    }

    public void testPutCacheLoaderWithPush() throws Exception {
        this.initSingletonWithPushCache(this.cache1);
        this.initSingletonWithPushCache(this.cache2);
        this.initSingletonWithPushCache(this.cache3);
        this.createCaches();
        this.statCaches();
        this.cache1.put(this.fqn("/a"), (Object)"a-key", (Object)"a-value");
        this.cache1.put(this.fqn("/a"), (Object)"aa-key", (Object)"aa-value");
        this.cache1.put(this.fqn("/a/b"), (Object)"b-key", (Object)"b-value");
        this.cache1.put(this.fqn("/a/b"), (Object)"bb-key", (Object)"bb-value");
        this.cache1.put(this.fqn("/a/b/c"), (Object)"c-key", (Object)"c-value");
        this.cache1.put(this.fqn("/a/b/d"), (Object)"d-key", (Object)"d-value");
        this.cache1.put(this.fqn("/e"), (Object)"e-key", (Object)"e-value");
        this.cache1.put(this.fqn("/e/f/g"), (Object)"g-key", (Object)"g-value");
        CacheLoader cl1 = this.getDelegatingCacheLoader(this.cache1);
        CacheLoader cl2 = this.getDelegatingCacheLoader(this.cache2);
        CacheLoader cl3 = this.getDelegatingCacheLoader(this.cache3);
        AssertJUnit.assertTrue((boolean)cl1.get(this.fqn("/a")).containsKey("a-key"));
        AssertJUnit.assertTrue((boolean)cl1.get(this.fqn("/a")).containsKey("aa-key"));
        AssertJUnit.assertTrue((boolean)cl1.get(this.fqn("/a/b")).containsKey("b-key"));
        AssertJUnit.assertTrue((boolean)cl1.get(this.fqn("/a/b")).containsKey("bb-key"));
        AssertJUnit.assertTrue((boolean)cl1.get(this.fqn("/a/b/c")).containsKey("c-key"));
        AssertJUnit.assertTrue((boolean)cl1.get(this.fqn("/a/b/d")).containsKey("d-key"));
        AssertJUnit.assertTrue((boolean)cl1.get(this.fqn("/e")).containsKey("e-key"));
        AssertJUnit.assertTrue((boolean)cl1.get(this.fqn("/e/f/g")).containsKey("g-key"));
        AssertJUnit.assertFalse((boolean)cl2.exists(this.fqn("/a")));
        AssertJUnit.assertFalse((boolean)cl2.exists(this.fqn("/a")));
        AssertJUnit.assertFalse((boolean)cl2.exists(this.fqn("/a/b")));
        AssertJUnit.assertFalse((boolean)cl2.exists(this.fqn("/a/b")));
        AssertJUnit.assertFalse((boolean)cl2.exists(this.fqn("/a/b/c")));
        AssertJUnit.assertFalse((boolean)cl2.exists(this.fqn("/a/b/d")));
        AssertJUnit.assertFalse((boolean)cl2.exists(this.fqn("/e")));
        AssertJUnit.assertFalse((boolean)cl2.exists(this.fqn("/e/f/g")));
        AssertJUnit.assertFalse((boolean)cl3.exists(this.fqn("/a")));
        AssertJUnit.assertFalse((boolean)cl3.exists(this.fqn("/a")));
        AssertJUnit.assertFalse((boolean)cl3.exists(this.fqn("/a/b")));
        AssertJUnit.assertFalse((boolean)cl3.exists(this.fqn("/a/b")));
        AssertJUnit.assertFalse((boolean)cl3.exists(this.fqn("/a/b/c")));
        AssertJUnit.assertFalse((boolean)cl3.exists(this.fqn("/a/b/d")));
        AssertJUnit.assertFalse((boolean)cl3.exists(this.fqn("/e")));
        AssertJUnit.assertFalse((boolean)cl3.exists(this.fqn("/e/f/g")));
        this.stopCache1();
        Thread.sleep(1000L);
        SingletonStoreCacheLoader scl2 = (SingletonStoreCacheLoader)this.cache2.getCacheLoaderManager().getCacheLoader();
        this.waitForPushStateCompletion(scl2.getPushStateFuture());
        AssertJUnit.assertTrue((boolean)cl2.get(this.fqn("/a")).containsKey("a-key"));
        AssertJUnit.assertTrue((boolean)cl2.get(this.fqn("/a")).containsKey("aa-key"));
        AssertJUnit.assertTrue((boolean)cl2.get(this.fqn("/a/b")).containsKey("b-key"));
        AssertJUnit.assertTrue((boolean)cl2.get(this.fqn("/a/b")).containsKey("bb-key"));
        AssertJUnit.assertTrue((boolean)cl2.get(this.fqn("/a/b/c")).containsKey("c-key"));
        AssertJUnit.assertTrue((boolean)cl2.get(this.fqn("/a/b/d")).containsKey("d-key"));
        AssertJUnit.assertTrue((boolean)cl2.get(this.fqn("/e")).containsKey("e-key"));
        AssertJUnit.assertTrue((boolean)cl2.get(this.fqn("/e/f/g")).containsKey("g-key"));
        this.cache2.put(this.fqn("/e/f/h"), (Object)"h-key", (Object)"h-value");
        this.cache3.put(this.fqn("/i"), (Object)"i-key", (Object)"i-value");
        AssertJUnit.assertTrue((boolean)cl2.get(this.fqn("/e/f/h")).containsKey("h-key"));
        AssertJUnit.assertTrue((boolean)cl2.get(this.fqn("/i")).containsKey("i-key"));
        AssertJUnit.assertFalse((boolean)cl3.exists(this.fqn("/a")));
        AssertJUnit.assertFalse((boolean)cl3.exists(this.fqn("/a")));
        AssertJUnit.assertFalse((boolean)cl3.exists(this.fqn("/a/b")));
        AssertJUnit.assertFalse((boolean)cl3.exists(this.fqn("/a/b")));
        AssertJUnit.assertFalse((boolean)cl3.exists(this.fqn("/a/b/c")));
        AssertJUnit.assertFalse((boolean)cl3.exists(this.fqn("/a/b/d")));
        AssertJUnit.assertFalse((boolean)cl3.exists(this.fqn("/e")));
        AssertJUnit.assertFalse((boolean)cl3.exists(this.fqn("/e/f/g")));
        AssertJUnit.assertFalse((boolean)cl3.exists(this.fqn("/e/f/h")));
        AssertJUnit.assertFalse((boolean)cl3.exists(this.fqn("/i")));
        this.stopCache2();
        Thread.sleep(1000L);
        SingletonStoreCacheLoader scl3 = (SingletonStoreCacheLoader)this.cache3.getCacheLoaderManager().getCacheLoader();
        this.waitForPushStateCompletion(scl3.getPushStateFuture());
        AssertJUnit.assertTrue((boolean)cl3.get(this.fqn("/a")).containsKey("a-key"));
        AssertJUnit.assertTrue((boolean)cl3.get(this.fqn("/a")).containsKey("aa-key"));
        AssertJUnit.assertTrue((boolean)cl3.get(this.fqn("/a/b")).containsKey("b-key"));
        AssertJUnit.assertTrue((boolean)cl3.get(this.fqn("/a/b")).containsKey("bb-key"));
        AssertJUnit.assertTrue((boolean)cl3.get(this.fqn("/a/b/c")).containsKey("c-key"));
        AssertJUnit.assertTrue((boolean)cl3.get(this.fqn("/a/b/d")).containsKey("d-key"));
        AssertJUnit.assertTrue((boolean)cl3.get(this.fqn("/e")).containsKey("e-key"));
        AssertJUnit.assertTrue((boolean)cl3.get(this.fqn("/e/f/g")).containsKey("g-key"));
        AssertJUnit.assertTrue((boolean)cl3.get(this.fqn("/e/f/h")).containsKey("h-key"));
        AssertJUnit.assertTrue((boolean)cl3.get(this.fqn("/i")).containsKey("i-key"));
        this.cache3.put(this.fqn("/a"), (Object)"aaa-key", (Object)"aaa-value");
        AssertJUnit.assertTrue((boolean)cl3.get(this.fqn("/a")).containsKey("aaa-key"));
        this.stopCache3();
    }

    public void testAvoidConcurrentStatePush() throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(2);
        CountDownLatch pushStateCanFinish = new CountDownLatch(1);
        CountDownLatch secondActiveStatusChangerCanStart = new CountDownLatch(1);
        MockSingletonStoreCacheLoader mscl = new MockSingletonStoreCacheLoader(pushStateCanFinish, secondActiveStatusChangerCanStart, new SingletonStoreDefaultConfig());
        Future<?> f1 = executor.submit(this.createActiveStatusChanger(mscl));
        secondActiveStatusChangerCanStart.await();
        Future<?> f2 = executor.submit(this.createActiveStatusChanger(mscl));
        f1.get();
        f2.get();
        AssertJUnit.assertEquals((int)1, (int)mscl.getNumberCreatedTasks());
    }

    public void testPushStateTimedOut() throws Exception {
        CountDownLatch pushStateCanFinish = new CountDownLatch(1);
        SingletonStoreDefaultConfig ssdc = new SingletonStoreDefaultConfig();
        ssdc.setPushStateWhenCoordinatorTimeout(1000);
        MockSingletonStoreCacheLoader mscl = new MockSingletonStoreCacheLoader(pushStateCanFinish, null, ssdc);
        Future<?> f = Executors.newSingleThreadExecutor().submit(this.createActiveStatusChanger(mscl));
        pushStateCanFinish.await(2000L, TimeUnit.MILLISECONDS);
        pushStateCanFinish.countDown();
        try {
            f.get();
            AssertJUnit.fail((String)"Should have timed out");
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause().getCause().getCause();
            AssertJUnit.assertTrue((String)(t + " should have been TimeoutException"), (boolean)(t instanceof TimeoutException));
        }
    }

    private void createCaches() {
        this.cache1.create();
        this.cache2.create();
        this.cache3.create();
    }

    private void statCaches() {
        this.cache1.start();
        this.cache2.start();
        this.cache3.start();
    }

    private void waitForPushStateCompletion(Future pushThreadFuture) throws Exception {
        if (pushThreadFuture != null) {
            pushThreadFuture.get();
        }
    }

    private Callable<?> createActiveStatusChanger(SingletonStoreCacheLoader mscl) {
        return new ActiveStatusModifier(mscl);
    }

    protected CacheLoaderConfig getSingletonStoreCacheLoaderConfig(String cacheloaderClass, boolean singletonEnabled, boolean pushStateWhenCoordinator, int pushStateWhenCoordinatorTimeout) throws Exception {
        String xml = "<config>\n<passivation>false</passivation>\n<preload></preload>\n<cacheloader>\n  <class>" + cacheloaderClass + "</class>\n" + "  <properties></properties>\n" + "  <singletonStore>" + "     <enabled>true</enabled>" + "     <properties>" + "        pushStateWhenCoordinator = true\n" + "        pushStateWhenCoordinatorTimeout = 5000\n" + "     </properties>" + "  </singletonStore>" + "</cacheloader>\n" + "</config>";
        Element element = XmlHelper.stringToElement((String)xml);
        return XmlConfigurationParser.parseCacheLoaderConfig((Element)element);
    }

    private void initSingletonNonPushCache(CacheSPI cache) throws Exception {
        cache.getConfiguration().setCacheLoaderConfig(this.getSingletonStoreCacheLoaderConfig(DummyInMemoryCacheLoader.class.getName(), true, false, 1000));
    }

    private void initSingletonWithPushCache(CacheSPI cache) throws Exception {
        cache.getConfiguration().setCacheLoaderConfig(this.getSingletonStoreCacheLoaderConfig(DummyInMemoryCacheLoader.class.getName(), true, true, 1000));
    }

    private CacheLoader getDelegatingCacheLoader(CacheSPI cache) {
        AbstractDelegatingCacheLoader acl = (AbstractDelegatingCacheLoader)cache.getCacheLoaderManager().getCacheLoader();
        return acl.getCacheLoader();
    }

    private Fqn fqn(String fqn) {
        return Fqn.fromString((String)fqn);
    }

    private void stopCache1() {
        if (this.cache1 != null) {
            this.cache1.stop();
        }
        this.cache1 = null;
    }

    private void stopCache2() {
        if (this.cache2 != null) {
            this.cache2.stop();
        }
        this.cache2 = null;
    }

    private void stopCache3() {
        if (this.cache3 != null) {
            this.cache3.stop();
        }
        this.cache3 = null;
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.stopCache1();
        this.stopCache2();
        this.stopCache3();
    }

    class ActiveStatusModifier
    implements Callable {
        private SingletonStoreCacheLoader scl;

        public ActiveStatusModifier(SingletonStoreCacheLoader singleton) {
            this.scl = singleton;
        }

        public Object call() throws Exception {
            log.debug((Object)"active status modifier started");
            this.scl.activeStatusChanged(true);
            this.scl.getPushStateFuture().get();
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MockSingletonStoreCacheLoader
    extends SingletonStoreCacheLoader {
        private int numberCreatedTasks;
        private CountDownLatch pushStateCanFinish;
        private CountDownLatch secondActiveStatusChangerCanStart;

        public MockSingletonStoreCacheLoader(CountDownLatch pushStateCanFinish, CountDownLatch secondActiveStatusChangerCanStart, SingletonStoreDefaultConfig config) {
            super(config);
            this.numberCreatedTasks = 0;
            this.pushStateCanFinish = pushStateCanFinish;
            this.secondActiveStatusChangerCanStart = secondActiveStatusChangerCanStart;
        }

        public int getNumberCreatedTasks() {
            return this.numberCreatedTasks;
        }

        public void setNumberCreatedTasks(int numberCreatedTasks) {
            this.numberCreatedTasks = numberCreatedTasks;
        }

        protected Callable<?> createPushStateTask() {
            return new Callable(){

                public Object call() throws Exception {
                    MockSingletonStoreCacheLoader.this.numberCreatedTasks++;
                    try {
                        if (MockSingletonStoreCacheLoader.this.secondActiveStatusChangerCanStart != null) {
                            MockSingletonStoreCacheLoader.this.secondActiveStatusChangerCanStart.countDown();
                        }
                        MockSingletonStoreCacheLoader.this.pushStateCanFinish.await();
                    }
                    catch (InterruptedException e) {
                        AssertJUnit.fail((String)"ActiveStatusModifier interrupted");
                    }
                    return null;
                }
            };
        }

        protected void awaitForPushToFinish(Future future, int timeout, TimeUnit unit) {
            this.pushStateCanFinish.countDown();
            super.awaitForPushToFinish(future, timeout, unit);
        }
    }
}

