/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.manager;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheManagerImpl;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.ConfigurationRegistry;
import org.jgroups.ChannelFactory;
import org.jgroups.JChannelFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class CacheManagerTest {
    public static final String DEFAULT_CONFIGURATION_FILE = "META-INF/jbc2-configs.xml";
    private Set<Cache<Object, Object>> caches = new HashSet<Cache<Object, Object>>();

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        for (Cache<Object, Object> cache : this.caches) {
            try {
                cache.stop();
                cache.destroy();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
    }

    public void testBasic() throws Exception {
        Cache cache;
        String configName2;
        JChannelFactory cf = new JChannelFactory();
        cf.setMultiplexerConfig("stacks.xml");
        CacheManagerImpl registry = new CacheManagerImpl(DEFAULT_CONFIGURATION_FILE, (ChannelFactory)cf);
        registry.start();
        ConfigurationRegistry configRegistry = registry.getConfigurationRegistry();
        Set configNames = registry.getConfigurationNames();
        AssertJUnit.assertEquals((int)7, (int)configNames.size());
        Set cacheNames = registry.getCacheNames();
        AssertJUnit.assertEquals((int)0, (int)cacheNames.size());
        for (String configName2 : configNames) {
            AssertJUnit.assertNull((String)(configName2 + " not created"), (Object)registry.getCache(configName2, false));
            cache = registry.getCache(configName2, true);
            this.caches.add((Cache<Object, Object>)cache);
            AssertJUnit.assertEquals((Object)CacheStatus.INSTANTIATED, (Object)cache.getCacheStatus());
            cache.create();
            cache.start();
            Configuration rawConfig = configRegistry.getConfiguration(configName2);
            Configuration realConfig = cache.getConfiguration();
            AssertJUnit.assertFalse((rawConfig == realConfig ? 1 : 0) != 0);
            AssertJUnit.assertEquals((String)rawConfig.getClusterName(), (String)realConfig.getClusterName());
        }
        cacheNames = registry.getCacheNames();
        AssertJUnit.assertEquals((Object)configNames, (Object)cacheNames);
        for (String configName2 : configNames) {
            registry.releaseCache(configName2);
        }
        cacheNames = registry.getCacheNames();
        AssertJUnit.assertEquals((int)0, (int)cacheNames.size());
        Set configNames2 = registry.getConfigurationNames();
        AssertJUnit.assertEquals((Object)configNames, (Object)configNames2);
        Iterator<Cache<Object, Object>> it = this.caches.iterator();
        while (it.hasNext()) {
            AssertJUnit.assertEquals((Object)CacheStatus.DESTROYED, (Object)it.next().getCacheStatus());
            it.remove();
        }
        configName2 = (String)configNames.iterator().next();
        AssertJUnit.assertNull((String)(configName2 + " not created"), (Object)registry.getCache(configName2, false));
        cache = registry.getCache(configName2, true);
        AssertJUnit.assertFalse((null == cache ? 1 : 0) != 0);
        this.caches.add((Cache<Object, Object>)cache);
        cache.create();
        cache.start();
        Cache cache2 = registry.getCache(configName2, true);
        AssertJUnit.assertTrue((cache == cache2 ? 1 : 0) != 0);
        registry.releaseCache(configName2);
        AssertJUnit.assertEquals((Object)CacheStatus.STARTED, (Object)cache.getCacheStatus());
        registry.stop();
        AssertJUnit.assertEquals((Object)CacheStatus.DESTROYED, (Object)cache.getCacheStatus());
        this.caches.remove(cache);
        cacheNames = registry.getCacheNames();
        AssertJUnit.assertEquals((int)0, (int)cacheNames.size());
        AssertJUnit.assertEquals((Object)cacheNames, (Object)registry.getConfigurationNames());
    }
}

