/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall.io;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Random;
import org.jboss.cache.marshall.io.ObjectStreamPool;
import org.jboss.cache.marshall.io.ReusableObjectOutputStream;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class ObjectStreamPoolTest
implements Serializable {
    transient ObjectStreamPool pool;
    transient ReusableObjectOutputStream oos;
    transient ObjectInputStream ois;

    @BeforeTest
    public void setUp() throws IOException, InterruptedException {
        this.pool = new ObjectStreamPool();
        this.pool.numInputStreams = 1;
        this.pool.numOutputStreams = 1;
        this.pool.start();
    }

    @AfterMethod
    public void afterMethod() throws IOException, InterruptedException {
        if (this.oos != null) {
            this.pool.returnStreamToPool(this.oos);
        }
        if (this.ois != null) {
            this.pool.returnStreamToPool(this.ois);
        }
    }

    public void testStreamReset() throws IOException, ClassNotFoundException, InterruptedException {
        this.oos = this.pool.getOutputStream();
        Object toWrite = "BlahBlah";
        this.oos.writeObject(toWrite);
        byte[] asBytes = this.oos.getBytes();
        this.ois = this.pool.getInputStream(asBytes);
        assert (this.ois.readObject().equals(toWrite));
        this.pool.returnStreamToPool(this.oos);
        this.pool.returnStreamToPool(this.ois);
        this.oos = this.pool.getOutputStream();
        toWrite = new Integer(9);
        this.oos.writeObject(toWrite);
        asBytes = this.oos.getBytes();
        this.ois = this.pool.getInputStream(asBytes);
        assert (this.ois.readObject().equals(toWrite));
        this.pool.returnStreamToPool(this.oos);
        this.pool.returnStreamToPool(this.ois);
        this.oos = this.pool.getOutputStream();
        toWrite = new Date();
        this.oos.writeObject(toWrite);
        asBytes = this.oos.getBytes();
        this.ois = this.pool.getInputStream(asBytes);
        assert (this.ois.readObject().equals(toWrite));
        this.pool.returnStreamToPool(this.oos);
        this.pool.returnStreamToPool(this.ois);
        this.oos = this.pool.getOutputStream();
        toWrite = new MyClass(876, "Hello");
        this.oos.writeObject(toWrite);
        asBytes = this.oos.getBytes();
        this.ois = this.pool.getInputStream(asBytes);
        assert (this.ois.readObject().equals(toWrite));
    }

    public void testLargeStreams() throws IOException, ClassNotFoundException, InterruptedException {
        int i;
        int i2;
        this.oos = this.pool.getOutputStream();
        StringBuilder sb = new StringBuilder();
        Random r = new Random();
        for (int i3 = 0; i3 < 65535; ++i3) {
            sb.append((char)(r.nextInt(26) + 65));
        }
        Object toWrite = sb.toString();
        System.out.println("Writing string (length = " + ((String)toWrite).length() + ") " + toWrite);
        this.oos.writeObject(toWrite);
        byte[] asBytes = this.oos.getBytes();
        this.ois = this.pool.getInputStream(asBytes);
        assert (this.ois.readObject().equals(toWrite));
        this.pool.returnStreamToPool(this.oos);
        this.pool.returnStreamToPool(this.ois);
        this.oos = this.pool.getOutputStream();
        toWrite = new Integer(9);
        for (i2 = 0; i2 < 65535; ++i2) {
            this.oos.writeObject(toWrite);
        }
        asBytes = this.oos.getBytes();
        this.ois = this.pool.getInputStream(asBytes);
        for (i2 = 0; i2 < 65535; ++i2) {
            assert (this.ois.readObject().equals(toWrite));
        }
        this.pool.returnStreamToPool(this.oos);
        this.pool.returnStreamToPool(this.ois);
        this.oos = this.pool.getOutputStream();
        toWrite = new MyClass(1, "x");
        for (i2 = 0; i2 < 65535; ++i2) {
            this.oos.writeObject(toWrite);
        }
        asBytes = this.oos.getBytes();
        this.ois = this.pool.getInputStream(asBytes);
        for (i2 = 0; i2 < 65535; ++i2) {
            assert (this.ois.readObject().equals(toWrite));
        }
        this.pool.returnStreamToPool(this.oos);
        this.pool.returnStreamToPool(this.ois);
        this.oos = this.pool.getOutputStream();
        int arraySize = 65535;
        Object[] toWriteArray = new Object[arraySize];
        for (i = 0; i < arraySize; ++i) {
            toWriteArray[i] = new MyClass(i, "x");
            this.oos.writeObject(toWriteArray[i]);
        }
        asBytes = this.oos.getBytes();
        this.ois = this.pool.getInputStream(asBytes);
        for (i = 0; i < arraySize; ++i) {
            Object read = this.ois.readObject();
            assert (read.equals(toWriteArray[i])) : "Loop " + i + ": Expected " + toWriteArray[i] + " but was " + read;
        }
    }

    public void testStreamResetWithFlush() throws Exception {
        this.oos = this.pool.getOutputStream();
        Object toWrite = "BlahBlah";
        Object toWrite2 = "Hello world";
        this.oos.writeObject(toWrite);
        this.oos.flush();
        this.oos.writeObject(toWrite2);
        byte[] asBytes = this.oos.getBytes();
        this.ois = this.pool.getInputStream(asBytes);
        assert (this.ois.readObject().equals(toWrite));
        assert (this.ois.readObject().equals(toWrite2));
        this.pool.returnStreamToPool(this.oos);
        this.pool.returnStreamToPool(this.ois);
        this.oos = this.pool.getOutputStream();
        toWrite = new Integer(9);
        toWrite2 = new Long(99L);
        this.oos.writeObject(toWrite);
        this.oos.flush();
        this.oos.writeObject(toWrite2);
        asBytes = this.oos.getBytes();
        this.ois = this.pool.getInputStream(asBytes);
        assert (this.ois.readObject().equals(toWrite));
        assert (this.ois.readObject().equals(toWrite2));
        this.pool.returnStreamToPool(this.oos);
        this.pool.returnStreamToPool(this.ois);
        this.oos = this.pool.getOutputStream();
        toWrite = new Date();
        toWrite2 = Boolean.FALSE;
        this.oos.writeObject(toWrite);
        this.oos.flush();
        this.oos.writeObject(toWrite2);
        asBytes = this.oos.getBytes();
        this.ois = this.pool.getInputStream(asBytes);
        assert (this.ois.readObject().equals(toWrite));
        assert (this.ois.readObject().equals(toWrite2));
    }

    public void testCustomTypes() throws Exception {
        this.oos = this.pool.getOutputStream();
        MyClass toWrite = new MyClass(123, "hello");
        MyClass toWrite2 = new MyClass(456, "world");
        this.oos.writeObject((Object)toWrite);
        this.oos.flush();
        this.oos.writeObject((Object)toWrite2);
        byte[] asBytes = this.oos.getBytes();
        this.ois = this.pool.getInputStream(asBytes);
        assert (this.ois.readObject().equals(toWrite));
        assert (this.ois.readObject().equals(toWrite2));
    }

    public void testMixedTypes() throws Exception {
        this.oos = this.pool.getOutputStream();
        MyClass toWrite = new MyClass(123, "hello");
        MyClass toWrite2 = new MyClass(456, "world");
        this.oos.writeObject((Object)toWrite);
        this.oos.flush();
        this.oos.writeBoolean(false);
        this.oos.flush();
        this.oos.writeObject((Object)toWrite2);
        this.oos.flush();
        this.oos.writeShort(6);
        byte[] asBytes = this.oos.getBytes();
        this.ois = this.pool.getInputStream(asBytes);
        assert (this.ois.readObject().equals(toWrite));
        assert (!this.ois.readBoolean());
        assert (this.ois.readObject().equals(toWrite2));
        assert (this.ois.readShort() == 6);
    }

    public void testLargeObject() throws Exception {
        this.oos = this.pool.getOutputStream();
        StringBuilder builder = new StringBuilder();
        int targetSize = 0x400000;
        System.out.println("target size: " + targetSize);
        for (int i = 0; i < targetSize; ++i) {
            builder.append("X");
        }
        String fourMegString = builder.toString();
        this.oos.writeObject((Object)fourMegString);
        byte[] asBytes = this.oos.getBytes();
        this.ois = this.pool.getInputStream(asBytes);
        assert (this.ois.readObject().equals(fourMegString));
    }

    public void testReusableOutputStreamArraySize() throws InterruptedException, IOException {
        this.oos = this.pool.getOutputStream();
        int originalLength = this.oos.baos.getBufSize();
        for (int i = 0; i < 255; ++i) {
            this.oos.write(7);
        }
        this.oos.flush();
        assert (this.oos.baos.getBufSize() > 255);
        this.oos.reset();
        this.oos.init();
        assert (this.oos.baos.getBufSize() == originalLength);
    }

    public static class MyClass
    implements Serializable {
        int number;
        String name;

        public MyClass(int number, String name) {
            this.number = number;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyClass myClass = (MyClass)o;
            if (this.number != myClass.number) {
                return false;
            }
            return !(this.name != null ? !this.name.equals(myClass.name) : myClass.name != null);
        }

        public int hashCode() {
            int result = this.number;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "MyClass{number=" + this.number + ", name='" + this.name + '\'' + '}';
        }
    }
}

