/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.DummySharedInMemoryCacheLoader;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class DataVersionPersistenceTest {
    private Cache cache;
    private CacheLoader loader;

    @BeforeMethod
    public void setUp() {
        this.cache = new DefaultCacheFactory().createCache(false);
        this.cache.getConfiguration().setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        this.cache.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        CacheLoaderConfig clc = new CacheLoaderConfig();
        CacheLoaderConfig.IndividualCacheLoaderConfig iclc = new CacheLoaderConfig.IndividualCacheLoaderConfig();
        iclc.setClassName(DummySharedInMemoryCacheLoader.class.getName());
        clc.addIndividualCacheLoaderConfig(iclc);
        this.cache.getConfiguration().setCacheLoaderConfig(clc);
        this.cache.start();
        this.loader = ((CacheSPI)this.cache).getCacheLoaderManager().getCacheLoader();
    }

    @AfterMethod
    public void tearDown() {
        try {
            this.cache.getConfiguration().getRuntimeConfig().getTransactionManager().rollback();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((DummySharedInMemoryCacheLoader)this.loader).wipe();
        this.cache.stop();
    }

    public void testStateTransferDefaultVersions() throws Exception {
        Fqn f = Fqn.fromString((String)"/one/two/three");
        this.cache.put(f, (Object)"k", (Object)"v");
        this.cache.put(f, (Object)"k1", (Object)"v1");
        this.cache.remove(f, (Object)"k1");
        assert (this.loader.get(f).containsKey("_JBOSS_INTERNAL_OPTIMISTIC_DATA_VERSION"));
        assert (((DefaultDataVersion)this.loader.get(f).get("_JBOSS_INTERNAL_OPTIMISTIC_DATA_VERSION")).getRawVersion() == 3L);
        NodeSPI n = (NodeSPI)this.cache.getRoot().getChild(f);
        DataVersion dv = n.getVersion();
        assert (dv instanceof DefaultDataVersion) : "Should be an instance of DefaultDataVersion";
        assert (((DefaultDataVersion)dv).getRawVersion() == 3L) : "Should have accurate data version";
        this.cache.stop();
        this.cache.start();
        assert (this.cache.get(f, (Object)"k").equals("v")) : "Value should have peristed";
        n = (NodeSPI)this.cache.getRoot().getChild(f);
        dv = n.getVersion();
        assert (dv instanceof DefaultDataVersion) : "Should be an instance of DefaultDataVersion";
        assert (((DefaultDataVersion)dv).getRawVersion() == 3L) : "Version should have peristed";
        assert (n.getData().size() == 1);
    }

    public void testStateTransferCustomVersion() throws Exception {
        Fqn f = Fqn.fromString((String)"/one/two/three");
        this.cache.getInvocationContext().getOptionOverrides().setDataVersion((DataVersion)new CharVersion('A'));
        this.cache.put(f, (Object)"k", (Object)"v");
        this.cache.getInvocationContext().getOptionOverrides().setDataVersion((DataVersion)new CharVersion('B'));
        this.cache.put(f, (Object)"k1", (Object)"v1");
        this.cache.getInvocationContext().getOptionOverrides().setDataVersion((DataVersion)new CharVersion('C'));
        this.cache.remove(f, (Object)"k1");
        NodeSPI n = (NodeSPI)this.cache.getRoot().getChild(f);
        DataVersion dv = n.getVersion();
        assert (dv instanceof CharVersion) : "Should be an instance of CharVersion";
        assert (((CharVersion)dv).version == 'C') : "Should have accurate data version";
        this.cache.stop();
        this.cache.start();
        assert (this.cache.get(f, (Object)"k").equals("v")) : "Value should have peristed";
        n = (NodeSPI)this.cache.getRoot().getChild(f);
        dv = n.getVersion();
        assert (dv instanceof CharVersion) : "Should be an instance of CharVersion";
        assert (((CharVersion)dv).version == 'C') : "Version should have peristed";
        assert (n.getData().size() == 1);
    }

    public static class CharVersion
    implements DataVersion {
        private char version = (char)65;

        public CharVersion(char version) {
            this.version = version;
        }

        public boolean newerThan(DataVersion other) {
            if (other instanceof CharVersion) {
                CharVersion otherVersion = (CharVersion)other;
                return this.version > otherVersion.version;
            }
            return true;
        }
    }
}

