/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.passivation;

import java.util.Properties;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.passivation.PassivationTestsBase;
import org.jboss.cache.xml.XmlHelper;
import org.w3c.dom.Element;

public class PassivationToJDBCCacheLoaderTest
extends PassivationTestsBase {
    protected CacheLoaderConfig getCacheLoaderConfig() throws Exception {
        String xml = "            <config>\n                \n                <passivation>true</passivation>\n                <preload></preload>\n\n                <cacheloader>\n                    <class>org.jboss.cache.loader.JDBCCacheLoader</class>\n                    <properties>\n" + this.getJDBCProps() + "                    </properties>\n" + "                    <async>false</async>\n" + "                    <fetchPersistentState>false</fetchPersistentState>\n" + "                    <ignoreModifications>false</ignoreModifications>\n" + "                </cacheloader>\n" + "                \n" + "            </config>";
        Element element = XmlHelper.stringToElement((String)xml);
        return XmlConfigurationParser.parseCacheLoaderConfig((Element)element);
    }

    protected String getJDBCProps() {
        Properties prop = new Properties();
        try {
            prop.load(this.getClass().getClassLoader().getResourceAsStream("cache-jdbc.properties"));
        }
        catch (Exception e) {
            System.out.println("Error loading jdbc properties ");
        }
        return "cache.jdbc.driver =" + prop.getProperty("cache.jdbc.driver") + "\n" + "cache.jdbc.url=" + prop.getProperty("cache.jdbc.url") + "\n" + "cache.jdbc.user=" + prop.getProperty("cache.jdbc.user") + "\n" + "cache.jdbc.password=" + prop.getProperty("cache.jdbc.password") + "\n" + "cache.jdbc.node.type=" + prop.getProperty("cache.jdbc.node.type") + "\n" + "cache.jdbc.sql-concat=" + prop.getProperty("cache.jdbc.sql-concat");
    }

    protected void configureCache() throws Exception {
        this.cache.getConfiguration().setCacheLoaderConfig(this.getCacheLoaderConfig());
    }
}

