/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Membership;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.TimeoutException;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.protocols.pbcast.ClientGmsImpl;
import org.jgroups.protocols.pbcast.CoordGmsImpl;
import org.jgroups.protocols.pbcast.GmsImpl;
import org.jgroups.protocols.pbcast.JoinRsp;
import org.jgroups.protocols.pbcast.MergeData;
import org.jgroups.protocols.pbcast.ParticipantGmsImpl;
import org.jgroups.stack.Protocol;
import org.jgroups.util.AckCollector;
import org.jgroups.util.BoundedList;
import org.jgroups.util.Digest;
import org.jgroups.util.Queue;
import org.jgroups.util.QueueClosedException;
import org.jgroups.util.Streamable;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GMS
extends Protocol {
    private GmsImpl impl = null;
    Address local_addr = null;
    final Membership members = new Membership();
    private final Membership tmp_members = new Membership();
    private final Vector<Address> joining = new Vector(7);
    private final Vector<Address> leaving = new Vector(7);
    View view = null;
    ViewId view_id = null;
    private long ltime = 0L;
    long join_timeout = 5000L;
    long leave_timeout = 5000L;
    long merge_timeout = 10000L;
    private final Object impl_mutex = new Object();
    private final Hashtable<String, GmsImpl> impls = new Hashtable(3);
    private boolean shun = false;
    boolean merge_leader = false;
    private boolean print_local_addr = true;
    boolean disable_initial_coord = false;
    boolean handle_concurrent_startup = true;
    private boolean view_bundling = true;
    private long max_bundling_time = 50L;
    static final String CLIENT = "Client";
    static final String COORD = "Coordinator";
    static final String PART = "Participant";
    TimeScheduler timer = null;
    protected int num_prev_mbrs = 50;
    BoundedList<Address> prev_members = null;
    boolean reject_join_from_existing_member = true;
    int num_views = 0;
    BoundedList<View> prev_views = new BoundedList(20);
    private final ViewHandler view_handler = new ViewHandler();
    final AckCollector ack_collector = new AckCollector();
    long view_ack_collection_timeout = 2000L;
    long resume_task_timeout = 20000L;
    boolean flushProtocolInStack = false;
    public static final String name = "GMS";

    public GMS() {
        this.initState();
    }

    @Override
    public String getName() {
        return name;
    }

    public String getView() {
        return this.view_id != null ? this.view_id.toString() : "null";
    }

    public int getNumberOfViews() {
        return this.num_views;
    }

    public String getLocalAddress() {
        return this.local_addr != null ? this.local_addr.toString() : "null";
    }

    public String getMembers() {
        return this.members != null ? this.members.toString() : "[]";
    }

    public int getNumMembers() {
        return this.members != null ? this.members.size() : 0;
    }

    public long getJoinTimeout() {
        return this.join_timeout;
    }

    public void setJoinTimeout(long t) {
        this.join_timeout = t;
    }

    public long getJoinRetryTimeout() {
        return -1L;
    }

    public void setJoinRetryTimeout(long t) {
    }

    public boolean isShun() {
        return this.shun;
    }

    public void setShun(boolean s) {
        this.shun = s;
    }

    public String printPreviousMembers() {
        StringBuilder sb = new StringBuilder();
        if (this.prev_members != null) {
            for (Address addr : this.prev_members) {
                sb.append(addr).append("\n");
            }
        }
        return sb.toString();
    }

    public long getViewAckCollectionTimeout() {
        return this.view_ack_collection_timeout;
    }

    public void setViewAckCollectionTimeout(long view_ack_collection_timeout) {
        this.view_ack_collection_timeout = view_ack_collection_timeout;
    }

    public boolean isViewBundling() {
        return this.view_bundling;
    }

    public void setViewBundling(boolean view_bundling) {
        this.view_bundling = view_bundling;
    }

    public long getMaxBundlingTime() {
        return this.max_bundling_time;
    }

    public void setMaxBundlingTime(long max_bundling_time) {
        this.max_bundling_time = max_bundling_time;
    }

    public int viewHandlerSize() {
        return this.view_handler.size();
    }

    public boolean isViewHandlerSuspended() {
        return this.view_handler.suspended();
    }

    public String dumpViewHandlerQueue() {
        return this.view_handler.dumpQueue();
    }

    public String dumpViewHandlerHistory() {
        return this.view_handler.dumpHistory();
    }

    public void suspendViewHandler() {
        this.view_handler.suspend(null);
    }

    public void resumeViewHandler() {
        this.view_handler.resumeForce();
    }

    Log getLog() {
        return this.log;
    }

    ViewHandler getViewHandler() {
        return this.view_handler;
    }

    public String printPreviousViews() {
        StringBuilder sb = new StringBuilder();
        for (View view : this.prev_views) {
            sb.append(view).append("\n");
        }
        return sb.toString();
    }

    public boolean isCoordinator() {
        Address coord = this.determineCoordinator();
        return coord != null && this.local_addr != null && this.local_addr.equals(coord);
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_views = 0;
        this.prev_views.clear();
    }

    @Override
    public Vector<Integer> requiredDownServices() {
        Vector<Integer> retval = new Vector<Integer>(3);
        retval.addElement(new Integer(39));
        retval.addElement(new Integer(41));
        retval.addElement(new Integer(12));
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImpl(GmsImpl new_impl) {
        Object object = this.impl_mutex;
        synchronized (object) {
            if (this.impl == new_impl) {
                return;
            }
            this.impl = new_impl;
            if (this.log.isDebugEnabled()) {
                String msg = (this.local_addr != null ? this.local_addr.toString() + " " : "") + "changed role to " + new_impl.getClass().getName();
                this.log.debug((Object)msg);
            }
        }
    }

    public GmsImpl getImpl() {
        return this.impl;
    }

    @Override
    public void init() throws Exception {
        this.prev_members = new BoundedList(this.num_prev_mbrs);
        TimeScheduler timeScheduler = this.timer = this.stack != null ? this.stack.timer : null;
        if (this.timer == null) {
            throw new Exception("GMS.init(): timer is null");
        }
        if (this.impl != null) {
            this.impl.init();
        }
    }

    @Override
    public void start() throws Exception {
        if (this.impl != null) {
            this.impl.start();
        }
    }

    @Override
    public void stop() {
        this.view_handler.stop(true);
        if (this.impl != null) {
            this.impl.stop();
        }
        if (this.prev_members != null) {
            this.prev_members.clear();
        }
    }

    public void becomeCoordinator() {
        CoordGmsImpl tmp = (CoordGmsImpl)this.impls.get(COORD);
        if (tmp == null) {
            tmp = new CoordGmsImpl(this);
            this.impls.put(COORD, tmp);
        }
        try {
            tmp.init();
        }
        catch (Exception e) {
            this.log.error((Object)"exception switching to coordinator role", (Throwable)e);
        }
        this.setImpl(tmp);
    }

    public void becomeParticipant() {
        ParticipantGmsImpl tmp = (ParticipantGmsImpl)this.impls.get(PART);
        if (tmp == null) {
            tmp = new ParticipantGmsImpl(this);
            this.impls.put(PART, tmp);
        }
        try {
            tmp.init();
        }
        catch (Exception e) {
            this.log.error((Object)"exception switching to participant", (Throwable)e);
        }
        this.setImpl(tmp);
    }

    public void becomeClient() {
        ClientGmsImpl tmp = (ClientGmsImpl)this.impls.get(CLIENT);
        if (tmp == null) {
            tmp = new ClientGmsImpl(this);
            this.impls.put(CLIENT, tmp);
        }
        try {
            tmp.init();
        }
        catch (Exception e) {
            this.log.error((Object)"exception switching to client role", (Throwable)e);
        }
        this.setImpl(tmp);
    }

    boolean haveCoordinatorRole() {
        return this.impl != null && this.impl instanceof CoordGmsImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View getNextView(Collection new_mbrs, Collection old_mbrs, Collection suspected_mbrs) {
        Membership membership = this.members;
        synchronized (membership) {
            long vid;
            if (this.view_id == null) {
                this.log.error((Object)"view_id is null");
                return null;
            }
            this.ltime = vid = Math.max(this.view_id.getId(), this.ltime) + 1L;
            Membership tmp_mbrs = this.tmp_members.copy();
            tmp_mbrs.remove(suspected_mbrs);
            tmp_mbrs.remove(old_mbrs);
            tmp_mbrs.add(new_mbrs);
            Vector<Address> mbrs = tmp_mbrs.getMembers();
            View v = new View(this.local_addr, vid, mbrs);
            this.tmp_members.set(mbrs);
            if (new_mbrs != null) {
                for (Address tmp_mbr : new_mbrs) {
                    if (this.joining.contains(tmp_mbr)) continue;
                    this.joining.addElement(tmp_mbr);
                }
            }
            if (old_mbrs != null) {
                for (Address addr : old_mbrs) {
                    if (this.leaving.contains(addr)) continue;
                    this.leaving.add(addr);
                }
            }
            if (suspected_mbrs != null) {
                for (Address addr : suspected_mbrs) {
                    if (this.leaving.contains(addr)) continue;
                    this.leaving.add(addr);
                }
            }
            return v;
        }
    }

    public void castViewChange(Vector new_mbrs, Vector old_mbrs, Vector suspected_mbrs) {
        View new_view = this.getNextView(new_mbrs, old_mbrs, suspected_mbrs);
        this.castViewChange(new_view, null);
    }

    public void castViewChange(View new_view, Digest digest) {
        this.castViewChangeWithDest(new_view, digest, null);
    }

    public void castViewChangeWithDest(View new_view, Digest digest, List<Address> members) {
        ViewId vid = new_view.getVid();
        int size = -1;
        if (members == null || members.isEmpty()) {
            members = new_view.getMembers();
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("mcasting view {" + new_view + "} (" + new_view.size() + " mbrs)\n"));
        }
        long start = System.currentTimeMillis();
        Message view_change_msg = new Message();
        GmsHeader hdr = new GmsHeader(5, new_view);
        hdr.my_digest = digest;
        view_change_msg.putHeader(name, hdr);
        this.ack_collector.reset(vid, members);
        size = this.ack_collector.size();
        this.down_prot.up(new Event(15, new_view));
        this.down_prot.down(new Event(15, new_view));
        this.down_prot.down(new Event(1, view_change_msg));
        try {
            this.ack_collector.waitForAllAcks(this.view_ack_collection_timeout);
            long stop = System.currentTimeMillis();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("received all ACKs (" + size + ") for " + vid + " in " + (stop - start) + "ms"));
            }
        }
        catch (TimeoutException e) {
            this.log.warn((Object)("failed to collect all ACKs (" + size + ") for view " + new_view + " after " + this.view_ack_collection_timeout + "ms, missing ACKs from " + this.ack_collector.printMissing() + " (received=" + this.ack_collector.printReceived() + "), local_addr=" + this.local_addr));
        }
    }

    public void installView(View new_view) {
        this.installView(new_view, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installView(View new_view, Digest digest) {
        int rc;
        ViewId vid = new_view.getVid();
        Vector<Address> mbrs = new_view.getMembers();
        if (this.view_id != null && (rc = vid.compareTo(this.view_id)) <= 0) {
            if (this.log.isWarnEnabled() && rc < 0) {
                this.log.warn((Object)("[" + this.local_addr + "] received view < current view;" + " discarding it (current vid: " + this.view_id + ", new vid: " + vid + ')'));
            }
            return;
        }
        if (digest != null) {
            this.mergeDigest(digest);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[local_addr=" + this.local_addr + "] view is " + new_view));
        }
        if (this.stats) {
            ++this.num_views;
            this.prev_views.add(new_view);
        }
        this.ack_collector.handleView(new_view);
        this.ltime = Math.max(vid.getId(), this.ltime);
        if (!this.checkSelfInclusion(mbrs)) {
            if (this.shun && this.local_addr != null && this.prev_members.contains(this.local_addr)) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)("I (" + this.local_addr + ") am not a member of view " + new_view + ", shunning myself and leaving the group (prev_members are " + this.prev_members + ", current view is " + this.view + ")"));
                }
                if (this.impl != null) {
                    this.impl.handleExit();
                }
                this.up_prot.up(new Event(46));
            } else if (this.log.isWarnEnabled()) {
                this.log.warn((Object)("I (" + this.local_addr + ") am not a member of view " + new_view + "; discarding view"));
            }
            return;
        }
        Membership membership = this.members;
        synchronized (membership) {
            this.view = new_view instanceof MergeView ? new View(new_view.getVid(), new_view.getMembers()) : new_view;
            this.view_id = vid.copy();
            if (mbrs != null && !mbrs.isEmpty()) {
                this.members.set(mbrs);
                this.tmp_members.set(this.members);
                this.joining.removeAll(mbrs);
                this.leaving.retainAll(mbrs);
                this.tmp_members.add(this.joining);
                this.tmp_members.remove(this.leaving);
                for (Address addr : mbrs) {
                    if (this.prev_members.contains(addr)) continue;
                    this.prev_members.add(addr);
                }
            }
            Event view_event = new Event(6, new_view);
            this.down_prot.down(view_event);
            this.up_prot.up(view_event);
            Address coord = this.determineCoordinator();
            if (coord != null && coord.equals(this.local_addr) && !this.haveCoordinatorRole()) {
                this.becomeCoordinator();
            } else if (this.haveCoordinatorRole() && !this.local_addr.equals(coord)) {
                this.becomeParticipant();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Address determineCoordinator() {
        Membership membership = this.members;
        synchronized (membership) {
            return this.members != null && this.members.size() > 0 ? (Address)this.members.elementAt(0) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean wouldBeNewCoordinator(Address potential_new_coord) {
        if (potential_new_coord == null) {
            return false;
        }
        Membership membership = this.members;
        synchronized (membership) {
            if (this.members.size() < 2) {
                return false;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl9 : MonitorExitStatement: MONITOREXIT : var3_2
            Address new_coord = (Address)this.members.elementAt(1);
            return new_coord != null && new_coord.equals(potential_new_coord);
        }
    }

    protected boolean checkSelfInclusion(Vector mbrs) {
        if (mbrs == null) {
            return false;
        }
        for (int i = 0; i < mbrs.size(); ++i) {
            Object mbr = mbrs.elementAt(i);
            if (mbr == null || !this.local_addr.equals(mbr)) continue;
            return true;
        }
        return false;
    }

    public View makeView(Vector<Address> mbrs) {
        Address coord = null;
        long id = 0L;
        if (this.view_id != null) {
            coord = this.view_id.getCoordAddress();
            id = this.view_id.getId();
        }
        return new View(coord, id, mbrs);
    }

    public static View makeView(Vector<Address> mbrs, ViewId vid) {
        Address coord = null;
        long id = 0L;
        if (vid != null) {
            coord = vid.getCoordAddress();
            id = vid.getId();
        }
        return new View(coord, id, mbrs);
    }

    public void setDigest(Digest d) {
        this.down_prot.down(new Event(41, d));
    }

    public void mergeDigest(Digest d) {
        this.down_prot.down(new Event(53, d));
    }

    public Digest getDigest() {
        return (Digest)this.down_prot.down(Event.GET_DIGEST_EVT);
    }

    boolean startFlush(View new_view) {
        return (Boolean)this.up_prot.up(new Event(68, new_view));
    }

    void stopFlush() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"sending RESUME event");
        }
        this.up_prot.up(new Event(70));
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                GmsHeader hdr = (GmsHeader)msg.getHeader(name);
                if (hdr == null) break;
                switch (hdr.type) {
                    case 1: {
                        this.view_handler.add(new GmsImpl.Request(1, hdr.mbr, false, null));
                        break;
                    }
                    case 11: {
                        this.view_handler.add(new GmsImpl.Request(6, hdr.mbr, false, null));
                        break;
                    }
                    case 2: {
                        this.impl.handleJoinResponse(hdr.join_rsp);
                        break;
                    }
                    case 3: {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("received LEAVE_REQ for " + hdr.mbr + " from " + msg.getSrc()));
                        }
                        if (hdr.mbr == null) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error((Object)"LEAVE_REQ's mbr field is null");
                            }
                            return null;
                        }
                        this.view_handler.add(new GmsImpl.Request(2, hdr.mbr, false, null));
                        break;
                    }
                    case 4: {
                        this.impl.handleLeaveResponse();
                        break;
                    }
                    case 5: {
                        View new_view = hdr.view;
                        if (new_view == null) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error((Object)"[VIEW]: view == null");
                            }
                            return null;
                        }
                        Address coord = msg.getSrc();
                        if (!new_view.containsMember(coord)) {
                            this.sendViewAck(coord);
                            this.impl.handleViewChange(new_view, hdr.my_digest);
                            break;
                        }
                        this.impl.handleViewChange(new_view, hdr.my_digest);
                        this.sendViewAck(coord);
                        break;
                    }
                    case 10: {
                        Address sender = msg.getSrc();
                        this.ack_collector.ack(sender);
                        return null;
                    }
                    case 6: {
                        this.down_prot.down(new Event(65, 20000));
                        if (this.flushProtocolInStack) {
                            View v = new View(this.view_id.copy(), this.members.getMembers());
                            boolean successfulFlush = this.startFlush(v);
                            if (successfulFlush) {
                                if (this.log.isTraceEnabled()) {
                                    this.log.trace((Object)("Successful flush for merge from" + this.getLocalAddress()));
                                }
                            } else if (this.log.isWarnEnabled()) {
                                this.log.warn((Object)("Flush for merge from " + this.getLocalAddress() + " failed"));
                            }
                        }
                        this.impl.handleMergeRequest(msg.getSrc(), hdr.merge_id);
                        break;
                    }
                    case 7: {
                        MergeData merge_data = new MergeData(msg.getSrc(), hdr.view, hdr.my_digest);
                        merge_data.merge_rejected = hdr.merge_rejected;
                        this.impl.handleMergeResponse(merge_data, hdr.merge_id);
                        break;
                    }
                    case 8: {
                        this.impl.handleMergeView(new MergeData(msg.getSrc(), hdr.view, hdr.my_digest), hdr.merge_id);
                        this.down_prot.down(new Event(66));
                        break;
                    }
                    case 9: {
                        if (this.flushProtocolInStack) {
                            this.stopFlush();
                        }
                        this.impl.handleMergeCancelled(hdr.merge_id);
                        this.down_prot.down(new Event(66));
                        break;
                    }
                    default: {
                        if (!this.log.isErrorEnabled()) break;
                        this.log.error((Object)("GmsHeader with type=" + hdr.type + " not known"));
                    }
                }
                return null;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                if (!this.print_local_addr) break;
                System.out.println("\n-------------------------------------------------------\nGMS: address is " + this.local_addr + "\n-------------------------------------------------------");
                break;
            }
            case 9: {
                Address suspected = (Address)evt.getArg();
                this.view_handler.add(new GmsImpl.Request(3, suspected, true, null));
                this.ack_collector.suspect(suspected);
                break;
            }
            case 51: {
                this.impl.unsuspect((Address)evt.getArg());
                return null;
            }
            case 14: {
                this.view_handler.add(new GmsImpl.Request(4, null, false, (Vector)evt.getArg()));
                return null;
            }
        }
        if (this.impl.handleUpEvent(evt)) {
            return this.up_prot.up(evt);
        }
        return null;
    }

    @Override
    public Object down(Event evt) {
        Throwable arg = null;
        switch (evt.getType()) {
            case 2: {
                this.down_prot.down(evt);
                if (this.local_addr == null && this.log.isFatalEnabled()) {
                    this.log.fatal((Object)"[CONNECT] local_addr is null");
                }
                try {
                    this.impl.join(this.local_addr);
                }
                catch (Throwable e) {
                    arg = e;
                }
                return arg;
            }
            case 80: {
                this.down_prot.down(evt);
                if (this.local_addr == null && this.log.isFatalEnabled()) {
                    this.log.fatal((Object)"[CONNECT] local_addr is null");
                }
                try {
                    this.impl.joinWithStateTransfer(this.local_addr);
                }
                catch (Throwable e) {
                    arg = e;
                }
                return arg;
            }
            case 4: {
                this.impl.leave((Address)evt.getArg());
                if (!(this.impl instanceof CoordGmsImpl)) {
                    this.initState();
                }
                this.down_prot.down(evt);
                return null;
            }
            case 56: {
                Map config = (Map)evt.getArg();
                if (config == null || !config.containsKey("flush_supported")) break;
                this.flushProtocolInStack = true;
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("shun");
        if (str != null) {
            this.shun = Boolean.valueOf(str);
            props.remove("shun");
        }
        if ((str = props.getProperty("merge_leader")) != null) {
            this.merge_leader = Boolean.valueOf(str);
            props.remove("merge_leader");
        }
        if ((str = props.getProperty("print_local_addr")) != null) {
            this.print_local_addr = Boolean.valueOf(str);
            props.remove("print_local_addr");
        }
        if ((str = props.getProperty("join_timeout")) != null) {
            this.join_timeout = Long.parseLong(str);
            props.remove("join_timeout");
        }
        if ((str = props.getProperty("join_retry_timeout")) != null) {
            props.remove("join_retry_timeout");
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)"join_retry_timeout has been deprecated and its value will be ignored");
            }
        }
        if ((str = props.getProperty("leave_timeout")) != null) {
            this.leave_timeout = Long.parseLong(str);
            props.remove("leave_timeout");
        }
        if ((str = props.getProperty("merge_timeout")) != null) {
            this.merge_timeout = Long.parseLong(str);
            props.remove("merge_timeout");
        }
        if ((str = props.getProperty("digest_timeout")) != null) {
            this.log.warn((Object)"digest_timeout has been deprecated and its value will be ignored");
            props.remove("digest_timeout");
        }
        if ((str = props.getProperty("view_ack_collection_timeout")) != null) {
            this.view_ack_collection_timeout = Long.parseLong(str);
            props.remove("view_ack_collection_timeout");
        }
        if ((str = props.getProperty("resume_task_timeout")) != null) {
            this.resume_task_timeout = Long.parseLong(str);
            props.remove("resume_task_timeout");
        }
        if ((str = props.getProperty("disable_initial_coord")) != null) {
            this.disable_initial_coord = Boolean.valueOf(str);
            props.remove("disable_initial_coord");
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)"disable_initial_coord has been deprecated and will be phased out by 3.0, please don't use it anymore");
            }
        }
        if ((str = props.getProperty("handle_concurrent_startup")) != null) {
            this.handle_concurrent_startup = Boolean.valueOf(str);
            props.remove("handle_concurrent_startup");
        }
        if ((str = props.getProperty("num_prev_mbrs")) != null) {
            this.num_prev_mbrs = Integer.parseInt(str);
            props.remove("num_prev_mbrs");
        }
        if ((str = props.getProperty("reject_join_from_existing_member")) != null) {
            this.reject_join_from_existing_member = Boolean.parseBoolean(str);
            props.remove("reject_join_from_existing_member");
        }
        if ((str = props.getProperty("use_flush")) != null) {
            this.log.warn((Object)"use_flush has been deprecated and its value will be ignored");
            props.remove("use_flush");
        }
        if ((str = props.getProperty("flush_timeout")) != null) {
            this.log.warn((Object)"flush_timeout has been deprecated and its value will be ignored");
            props.remove("flush_timeout");
        }
        if ((str = props.getProperty("view_bundling")) != null) {
            this.view_bundling = Boolean.valueOf(str);
            props.remove("view_bundling");
        }
        if ((str = props.getProperty("max_bundling_time")) != null) {
            this.max_bundling_time = Long.parseLong(str);
            props.remove("max_bundling_time");
        }
        if (!props.isEmpty()) {
            this.log.error((Object)("the following properties are not recognized: " + props));
            return false;
        }
        return true;
    }

    final void initState() {
        this.becomeClient();
        this.view_id = null;
        this.view = null;
    }

    private void sendViewAck(Address dest) {
        Message view_ack = new Message(dest, null, null);
        view_ack.setFlag((byte)1);
        GmsHeader tmphdr = new GmsHeader(10);
        view_ack.putHeader(name, tmphdr);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("sending VIEW_ACK to " + dest));
        }
        this.down_prot.down(new Event(1, view_ack));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Resumer
    implements Runnable {
        final Object token;
        final Map<Object, Future> tasks;
        final ViewHandler handler;

        public Resumer(Object token, Map<Object, Future> t, ViewHandler handler) {
            this.token = token;
            this.tasks = t;
            this.handler = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean execute = true;
            Map<Object, Future> map = this.tasks;
            synchronized (map) {
                Future future = this.tasks.get(this.token);
                if (future != null) {
                    future.cancel(false);
                    execute = true;
                } else {
                    execute = false;
                }
                this.tasks.remove(this.token);
            }
            if (execute) {
                this.handler.resume(this.token);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ViewHandler
    implements Runnable {
        volatile Thread thread;
        Queue q = new Queue();
        boolean suspended = false;
        static final long INTERVAL = 5000L;
        private static final long MAX_COMPLETION_TIME = 10000L;
        private final BoundedList<String> history = new BoundedList(20);
        private final Map<Object, Future> resume_tasks = new HashMap<Object, Future>();
        private Object merge_id = null;

        ViewHandler() {
        }

        void add(GmsImpl.Request req) {
            this.add(req, false, false);
        }

        synchronized void add(GmsImpl.Request req, boolean at_head, boolean unsuspend) {
            block5: {
                if (this.suspended && !unsuspend) {
                    GMS.this.log.warn((Object)("queue is suspended; request " + req + " is discarded"));
                    return;
                }
                this.start(unsuspend);
                try {
                    if (at_head) {
                        this.q.addAtHead(req);
                    } else {
                        this.q.add(req);
                    }
                    this.history.add(new Date() + ": " + req.toString());
                }
                catch (QueueClosedException e) {
                    if (!GMS.this.log.isTraceEnabled()) break block5;
                    GMS.this.log.trace((Object)("queue is closed; request " + req + " is discarded"));
                }
            }
        }

        void waitUntilCompleted(long timeout) {
            this.waitUntilCompleted(timeout, false);
        }

        synchronized void waitUntilCompleted(long timeout, boolean resume) {
            if (this.thread != null) {
                try {
                    this.thread.join(timeout);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            if (resume) {
                this.resumeForce();
            }
        }

        public synchronized void suspend(Object merge_id) {
            Resumer resumer;
            ScheduledFuture<?> future;
            Future old_future;
            if (this.suspended) {
                return;
            }
            this.suspended = true;
            this.merge_id = merge_id;
            this.q.clear();
            this.waitUntilCompleted(10000L);
            this.q.close(true);
            if (GMS.this.log.isTraceEnabled()) {
                GMS.this.log.trace((Object)"suspended ViewHandler");
            }
            if ((old_future = (Future)this.resume_tasks.put(merge_id, future = GMS.this.timer.schedule(resumer = new Resumer(merge_id, this.resume_tasks, this), GMS.this.resume_task_timeout, TimeUnit.MILLISECONDS))) != null) {
                old_future.cancel(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void resume(Object merge_id) {
            if (!this.suspended) {
                return;
            }
            boolean same_merge_id = this.merge_id != null && merge_id != null && this.merge_id.equals(merge_id);
            boolean bl = same_merge_id = same_merge_id || this.merge_id == null && merge_id == null;
            if (!same_merge_id) {
                if (GMS.this.log.isWarnEnabled()) {
                    GMS.this.log.warn((Object)("resume(" + merge_id + ") does not match " + this.merge_id + ", ignoring resume()"));
                }
                return;
            }
            Map<Object, Future> map = this.resume_tasks;
            synchronized (map) {
                Future future = this.resume_tasks.get(merge_id);
                if (future != null) {
                    future.cancel(false);
                    this.resume_tasks.remove(merge_id);
                }
            }
            this.resumeForce();
        }

        public synchronized void resumeForce() {
            if (this.q.closed()) {
                this.q.reset();
            }
            this.suspended = false;
            if (GMS.this.log.isTraceEnabled()) {
                GMS.this.log.trace((Object)"resumed ViewHandler");
            }
        }

        @Override
        public void run() {
            LinkedList<GmsImpl.Request> requests = new LinkedList<GmsImpl.Request>();
            while (Thread.currentThread().equals(this.thread)) {
                requests.clear();
                try {
                    boolean keepGoing = false;
                    long start = System.currentTimeMillis();
                    do {
                        GmsImpl.Request firstRequest = (GmsImpl.Request)this.q.remove(5000L);
                        requests.add(firstRequest);
                        if (this.q.size() > 0) {
                            GmsImpl.Request nextReq = (GmsImpl.Request)this.q.peek();
                            keepGoing = GMS.this.view_bundling && firstRequest.canBeProcessedTogether(nextReq);
                            continue;
                        }
                        long stop = System.currentTimeMillis();
                        long wait_time = GMS.this.max_bundling_time - (stop - start);
                        if (wait_time > 0L) {
                            Util.sleep(wait_time);
                        }
                        boolean bl = keepGoing = this.q.size() > 0;
                    } while (keepGoing);
                    this.process(requests);
                }
                catch (QueueClosedException e) {
                    break;
                }
                catch (TimeoutException e) {
                    break;
                }
                catch (Throwable catchall) {
                    Util.sleep(50L);
                }
            }
        }

        public int size() {
            return this.q.size();
        }

        public boolean suspended() {
            return this.suspended;
        }

        public String dumpQueue() {
            StringBuilder sb = new StringBuilder();
            LinkedList v = this.q.values();
            Iterator it = v.iterator();
            while (it.hasNext()) {
                sb.append(it.next() + "\n");
            }
            return sb.toString();
        }

        public String dumpHistory() {
            StringBuilder sb = new StringBuilder();
            for (String line : this.history) {
                sb.append(line + "\n");
            }
            return sb.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void process(List<GmsImpl.Request> requests) {
            if (requests.isEmpty()) {
                return;
            }
            if (GMS.this.log.isTraceEnabled()) {
                GMS.this.log.trace((Object)("processing " + requests));
            }
            GmsImpl.Request firstReq = requests.get(0);
            switch (firstReq.type) {
                case 1: 
                case 2: 
                case 3: 
                case 6: {
                    GMS.this.impl.handleMembershipChange(requests);
                    break;
                }
                case 4: {
                    if (requests.size() > 1) {
                        GMS.this.log.error((Object)"more than one MERGE request to process, ignoring the others");
                    }
                    GMS.this.impl.merge(firstReq.coordinators);
                    break;
                }
                case 5: {
                    if (requests.size() > 1) {
                        GMS.this.log.error((Object)"more than one VIEW request to process, ignoring the others");
                    }
                    try {
                        GMS.this.castViewChangeWithDest(firstReq.view, firstReq.digest, firstReq.target_members);
                        break;
                    }
                    finally {
                        if (GMS.this.flushProtocolInStack) {
                            GMS.this.stopFlush();
                        }
                    }
                }
                default: {
                    GMS.this.log.error((Object)("request " + firstReq.type + " is unknown; discarded"));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void start(boolean unsuspend) {
            if (this.q.closed()) {
                this.q.reset();
            }
            if (unsuspend) {
                Future future;
                this.suspended = false;
                Map<Object, Future> map = this.resume_tasks;
                synchronized (map) {
                    future = this.resume_tasks.remove(this.merge_id);
                }
                if (future != null) {
                    future.cancel(true);
                }
            }
            this.merge_id = null;
            if (this.thread == null || !this.thread.isAlive()) {
                this.thread = GMS.this.getProtocolStack().getThreadFactory().newThread(this, "ViewHandler");
                this.thread.setDaemon(false);
                this.thread.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void stop(boolean flush) {
            this.q.close(flush);
            Map<Object, Future> map = this.resume_tasks;
            synchronized (map) {
                for (Future future : this.resume_tasks.values()) {
                    future.cancel(true);
                }
                this.resume_tasks.clear();
            }
            this.merge_id = null;
        }
    }

    public static class GmsHeader
    extends Header
    implements Streamable {
        public static final byte JOIN_REQ = 1;
        public static final byte JOIN_RSP = 2;
        public static final byte LEAVE_REQ = 3;
        public static final byte LEAVE_RSP = 4;
        public static final byte VIEW = 5;
        public static final byte MERGE_REQ = 6;
        public static final byte MERGE_RSP = 7;
        public static final byte INSTALL_MERGE_VIEW = 8;
        public static final byte CANCEL_MERGE = 9;
        public static final byte VIEW_ACK = 10;
        public static final byte JOIN_REQ_WITH_STATE_TRANSFER = 11;
        byte type = 0;
        View view = null;
        Address mbr = null;
        JoinRsp join_rsp = null;
        Digest my_digest = null;
        ViewId merge_id = null;
        boolean merge_rejected = false;
        private static final long serialVersionUID = 2369798797842183276L;

        public GmsHeader() {
        }

        public GmsHeader(byte type) {
            this.type = type;
        }

        public GmsHeader(byte type, View view) {
            this.type = type;
            this.view = view;
        }

        public GmsHeader(byte type, Address mbr) {
            this.type = type;
            this.mbr = mbr;
        }

        public GmsHeader(byte type, JoinRsp join_rsp) {
            this.type = type;
            this.join_rsp = join_rsp;
        }

        public byte getType() {
            return this.type;
        }

        public Address getMember() {
            return this.mbr;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("GmsHeader");
            sb.append('[' + GmsHeader.type2String(this.type) + ']');
            switch (this.type) {
                case 1: {
                    sb.append(": mbr=" + this.mbr);
                    break;
                }
                case 2: {
                    sb.append(": join_rsp=" + this.join_rsp);
                    break;
                }
                case 3: {
                    sb.append(": mbr=" + this.mbr);
                    break;
                }
                case 4: {
                    break;
                }
                case 5: 
                case 10: {
                    sb.append(": view=" + this.view);
                    break;
                }
                case 6: {
                    sb.append(": merge_id=" + this.merge_id);
                    break;
                }
                case 7: {
                    sb.append(": view=" + this.view + ", digest=" + this.my_digest + ", merge_rejected=" + this.merge_rejected + ", merge_id=" + this.merge_id);
                    break;
                }
                case 8: {
                    sb.append(": view=" + this.view + ", digest=" + this.my_digest);
                    break;
                }
                case 9: {
                    sb.append(", <merge cancelled>, merge_id=" + this.merge_id);
                }
            }
            return sb.toString();
        }

        public static String type2String(int type) {
            switch (type) {
                case 1: {
                    return "JOIN_REQ";
                }
                case 2: {
                    return "JOIN_RSP";
                }
                case 3: {
                    return "LEAVE_REQ";
                }
                case 4: {
                    return "LEAVE_RSP";
                }
                case 5: {
                    return "VIEW";
                }
                case 6: {
                    return "MERGE_REQ";
                }
                case 7: {
                    return "MERGE_RSP";
                }
                case 8: {
                    return "INSTALL_MERGE_VIEW";
                }
                case 9: {
                    return "CANCEL_MERGE";
                }
                case 10: {
                    return "VIEW_ACK";
                }
                case 11: {
                    return "JOIN_REQ_WITH_STATE_TRANSFER";
                }
            }
            return "<unknown>";
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(this.type);
            out.writeObject(this.view);
            out.writeObject(this.mbr);
            out.writeObject(this.join_rsp);
            out.writeObject(this.my_digest);
            out.writeObject(this.merge_id);
            out.writeBoolean(this.merge_rejected);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readByte();
            this.view = (View)in.readObject();
            this.mbr = (Address)in.readObject();
            this.join_rsp = (JoinRsp)in.readObject();
            this.my_digest = (Digest)in.readObject();
            this.merge_id = (ViewId)in.readObject();
            this.merge_rejected = in.readBoolean();
        }

        public void writeTo(DataOutputStream out) throws IOException {
            out.writeByte(this.type);
            boolean isMergeView = this.view != null && this.view instanceof MergeView;
            out.writeBoolean(isMergeView);
            Util.writeStreamable(this.view, out);
            Util.writeAddress(this.mbr, out);
            Util.writeStreamable(this.join_rsp, out);
            Util.writeStreamable(this.my_digest, out);
            Util.writeStreamable(this.merge_id, out);
            out.writeBoolean(this.merge_rejected);
        }

        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readByte();
            boolean isMergeView = in.readBoolean();
            this.view = isMergeView ? (View)Util.readStreamable(MergeView.class, in) : (View)Util.readStreamable(View.class, in);
            this.mbr = Util.readAddress(in);
            this.join_rsp = (JoinRsp)Util.readStreamable(JoinRsp.class, in);
            this.my_digest = (Digest)Util.readStreamable(Digest.class, in);
            this.merge_id = (ViewId)Util.readStreamable(ViewId.class, in);
            this.merge_rejected = in.readBoolean();
        }

        public int size() {
            int retval = 2;
            ++retval;
            ++retval;
            if (this.view != null) {
                retval += this.view.serializedSize();
            }
            retval += Util.size(this.mbr);
            ++retval;
            if (this.join_rsp != null) {
                retval += this.join_rsp.serializedSize();
            }
            ++retval;
            if (this.my_digest != null) {
                retval = (int)((long)retval + this.my_digest.serializedSize());
            }
            ++retval;
            if (this.merge_id != null) {
                retval += this.merge_id.serializedSize();
            }
            return retval;
        }
    }
}

