/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.collection;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.Domain;
import org.jboss.aop.FieldInfo;
import org.jboss.aop.GeneratedAdvisorDomain;
import org.jboss.aop.GeneratedClassAdvisor;
import org.jboss.aop.GeneratedInstanceAdvisorMixin;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.JoinPointInfo;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.instrument.Untransformable;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.metadata.SimpleMetaData;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.pojo.annotation.Reentrant;
import org.jboss.cache.pojo.impl.PojoCacheImpl;
import org.jboss.cache.pojo.interceptors.dynamic.AbstractCollectionInterceptor;
import org.jboss.cache.pojo.util.AopUtil;
import org.jboss.cache.pojo.util.CacheApiUtil;
import org.jboss.cache.pojo.util.Null;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Reentrant
public class CachedSetImpl
extends AbstractSet
implements Advised {
    private PojoCacheImpl pojoCache;
    private Cache<Object, Object> cache;
    private AbstractCollectionInterceptor interceptor;
    private static transient Advisor aop$classAdvisor$aop = new CachedSetImplAdvisor();
    protected volatile transient Advisor currentAdvisor$aop = this._getAdvisor();
    protected transient InstanceAdvisor instanceAdvisor$aop;

    public CachedSetImpl(PojoCacheImpl cache, AbstractCollectionInterceptor interceptor) {
        this.pojoCache = cache;
        this.cache = this.pojoCache.getCache();
        this.interceptor = interceptor;
    }

    private Set<Node> getNodeChildren() {
        return CacheApiUtil.getNodeChildren(this.cache, this.getFqn());
    }

    private Fqn getFqn() {
        return this.interceptor.getFqn();
    }

    @Override
    public boolean add(Object o) {
        o = Null.toNullObject(o);
        int hashCode = o.hashCode();
        int size = this.size();
        for (int i = 0; i < size + 1; ++i) {
            String key = this.toLong(hashCode, i);
            Object o2 = this.getNoUnmask(key);
            if (o2 == null) {
                this.attach(key, o, true);
                return true;
            }
            if (!o.equals(o2)) continue;
            return false;
        }
        throw new CacheException();
    }

    @Override
    public void clear() {
        Set<Node> children = this.getNodeChildren();
        for (Node n : children) {
            this.pojoCache.detach(n.getFqn());
        }
    }

    @Override
    public boolean contains(Object o) {
        o = Null.toNullObject(o);
        int hashCode = o.hashCode();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            String key = this.toLong(hashCode, i);
            Object o2 = this.getNoUnmask(key);
            if (o2 == null) {
                return false;
            }
            if (!o.equals(o2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator iterator() {
        Node node = this.cache.getRoot().getChild(this.getFqn());
        if (node == null) {
            return Collections.EMPTY_SET.iterator();
        }
        return new IteratorImpl(node);
    }

    @Override
    public boolean remove(Object o) {
        String key;
        Object o2;
        o = Null.toNullObject(o);
        int hashCode = o.hashCode();
        int size = this.size();
        boolean removed = false;
        String oldkey = null;
        for (int i = 0; i < size && (o2 = this.getNoUnmask(key = this.toLong(hashCode, i))) != null; ++i) {
            if (removed) {
                this.detach(key);
                this.attach(oldkey, o2);
            }
            if (o.equals(o2)) {
                this.detach(key, true);
                removed = true;
            }
            oldkey = key;
        }
        return removed;
    }

    @Override
    public int size() {
        Set<Node> children = this.getNodeChildren();
        return children == null ? 0 : children.size();
    }

    public String org$jboss$cache$pojo$collection$CachedSetImpl$toString$aop() {
        StringBuffer buf = new StringBuffer();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            buf.append("[").append(key).append("]");
            if (!it.hasNext()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    private String toLong(long hashCode, long count) {
        long key = hashCode & 0xFFFFL | count << 32;
        return Long.toHexString(key);
    }

    private Object attach(Object key, Object pojo) {
        return this.attach(key, pojo, false);
    }

    private Object attach(Object key, Object pojo, boolean add) {
        Fqn fqn = AopUtil.constructFqn(this.getFqn(), key);
        Object o = this.pojoCache.attach(fqn, pojo);
        if (add) {
            this.pojoCache.getCache().put(fqn, (Object)"POJOCache.Operation", (Object)"ADD");
        }
        return o;
    }

    private Object detach(Object key) {
        return this.detach(key, false);
    }

    private Object detach(Object key, boolean remove) {
        Fqn fqn = AopUtil.constructFqn(this.getFqn(), key);
        if (remove) {
            this.pojoCache.getCache().put(fqn, (Object)"POJOCache.Operation", (Object)"REMOVE");
        }
        return this.pojoCache.detach(fqn);
    }

    private Object getNoUnmask(Object key) {
        return this.pojoCache.getObject(AopUtil.constructFqn(this.getFqn(), key));
    }

    public int org$jboss$cache$pojo$collection$CachedSetImpl$hashCode$aop() {
        int result = super.hashCode();
        result = 29 * result + this.cache.hashCode();
        result = 29 * result + this.interceptor.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        try {
            return super.equals(o);
        }
        catch (ClassCastException e) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
    }

    public Advisor _getAdvisor() {
        return aop$classAdvisor$aop;
    }

    public static Advisor _getClassAdvisor() {
        return aop$classAdvisor$aop;
    }

    protected Advisor getCurrentAdvisor$aop() {
        if (this.currentAdvisor$aop == null) {
            this.currentAdvisor$aop = this._getAdvisor();
        }
        return this.currentAdvisor$aop;
    }

    public InstanceAdvisor _getInstanceAdvisor() {
        if (this.instanceAdvisor$aop == null) {
            CachedSetImpl cachedSetImpl = this;
            synchronized (cachedSetImpl) {
                if (this.instanceAdvisor$aop == null) {
                    Advisor advisor;
                    this.currentAdvisor$aop = advisor = ((CachedSetImplAdvisor)aop$classAdvisor$aop).createInstanceAdvisor(this);
                    this.instanceAdvisor$aop = (InstanceAdvisor)advisor;
                }
            }
        }
        return this.instanceAdvisor$aop;
    }

    @Override
    public String toString() {
        return ((CachedSetImplAdvisor)this.getCurrentAdvisor$aop()).toString6853976482757027775(this);
    }

    @Override
    public int hashCode() {
        return ((CachedSetImplAdvisor)this.getCurrentAdvisor$aop()).hashCode2593808613140459179(this);
    }

    private class IteratorImpl
    implements Iterator {
        private Iterator<NodeSPI> iterator;
        private Node node;
        private Object o;

        private IteratorImpl(Node node) {
            HashSet children = new HashSet(((NodeSPI)node).getChildrenDirect());
            this.iterator = children.iterator();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            this.node = (Node)this.iterator.next();
            this.o = Null.toNullValue(CachedSetImpl.this.pojoCache.getObject(this.node.getFqn()));
            return this.o;
        }

        public void remove() throws IllegalStateException {
            if (this.node == null) {
                throw new IllegalStateException();
            }
            CachedSetImpl.this.remove(this.o);
        }
    }

    public static class CachedSetImplAdvisor
    extends GeneratedClassAdvisor
    implements Untransformable {
        protected Domain domain;
        protected MethodInfo aop$MethodInfo_toString6853976482757027775;
        public JoinPoint_toString6853976482757027775 joinpoint_toString6853976482757027775;
        protected MethodInfo aop$MethodInfo_hashCode2593808613140459179;
        public JoinPoint_hashCode2593808613140459179 joinpoint_hashCode2593808613140459179;

        public Domain getDomain() {
            return this.domain;
        }

        protected void initialiseMethods() {
            Object var2_1 = null;
            this.aop$MethodInfo_toString6853976482757027775 = new MethodInfo(Class.forName("org.jboss.cache.pojo.collection.CachedSetImpl"), 6853976482757027775L, 3769355086859508614L, (Advisor)this);
            this.addMethodInfo(this.aop$MethodInfo_toString6853976482757027775);
            Object var4_2 = null;
            this.aop$MethodInfo_hashCode2593808613140459179 = new MethodInfo(Class.forName("org.jboss.cache.pojo.collection.CachedSetImpl"), 2593808613140459179L, -1850010916556568587L, (Advisor)this);
            this.addMethodInfo(this.aop$MethodInfo_hashCode2593808613140459179);
        }

        protected void initialiseConstructors(Collection collection) {
        }

        protected void initialiseConstructions(Collection collection) {
        }

        protected void initialiseFieldReads(Collection collection) {
        }

        protected void initialiseFieldWrites(Collection collection) {
        }

        protected void initialiseCallers() {
        }

        protected void initialise(AspectManager aspectManager, boolean bl) {
            String string = Domain.getDomainName(((Object)((Object)this)).getClass().getDeclaringClass(), (boolean)bl);
            this.domain = new GeneratedAdvisorDomain(aspectManager, string, ((Object)((Object)this)).getClass().getDeclaringClass(), bl);
            this.domain.setInheritsBindings(true);
            super.initialise(((Object)((Object)this)).getClass().getDeclaringClass(), (AspectManager)this.domain);
        }

        public CachedSetImplAdvisor() {
            super("org.jboss.cache.pojo.collection.CachedSetImpl");
            this.initialise(AspectManager.instance((ClassLoader)((Object)((Object)this)).getClass().getClassLoader()), false);
        }

        public CachedSetImplAdvisor(CachedSetImplAdvisor cachedSetImplAdvisor) {
            super("org.jboss.cache.pojo.collection.CachedSetImpl", (GeneratedClassAdvisor)cachedSetImplAdvisor);
            this.initialise((AspectManager)cachedSetImplAdvisor.getDomain(), true);
        }

        protected CachedSetImplAdvisor(String string) {
            super(string);
        }

        protected CachedSetImplAdvisor(String string, GeneratedClassAdvisor generatedClassAdvisor) {
            super(string, generatedClassAdvisor);
        }

        public Advisor createInstanceAdvisor(Object object) {
            return new CachedSetImplInstanceAdvisor(object, this);
        }

        protected String toString6853976482757027775(CachedSetImpl cachedSetImpl) {
            if (this.joinpoint_toString6853976482757027775 == null && this.aop$MethodInfo_toString6853976482757027775 != null && this.aop$MethodInfo_toString6853976482757027775.hasAdvices()) {
                this.aop$MethodInfo_toString6853976482757027775.getInterceptorChainReadWriteLock().readLock().lock();
                try {
                    if (this.joinpoint_toString6853976482757027775 == null) {
                        if (this.aop$MethodInfo_toString6853976482757027775 == null) {
                        } else if (!this.aop$MethodInfo_toString6853976482757027775.hasAdvices()) {
                        } else {
                            super.generateJoinPointClass(this.aop$MethodInfo_toString6853976482757027775);
                        }
                    }
                }
                finally {
                    this.aop$MethodInfo_toString6853976482757027775.getInterceptorChainReadWriteLock().readLock().unlock();
                }
            }
            if (this.joinpoint_toString6853976482757027775 == null) {
                return cachedSetImpl.org$jboss$cache$pojo$collection$CachedSetImpl$toString$aop();
            }
            return this.joinpoint_toString6853976482757027775.invokeJoinpoint(cachedSetImpl);
        }

        protected int hashCode2593808613140459179(CachedSetImpl cachedSetImpl) {
            if (this.joinpoint_hashCode2593808613140459179 == null && this.aop$MethodInfo_hashCode2593808613140459179 != null && this.aop$MethodInfo_hashCode2593808613140459179.hasAdvices()) {
                this.aop$MethodInfo_hashCode2593808613140459179.getInterceptorChainReadWriteLock().readLock().lock();
                try {
                    if (this.joinpoint_hashCode2593808613140459179 == null) {
                        if (this.aop$MethodInfo_hashCode2593808613140459179 == null) {
                        } else if (!this.aop$MethodInfo_hashCode2593808613140459179.hasAdvices()) {
                        } else {
                            super.generateJoinPointClass(this.aop$MethodInfo_hashCode2593808613140459179);
                        }
                    }
                }
                finally {
                    this.aop$MethodInfo_hashCode2593808613140459179.getInterceptorChainReadWriteLock().readLock().unlock();
                }
            }
            if (this.joinpoint_hashCode2593808613140459179 == null) {
                return cachedSetImpl.org$jboss$cache$pojo$collection$CachedSetImpl$hashCode$aop();
            }
            return this.joinpoint_hashCode2593808613140459179.invokeJoinpoint(cachedSetImpl);
        }
    }

    public static class CachedSetImplInstanceAdvisor
    extends CachedSetImplAdvisor
    implements Untransformable,
    InstanceAdvisor {
        GeneratedInstanceAdvisorMixin instanceAdvisorMixin;
        CachedSetImplAdvisor parent = null;
        protected boolean aop$MethodInfo_toString6853976482757027775_updated;
        protected boolean aop$MethodInfo_hashCode2593808613140459179_updated;

        protected void advicesUpdated() {
            Object var2_1 = null;
            this.aop$MethodInfo_toString6853976482757027775_updated = true;
            this.aop$MethodInfo_hashCode2593808613140459179_updated = true;
        }

        protected void lockWriteInterceptorChains() {
            Object var2_1 = null;
            this.aop$MethodInfo_toString6853976482757027775.getInterceptorChainReadWriteLock().writeLock().lock();
            this.aop$MethodInfo_hashCode2593808613140459179.getInterceptorChainReadWriteLock().writeLock().lock();
        }

        protected void unlockWriteInterceptorChains() {
            Object var2_1 = null;
            this.aop$MethodInfo_toString6853976482757027775.getInterceptorChainReadWriteLock().writeLock().unlock();
            this.aop$MethodInfo_hashCode2593808613140459179.getInterceptorChainReadWriteLock().writeLock().unlock();
        }

        public SimpleMetaData getMetaData() {
            return this.instanceAdvisorMixin.getMetaData();
        }

        public Object getInstance() {
            return this.instanceAdvisorMixin.getInstance();
        }

        public boolean hasInterceptors() {
            return this.instanceAdvisorMixin.hasInterceptors();
        }

        public void insertInterceptor(Interceptor interceptor) {
            this.lockWriteInterceptorChains();
            try {
                this.advicesUpdated();
                this.instanceAdvisorMixin.insertInterceptor(interceptor);
            }
            finally {
                this.unlockWriteInterceptorChains();
            }
        }

        public void insertInterceptor(int n, Interceptor interceptor) throws IndexOutOfBoundsException {
            this.lockWriteInterceptorChains();
            try {
                this.advicesUpdated();
                this.instanceAdvisorMixin.insertInterceptor(n, interceptor);
            }
            finally {
                this.unlockWriteInterceptorChains();
            }
        }

        public void insertInterceptorStack(String string) {
            this.lockWriteInterceptorChains();
            try {
                this.advicesUpdated();
                this.instanceAdvisorMixin.insertInterceptorStack(string);
            }
            finally {
                this.unlockWriteInterceptorChains();
            }
        }

        public void appendInterceptor(Interceptor interceptor) {
            this.lockWriteInterceptorChains();
            try {
                this.advicesUpdated();
                this.instanceAdvisorMixin.appendInterceptor(interceptor);
            }
            finally {
                this.unlockWriteInterceptorChains();
            }
        }

        public void appendInterceptor(int n, Interceptor interceptor) throws IndexOutOfBoundsException {
            this.lockWriteInterceptorChains();
            try {
                this.advicesUpdated();
                this.instanceAdvisorMixin.appendInterceptor(n, interceptor);
            }
            finally {
                this.unlockWriteInterceptorChains();
            }
        }

        public void appendInterceptorStack(String string) {
            this.lockWriteInterceptorChains();
            try {
                this.advicesUpdated();
                this.instanceAdvisorMixin.appendInterceptorStack(string);
            }
            finally {
                this.unlockWriteInterceptorChains();
            }
        }

        public void removeInterceptor(String string) {
            this.lockWriteInterceptorChains();
            try {
                this.advicesUpdated();
                this.instanceAdvisorMixin.removeInterceptor(string);
            }
            finally {
                this.unlockWriteInterceptorChains();
            }
        }

        public void removeInterceptorStack(String string) {
            this.lockWriteInterceptorChains();
            try {
                this.advicesUpdated();
                this.instanceAdvisorMixin.removeInterceptorStack(string);
            }
            finally {
                this.unlockWriteInterceptorChains();
            }
        }

        public Interceptor[] getInterceptors() {
            return this.instanceAdvisorMixin.getInterceptors();
        }

        public Interceptor[] getInterceptors(Interceptor[] interceptorArray) {
            return this.instanceAdvisorMixin.getInterceptors(interceptorArray);
        }

        public Object getPerInstanceAspect(String string) {
            return this.instanceAdvisorMixin.getPerInstanceAspect(string);
        }

        public Object getPerInstanceAspect(AspectDefinition aspectDefinition) {
            return this.instanceAdvisorMixin.getPerInstanceAspect(aspectDefinition);
        }

        public Object getPerInstanceJoinpointAspect(Joinpoint joinpoint, AspectDefinition aspectDefinition) {
            return this.instanceAdvisorMixin.getPerInstanceJoinpointAspect(joinpoint, aspectDefinition);
        }

        protected void doRebuildForInstance() {
            this.lockWriteInterceptorChains();
            try {
                this.internalRebuildInterceptors();
                if (this.instanceAdvisorMixin.hasInterceptors()) {
                    this.advicesUpdated();
                }
            }
            finally {
                this.unlockWriteInterceptorChains();
            }
        }

        public CachedSetImplInstanceAdvisor(Object object, CachedSetImplAdvisor cachedSetImplAdvisor) {
            super(cachedSetImplAdvisor);
            this.instanceAdvisorMixin = new GeneratedInstanceAdvisorMixin(object, (GeneratedClassAdvisor)cachedSetImplAdvisor);
            this.parent = cachedSetImplAdvisor;
        }

        protected void initialiseInfosForInstance() {
            Object var2_1 = null;
            CachedSetImplAdvisor cachedSetImplAdvisor = (CachedSetImplAdvisor)CachedSetImpl._getClassAdvisor();
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            this.aop$MethodInfo_toString6853976482757027775 = super.copyInfoFromClassAdvisor(((CachedSetImplAdvisor)CachedSetImpl._getClassAdvisor()).aop$MethodInfo_toString6853976482757027775);
            this.aop$MethodInfo_hashCode2593808613140459179 = super.copyInfoFromClassAdvisor(((CachedSetImplAdvisor)CachedSetImpl._getClassAdvisor()).aop$MethodInfo_hashCode2593808613140459179);
            ((ClassAdvisor)this).fieldReadInfos = arrayList.toArray(new FieldInfo[arrayList.size()]);
            ((ClassAdvisor)this).fieldWriteInfos = arrayList2.toArray(new FieldInfo[arrayList2.size()]);
        }

        protected String toString6853976482757027775(CachedSetImpl cachedSetImpl) {
            this.checkVersion();
            if (this.aop$MethodInfo_toString6853976482757027775_updated) {
                this.aop$MethodInfo_toString6853976482757027775.getInterceptorChainReadWriteLock().writeLock().lock();
                try {
                    this.aop$MethodInfo_toString6853976482757027775.setInterceptors(this.instanceAdvisorMixin.getWrappers(this.parent.aop$MethodInfo_toString6853976482757027775.getInterceptors()));
                    this.joinpoint_toString6853976482757027775 = null;
                    this.aop$MethodInfo_toString6853976482757027775_updated = false;
                    super.rebindJoinPointWithInstanceInformation((JoinPointInfo)this.aop$MethodInfo_toString6853976482757027775);
                }
                finally {
                    this.aop$MethodInfo_toString6853976482757027775.getInterceptorChainReadWriteLock().writeLock().unlock();
                }
            }
            return super.toString6853976482757027775(cachedSetImpl);
        }

        protected int hashCode2593808613140459179(CachedSetImpl cachedSetImpl) {
            this.checkVersion();
            if (this.aop$MethodInfo_hashCode2593808613140459179_updated) {
                this.aop$MethodInfo_hashCode2593808613140459179.getInterceptorChainReadWriteLock().writeLock().lock();
                try {
                    this.aop$MethodInfo_hashCode2593808613140459179.setInterceptors(this.instanceAdvisorMixin.getWrappers(this.parent.aop$MethodInfo_hashCode2593808613140459179.getInterceptors()));
                    this.joinpoint_hashCode2593808613140459179 = null;
                    this.aop$MethodInfo_hashCode2593808613140459179_updated = false;
                    super.rebindJoinPointWithInstanceInformation((JoinPointInfo)this.aop$MethodInfo_hashCode2593808613140459179);
                }
                finally {
                    this.aop$MethodInfo_hashCode2593808613140459179.getInterceptorChainReadWriteLock().writeLock().unlock();
                }
            }
            return super.hashCode2593808613140459179(cachedSetImpl);
        }
    }

    public static class JoinPoint_toString6853976482757027775
    extends MethodInvocation
    implements Untransformable {
        protected transient CachedSetImpl typedTargetObject;
        protected transient MethodInfo info;

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[0];
            return this.arguments;
        }

        final void enforceArgsConsistency() {
        }

        protected String invokeJoinpoint(CachedSetImpl cachedSetImpl) throws Throwable {
            return null;
        }

        public JoinPoint_toString6853976482757027775() {
        }

        public JoinPoint_toString6853976482757027775(MethodInfo methodInfo) {
            super(methodInfo, methodInfo.getInterceptors());
            this.info = methodInfo;
        }

        protected JoinPoint_toString6853976482757027775(JoinPoint_toString6853976482757027775 joinPoint_toString6853976482757027775, CachedSetImpl cachedSetImpl) {
            this(joinPoint_toString6853976482757027775.info);
            this.typedTargetObject = cachedSetImpl;
            super.setTargetObject((Object)cachedSetImpl);
        }

        public Object dispatch() throws Throwable {
            this.enforceArgsConsistency();
            return this.typedTargetObject.org$jboss$cache$pojo$collection$CachedSetImpl$toString$aop();
        }

        protected String dispatch(CachedSetImpl cachedSetImpl) {
            return cachedSetImpl.org$jboss$cache$pojo$collection$CachedSetImpl$toString$aop();
        }

        public Object invokeTarget() throws Throwable {
            return this.dispatch();
        }
    }

    public static class JoinPoint_hashCode2593808613140459179
    extends MethodInvocation
    implements Untransformable {
        protected transient CachedSetImpl typedTargetObject;
        protected transient MethodInfo info;

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[0];
            return this.arguments;
        }

        final void enforceArgsConsistency() {
        }

        protected int invokeJoinpoint(CachedSetImpl cachedSetImpl) throws Throwable {
            return 0;
        }

        public JoinPoint_hashCode2593808613140459179() {
        }

        public JoinPoint_hashCode2593808613140459179(MethodInfo methodInfo) {
            super(methodInfo, methodInfo.getInterceptors());
            this.info = methodInfo;
        }

        protected JoinPoint_hashCode2593808613140459179(JoinPoint_hashCode2593808613140459179 joinPoint_hashCode2593808613140459179, CachedSetImpl cachedSetImpl) {
            this(joinPoint_hashCode2593808613140459179.info);
            this.typedTargetObject = cachedSetImpl;
            super.setTargetObject((Object)cachedSetImpl);
        }

        public Object dispatch() throws Throwable {
            this.enforceArgsConsistency();
            return new Integer(this.typedTargetObject.org$jboss$cache$pojo$collection$CachedSetImpl$hashCode$aop());
        }

        protected int dispatch(CachedSetImpl cachedSetImpl) {
            return cachedSetImpl.org$jboss$cache$pojo$collection$CachedSetImpl$hashCode$aop();
        }

        public Object invokeTarget() throws Throwable {
            return this.dispatch();
        }
    }
}

