/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.cache.Fqn;
import org.jboss.cache.pojo.impl.PojoUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PojoInstance
implements Serializable {
    public static final String KEY = "POJOCache.PojoInstance";
    public static final int INITIAL_COUNTER_VALUE = -1;
    static final long serialVersionUID = 6492134565825613209L;
    private transient Object instance_;
    private String internalFqn_ = null;
    private int refCount_ = -1;
    private List<Fqn> referencedBy_ = null;
    private Class clazz_ = null;
    private transient PojoUtil util_ = new PojoUtil();

    public PojoInstance() {
    }

    public PojoInstance(Object instance) {
        this.set(instance);
    }

    public void setPojoClass(Class clazz) {
        this.clazz_ = clazz;
    }

    public Class getPojoClass() {
        return this.clazz_;
    }

    public Object get() {
        return this.instance_;
    }

    public void set(Object instance) {
        this.instance_ = instance;
    }

    public String getInternalFqn() {
        return this.internalFqn_;
    }

    public void setInternalFqn(String refFqn) {
        this.internalFqn_ = refFqn;
    }

    public void removeInternalFqn() {
        this.internalFqn_ = null;
    }

    public synchronized int incrementRefCount(Fqn sourceFqn) {
        if (sourceFqn == null) {
            throw new IllegalStateException("PojoInstance.incrementRefCount(): null sourceFqn");
        }
        if (this.referencedBy_ == null) {
            this.referencedBy_ = new ArrayList<Fqn>();
        }
        if (this.referencedBy_.contains(sourceFqn)) {
            throw new IllegalStateException("PojoReference.incrementRefCount(): source fqn: " + sourceFqn + " is already present.");
        }
        if (this.util_ == null) {
            this.util_ = new PojoUtil();
        }
        this.refCount_ = this.util_.incrementReferenceCount(sourceFqn, this.refCount_, this.referencedBy_);
        return this.refCount_;
    }

    public synchronized int decrementRefCount(Fqn sourceFqn) {
        if (sourceFqn == null) {
            throw new IllegalStateException("PojoInstance.incrementRefCount(): null sourceFqn");
        }
        if (!this.referencedBy_.contains(sourceFqn)) {
            throw new IllegalStateException("PojoReference.decrementRefCount(): source fqn: " + sourceFqn + " is not present.");
        }
        if (this.util_ == null) {
            this.util_ = new PojoUtil();
        }
        this.refCount_ = this.util_.decrementReferenceCount(sourceFqn, this.refCount_, this.referencedBy_);
        return this.refCount_;
    }

    public synchronized int getRefCount() {
        return this.refCount_;
    }

    public List<Fqn> getReferences() {
        return Collections.unmodifiableList(this.referencedBy_);
    }

    public synchronized Fqn getAndRemoveFirstFqnInList() {
        return this.referencedBy_.remove(0);
    }

    public synchronized void addXFqnIntoList(Fqn fqn) {
        this.referencedBy_.add(0, fqn);
    }

    public String toString() {
        return "PI[fqn=" + this.internalFqn_ + " ref=" + this.refCount_ + " class=" + this.clazz_.getName() + "]";
    }
}

