/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.interceptors.dynamic;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.cache.Fqn;
import org.jboss.cache.pojo.collection.CachedMapImpl;
import org.jboss.cache.pojo.collection.CollectionInterceptorUtil;
import org.jboss.cache.pojo.impl.PojoCacheImpl;
import org.jboss.cache.pojo.interceptors.dynamic.AbstractCollectionInterceptor;

public class CachedMapInterceptor
extends AbstractCollectionInterceptor {
    private static final Map managedMethods_ = CollectionInterceptorUtil.getManagedMethods(Map.class);
    private Map methodMap_;
    private Map cacheImpl_;
    private Map inMemImpl_;
    private Map current_;

    public CachedMapInterceptor(PojoCacheImpl cache, Fqn fqn, Class clazz, Map obj) {
        super(cache, fqn);
        this.methodMap_ = CollectionInterceptorUtil.getMethodMap(clazz);
        this.cacheImpl_ = new CachedMapImpl(cache, this);
        this.inMemImpl_ = obj;
        this.current_ = this.cacheImpl_;
    }

    private CachedMapInterceptor(PojoCacheImpl cache, Fqn fqn) {
        super(cache, fqn);
    }

    public Object clone() {
        CachedMapInterceptor interceptor = new CachedMapInterceptor(this.cache, this.fqn);
        interceptor.setFqn(this.getFqn());
        interceptor.setAopInstance(this.getAopInstance());
        interceptor.setCurrentCopy(this.getCurrentCopy());
        interceptor.setInMemoryCopy(this.getInMemoryCopy());
        interceptor.setCacheCopy(this.getCacheCopy());
        return interceptor;
    }

    public void setInterceptor(Interceptor intcptr) {
        CachedMapInterceptor interceptor = (CachedMapInterceptor)intcptr;
        this.setFqn(interceptor.getFqn());
        this.setAopInstance(interceptor.getAopInstance());
        this.setCurrentCopy(interceptor.getCurrentCopy());
        this.setInMemoryCopy(interceptor.getInMemoryCopy());
        this.setCacheCopy(interceptor.getCacheCopy());
    }

    public Object getCurrentCopy() {
        return this.current_;
    }

    void setInMemoryCopy(Object obj) {
        this.inMemImpl_ = (Map)obj;
    }

    Object getInMemoryCopy() {
        return this.inMemImpl_;
    }

    void setCacheCopy(Object obj) {
        this.cacheImpl_ = (Map)obj;
    }

    Object getCacheCopy() {
        return this.cacheImpl_;
    }

    void setCurrentCopy(Object obj) {
        this.current_ = (Map)obj;
    }

    public void attach(Fqn fqn, boolean copyToCache) {
        super.attach(fqn, copyToCache);
        if (copyToCache) {
            this.toCache();
        }
        this.current_ = this.cacheImpl_;
    }

    private void toCache() {
        if (this.inMemImpl_ == null) {
            throw new IllegalStateException("CachedMapInterceptor.toCache(). inMemImpl is null.");
        }
        for (Object key : this.inMemImpl_.keySet()) {
            Object val = this.inMemImpl_.get(key);
            this.cacheImpl_.put(key, val);
        }
        this.inMemImpl_.clear();
        this.inMemImpl_ = null;
    }

    public void detach(boolean removeFromCache) {
        super.detach(removeFromCache);
        this.toMemory(removeFromCache);
        this.current_ = this.inMemImpl_;
    }

    private void toMemory(boolean removeFromCache) {
        if (this.inMemImpl_ == null) {
            this.inMemImpl_ = new HashMap();
        }
        Iterator it = this.cacheImpl_.keySet().iterator();
        this.inMemImpl_.clear();
        while (it.hasNext()) {
            Object key = it.next();
            Object val = null;
            val = removeFromCache ? (Object)this.cacheImpl_.remove(key) : (Object)this.cacheImpl_.get(key);
            this.inMemImpl_.put(key, val);
        }
    }

    public String getName() {
        return "CachedMapInterceptor";
    }

    public Object invoke(Invocation invocation) throws Throwable {
        if (this.current_ == null) {
            throw new IllegalStateException("CachedMapInterceptor.invoke(). current_ is null.");
        }
        return CollectionInterceptorUtil.invoke(invocation, this, this.current_, this.methodMap_, managedMethods_);
    }
}

