/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.buddyreplication;

import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.buddyreplication.BuddyReplicationTestsBase;
import org.jboss.cache.misc.TestingUtil;
import org.jgroups.Address;
import org.testng.AssertJUnit;

public class BuddyReplicationFailoverTest
extends BuddyReplicationTestsBase {
    protected boolean optimisticLocks = false;
    private String key = "key";
    private String value = "value";

    public void testDataGravitationKillOwner() throws Exception {
        this.testDataGravitation(true);
    }

    public void testDataGravitationDontKillOwner() throws Exception {
        this.testDataGravitation(false);
    }

    private void testDataGravitation(boolean killOwner) throws Exception {
        this.caches = this.createCaches(3, false, true, this.optimisticLocks);
        Fqn fqn = Fqn.fromString((String)"/test");
        Fqn backupFqn = BuddyManager.getBackupFqn((Address)((CacheSPI)this.caches.get(0)).getLocalAddress(), (Fqn)fqn);
        this.dumpCacheContents(this.caches);
        ((CacheSPI)this.caches.get(0)).put(fqn, (Object)this.key, (Object)this.value);
        this.dumpCacheContents(this.caches);
        AssertJUnit.assertEquals((String)"Value should exist", (Object)this.value, (Object)((CacheSPI)this.caches.get(0)).get(fqn, (Object)this.key));
        this.dumpCacheContents(this.caches);
        AssertJUnit.assertTrue((String)"Should be false", (!((CacheSPI)this.caches.get(1)).exists(fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"Should be false", (!((CacheSPI)this.caches.get(2)).exists(fqn) ? 1 : 0) != 0);
        AssertJUnit.assertFalse((String)"Should be false", (boolean)((CacheSPI)this.caches.get(0)).exists(backupFqn));
        AssertJUnit.assertTrue((String)"Value be true", (boolean)((CacheSPI)this.caches.get(1)).exists(backupFqn));
        AssertJUnit.assertFalse((String)"Should be false", (boolean)((CacheSPI)this.caches.get(2)).exists(backupFqn));
        if (killOwner) {
            System.out.println("***** About to kill original data owner (" + ((CacheSPI)this.caches.get(0)).getLocalAddress() + ").  *****");
            ((CacheSPI)this.caches.get(0)).stop();
            this.caches.set(0, null);
            TestingUtil.blockUntilViewsReceived(300000L, false, (Cache)this.caches.get(1), (Cache)this.caches.get(2));
        }
        System.out.println("***** Killed original data owner, about to call a get on a different cache instance.  *****");
        AssertJUnit.assertEquals((String)"Value should have gravitated", (Object)this.value, (Object)((CacheSPI)this.caches.get(2)).get(fqn, (Object)this.key));
        TestingUtil.sleepThread(500L);
        this.dumpCacheContents(this.caches);
        Fqn newBackupFqn = BuddyManager.getBackupFqn((Address)((CacheSPI)this.caches.get(2)).getLocalAddress(), (Fqn)fqn);
        if (!killOwner) {
            AssertJUnit.assertTrue((String)"Should be false", (!((CacheSPI)this.caches.get(0)).exists(fqn) ? 1 : 0) != 0);
        }
        AssertJUnit.assertTrue((String)"Should be false", (!((CacheSPI)this.caches.get(1)).exists(fqn) ? 1 : 0) != 0);
        if (!killOwner) {
            AssertJUnit.assertFalse((String)"Should be null", (boolean)((CacheSPI)this.caches.get(0)).exists(backupFqn));
        }
        AssertJUnit.assertFalse((String)"Should be null", (boolean)((CacheSPI)this.caches.get(1)).exists(backupFqn));
        AssertJUnit.assertFalse((String)"Should be null", (boolean)((CacheSPI)this.caches.get(2)).exists(backupFqn));
        if (killOwner) {
            AssertJUnit.assertEquals((String)"Value should exist", (Object)this.value, (Object)((CacheSPI)this.caches.get(1)).get(newBackupFqn, (Object)this.key));
        } else {
            AssertJUnit.assertEquals((String)"Value should exist", (Object)this.value, (Object)((CacheSPI)this.caches.get(0)).get(newBackupFqn, (Object)this.key));
            AssertJUnit.assertFalse((String)"Should be null", (boolean)((CacheSPI)this.caches.get(1)).exists(newBackupFqn));
        }
        AssertJUnit.assertFalse((String)"Should be null", (boolean)((CacheSPI)this.caches.get(2)).exists(newBackupFqn));
    }

    public void testDataReplicationSuppression() throws Exception {
        this.caches = this.createCaches(3, false, false, this.optimisticLocks);
        Fqn fqn = Fqn.fromString((String)"/test");
        Fqn backupFqn = BuddyManager.getBackupFqn((Address)((CacheSPI)this.caches.get(0)).getLocalAddress(), (Fqn)fqn);
        ((CacheSPI)this.caches.get(0)).put(fqn, (Object)this.key, (Object)this.value);
        this.dumpCacheContents(this.caches);
        AssertJUnit.assertEquals((Object)"value", (Object)((CacheSPI)this.caches.get(0)).get(fqn, (Object)this.key));
        AssertJUnit.assertFalse((boolean)((CacheSPI)this.caches.get(0)).exists(backupFqn));
        AssertJUnit.assertEquals((Object)"value", (Object)((CacheSPI)this.caches.get(1)).get(backupFqn, (Object)this.key));
        AssertJUnit.assertFalse((boolean)((CacheSPI)this.caches.get(1)).exists(fqn));
        AssertJUnit.assertFalse((boolean)((CacheSPI)this.caches.get(2)).exists(fqn));
        AssertJUnit.assertFalse((boolean)((CacheSPI)this.caches.get(2)).exists(backupFqn));
        this.assertNoLocks(this.caches);
        backupFqn = BuddyManager.getBackupFqn((Address)((CacheSPI)this.caches.get(1)).getLocalAddress(), (Fqn)fqn);
        System.out.println("*** Calling get() on cache[1] with force option");
        ((CacheSPI)this.caches.get(1)).getInvocationContext().getOptionOverrides().setForceDataGravitation(true);
        AssertJUnit.assertEquals((Object)"value", (Object)((CacheSPI)this.caches.get(1)).get(fqn, (Object)this.key));
        this.dumpCacheContents(this.caches);
        AssertJUnit.assertFalse((boolean)((CacheSPI)this.caches.get(1)).exists(backupFqn));
        AssertJUnit.assertEquals((Object)"value", (Object)((CacheSPI)this.caches.get(2)).get(backupFqn, (Object)this.key));
        AssertJUnit.assertFalse((boolean)((CacheSPI)this.caches.get(2)).exists(fqn));
        AssertJUnit.assertFalse((boolean)((CacheSPI)this.caches.get(0)).exists(fqn));
        AssertJUnit.assertFalse((boolean)((CacheSPI)this.caches.get(0)).exists(backupFqn));
    }

    public void testSubtreeRetrieval() throws Exception {
        this.caches = this.createCaches(3, false, true, this.optimisticLocks);
        Fqn fqn = Fqn.fromString((String)"/test");
        Fqn fqn2 = Fqn.fromString((String)"/test/subtree");
        Fqn backupFqn = Fqn.fromString((String)("/_BUDDY_BACKUP_/" + BuddyManager.getGroupNameFromAddress((Object)((CacheSPI)this.caches.get(0)).getLocalAddress()) + "/test"));
        Fqn backupFqn2 = Fqn.fromString((String)("/_BUDDY_BACKUP_/" + BuddyManager.getGroupNameFromAddress((Object)((CacheSPI)this.caches.get(0)).getLocalAddress()) + "/test/subtree"));
        ((CacheSPI)this.caches.get(0)).put(fqn, (Object)this.key, (Object)this.value);
        ((CacheSPI)this.caches.get(0)).put(fqn2, (Object)this.key, (Object)this.value);
        AssertJUnit.assertEquals((Object)this.value, (Object)((CacheSPI)this.caches.get(0)).get(fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)this.value, (Object)((CacheSPI)this.caches.get(0)).get(fqn2, (Object)this.key));
        AssertJUnit.assertEquals((Object)this.value, (Object)((CacheSPI)this.caches.get(1)).get(backupFqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)this.value, (Object)((CacheSPI)this.caches.get(1)).get(backupFqn2, (Object)this.key));
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(0)).exists(backupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(0)).exists(backupFqn2) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(1)).exists(fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(1)).exists(fqn2) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(2)).exists(fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(2)).exists(fqn2) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(2)).exists(backupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(2)).exists(backupFqn2) ? 1 : 0) != 0);
        this.assertNoLocks(this.caches);
        ((CacheSPI)this.caches.get(2)).getNode(fqn);
        Fqn newBackupFqn = Fqn.fromString((String)("/_BUDDY_BACKUP_/" + BuddyManager.getGroupNameFromAddress((Object)((CacheSPI)this.caches.get(2)).getLocalAddress()) + "/test"));
        Fqn newBackupFqn2 = Fqn.fromString((String)("/_BUDDY_BACKUP_/" + BuddyManager.getGroupNameFromAddress((Object)((CacheSPI)this.caches.get(2)).getLocalAddress()) + "/test/subtree"));
        AssertJUnit.assertEquals((Object)this.value, (Object)((CacheSPI)this.caches.get(2)).get(fqn, (Object)this.key));
        AssertJUnit.assertTrue((boolean)((CacheSPI)this.caches.get(2)).exists(fqn2));
        AssertJUnit.assertEquals((Object)this.value, (Object)((CacheSPI)this.caches.get(0)).get(newBackupFqn, (Object)this.key));
        AssertJUnit.assertTrue((boolean)((CacheSPI)this.caches.get(0)).exists(newBackupFqn2));
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(2)).exists(newBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(2)).exists(newBackupFqn2) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(0)).exists(fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(0)).exists(fqn2) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(1)).exists(fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(1)).exists(fqn2) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(1)).exists(newBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(1)).exists(newBackupFqn2) ? 1 : 0) != 0);
        for (CacheSPI cache : this.caches) {
            AssertJUnit.assertTrue((!cache.exists(backupFqn) ? 1 : 0) != 0);
            AssertJUnit.assertTrue((!cache.exists(backupFqn2) ? 1 : 0) != 0);
        }
        this.assertNoLocks(this.caches);
    }
}

