/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.jmx;

import java.util.List;
import javax.management.ObjectName;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.jmx.CacheJmxWrapper;
import org.jboss.cache.jmx.CacheJmxWrapperMBean;
import org.jboss.cache.jmx.CacheJmxWrapperTestBase;
import org.jboss.cache.misc.TestingUtil;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.CacheStarted;
import org.jboss.cache.notifications.annotation.CacheStopped;
import org.jboss.cache.notifications.event.Event;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.jgroups.Address;
import org.jgroups.stack.IpAddress;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class CacheJmxWrapperTest
extends CacheJmxWrapperTestBase {
    public void testCacheMBeanBinding() throws Exception {
        this.registerWrapper();
        AssertJUnit.assertTrue((String)"Should be registered", (boolean)this.mBeanServer.isRegistered(this.mBeanName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetCacheObjectName() throws Exception {
        ObjectName on = new ObjectName("jboss.cache:test=SetCacheObjectName");
        String str = on.getCanonicalName();
        boolean registered = false;
        try {
            CacheJmxWrapper<String, String> wrapper = this.createWrapper(this.createConfiguration());
            wrapper.setCacheObjectName(str);
            this.registerWrapper((CacheJmxWrapperMBean<String, String>)wrapper);
            registered = this.mBeanServer.isRegistered(on);
            AssertJUnit.assertTrue((String)"Registered with configured name", (boolean)registered);
            AssertJUnit.assertEquals((String)"Configured name retained", (String)str, (String)wrapper.getCacheObjectName());
            wrapper.create();
            wrapper.start();
            this.interceptorRegistrationTest(str, true);
            wrapper.stop();
            wrapper.destroy();
            this.interceptorRegistrationTest(false);
        }
        finally {
            if (registered) {
                this.mBeanServer.unregisterMBean(on);
            }
        }
    }

    public void testGetCacheObjectName() throws Exception {
        ObjectName on = new ObjectName("jboss.cache:test=SetCacheObjectName");
        String str = on.getCanonicalName();
        CacheJmxWrapper<String, String> wrapper = this.createWrapper(this.createConfiguration());
        wrapper.setCacheObjectName(str);
        AssertJUnit.assertEquals((String)"Setter and getter match", (String)str, (String)wrapper.getCacheObjectName());
        wrapper.setCacheObjectName(null);
        AssertJUnit.assertEquals((String)"Got default ObjectName", (String)"jboss.cache:service=JBossCache,cluster=CacheMBeanTest", (String)wrapper.getCacheObjectName());
        this.registerWrapper((CacheJmxWrapperMBean<String, String>)wrapper);
        AssertJUnit.assertEquals((String)"Returns standard name", (Object)this.mBeanName, (Object)new ObjectName(wrapper.getCacheObjectName()));
    }

    public void testGetConfiguration1() throws Exception {
        CacheJmxWrapperMBean<String, String> wrapper = this.registerWrapper();
        Configuration cfgFromJmx = wrapper.getConfiguration();
        AssertJUnit.assertNotNull((String)"Got a configuration", (Object)cfgFromJmx);
        AssertJUnit.assertSame((Object)this.cache.getConfiguration(), (Object)cfgFromJmx);
    }

    public void testGetConfiguration2() throws Exception {
        Configuration cfg = this.createConfiguration();
        CacheJmxWrapperMBean<String, String> wrapper = this.registerWrapper(cfg);
        Configuration cfgFromJmx = wrapper.getConfiguration();
        AssertJUnit.assertNotNull((String)"Got a configuration", (Object)cfgFromJmx);
        AssertJUnit.assertSame((Object)cfg, (Object)cfgFromJmx);
    }

    public void testPrintConfigurationAsString1() throws Exception {
        CacheJmxWrapperMBean<String, String> wrapper = this.registerWrapper();
        String cfgFromJmx = wrapper.printConfigurationAsString();
        AssertJUnit.assertEquals((String)this.cache.getConfiguration().toString(), (String)cfgFromJmx);
    }

    public void testPrintConfigurationAsString2() throws Exception {
        Configuration cfg = this.createConfiguration();
        CacheJmxWrapperMBean<String, String> wrapper = this.registerWrapper(cfg);
        wrapper.create();
        wrapper.start();
        String cfgFromJmx = wrapper.printConfigurationAsString();
        AssertJUnit.assertEquals((String)wrapper.getCache().getConfiguration().toString(), (String)cfgFromJmx);
    }

    public void testPrintConfigurationAsHtml1() throws Exception {
        CacheJmxWrapperMBean<String, String> wrapper = this.registerWrapper();
        String cfgFromJmx = wrapper.printConfigurationAsHtmlString();
        AssertJUnit.assertEquals((String)CacheJmxWrapper.formatHtml((String)this.cache.getConfiguration().toString()), (String)cfgFromJmx);
        this.checkHtml(cfgFromJmx, false);
    }

    public void testPrintConfigurationAsHtml2() throws Exception {
        Configuration cfg = this.createConfiguration();
        CacheJmxWrapperMBean<String, String> wrapper = this.registerWrapper(cfg);
        wrapper.create();
        wrapper.start();
        String cfgFromJmx = wrapper.printConfigurationAsHtmlString();
        AssertJUnit.assertEquals((String)CacheJmxWrapper.formatHtml((String)wrapper.getCache().getConfiguration().toString()), (String)cfgFromJmx);
        this.checkHtml(cfgFromJmx, false);
    }

    public void testGetCache() throws Exception {
        this.registerWrapper();
        this.cache.start();
        Cache cacheJmx = (Cache)this.mBeanServer.getAttribute(this.mBeanName, "Cache");
        cacheJmx.getRoot().put((Object)"key", (Object)"value");
        AssertJUnit.assertEquals((String)"value", (String)((String)this.cache.getRoot().get((Object)"key")));
        Fqn fqn = Fqn.fromString((String)"/testing/jmx");
        this.cache.put(fqn, (Object)"key", (Object)"value");
        AssertJUnit.assertEquals((String)"value", (String)((String)cacheJmx.get(fqn, (Object)"key")));
    }

    public void testPrintCacheDetails() throws Exception {
        this.printCacheDetailsTest(false);
    }

    public void testPrintCacheDetailsAsHtml() throws Exception {
        String html = this.printCacheDetailsTest(true);
        this.checkHtml(html, true);
    }

    public void testPrintLockInfo() throws Exception {
        this.printLockInfoTest(false);
    }

    public void testPrintLockInfoAsHtml() throws Exception {
        this.printLockInfoTest(true);
    }

    public void testGetLocalAddress() throws Exception {
        Configuration c = this.createConfiguration();
        c.setCacheMode(Configuration.CacheMode.REPL_ASYNC);
        CacheJmxWrapperMBean<String, String> wrapper = this.registerWrapper(c);
        wrapper.start();
        AssertJUnit.assertTrue((String)"Got an IpAddress", (boolean)(wrapper.getLocalAddress() instanceof IpAddress));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetMembers() throws Exception {
        Configuration c = this.createConfiguration();
        c.setCacheMode(Configuration.CacheMode.REPL_ASYNC);
        CacheJmxWrapperMBean<String, String> wrapper = this.registerWrapper(c);
        wrapper.start();
        c = this.createConfiguration();
        c.setCacheMode(Configuration.CacheMode.REPL_ASYNC);
        Cache<String, String> cache2 = null;
        try {
            cache2 = this.createCache(c);
            cache2.start();
            Cache[] caches = new Cache[]{wrapper.getCache(), cache2};
            TestingUtil.blockUntilViewsReceived(caches, 5000L);
            Address addr = wrapper.getLocalAddress();
            AssertJUnit.assertNotNull((String)"Got an Address", (Object)addr);
            List members = wrapper.getMembers();
            AssertJUnit.assertNotNull((String)"Got members", (Object)addr);
            AssertJUnit.assertEquals((String)"Got correct number of members", (int)2, (int)members.size());
            AssertJUnit.assertTrue((String)"I am a member", (boolean)members.contains(addr));
        }
        finally {
            if (cache2 != null) {
                cache2.destroy();
            }
        }
    }

    public void testDuplicateInvocation() throws Exception {
        CacheJmxWrapperMBean<String, String> cache = this.registerWrapper();
        cache.create();
        cache.start();
        cache.create();
        cache.start();
        cache.getCache().put(Fqn.fromString((String)"/a/b/c"), null);
        AssertJUnit.assertTrue((cache.getNumberOfNodes() > 0 ? 1 : 0) != 0);
        AssertJUnit.assertEquals((int)0, (int)cache.getNumberOfAttributes());
        System.out.println("cache locks before restart:\n" + cache.printLockInfo());
        cache.destroy();
        cache.start();
        System.out.println("cache locks after restart:\n" + cache.printLockInfo());
        AssertJUnit.assertEquals((int)0, (int)cache.getNumberOfNodes());
        AssertJUnit.assertEquals((int)0, (int)cache.getNumberOfAttributes());
        cache.stop();
        cache.destroy();
        cache.stop();
        cache.destroy();
    }

    public void testFailedStart() throws Exception {
        CacheJmxWrapper wrapper = new CacheJmxWrapper(this.createCache(this.createConfiguration()));
        this.registerWrapper((CacheJmxWrapperMBean<String, String>)wrapper);
        AssertJUnit.assertEquals((String)"Correct state", (Object)CacheStatus.INSTANTIATED, (Object)wrapper.getCacheStatus());
        wrapper.create();
        DisruptLifecycleListener listener = new DisruptLifecycleListener();
        listener.setDisrupt(true);
        wrapper.getCache().addCacheListener((Object)listener);
        AssertJUnit.assertEquals((String)"Correct state", (Object)CacheStatus.CREATED, (Object)wrapper.getCacheStatus());
        try {
            wrapper.start();
            AssertJUnit.fail((String)"Listener did not prevent start");
        }
        catch (CacheException good) {
            // empty catch block
        }
        AssertJUnit.assertEquals((String)"Correct state", (Object)CacheStatus.FAILED, (Object)wrapper.getCacheStatus());
        listener.setDisrupt(false);
        wrapper.start();
        AssertJUnit.assertEquals((String)"Correct state", (Object)CacheStatus.STARTED, (Object)wrapper.getCacheStatus());
        wrapper.getCache().put(Fqn.fromString((String)"/a/b/c"), null);
        AssertJUnit.assertTrue((wrapper.getNumberOfNodes() > 0 ? 1 : 0) != 0);
        AssertJUnit.assertEquals((int)0, (int)wrapper.getNumberOfAttributes());
        listener.setDisrupt(true);
        this.cache.addCacheListener((Object)listener);
        try {
            wrapper.stop();
            AssertJUnit.fail((String)"Listener did not prevent stop");
        }
        catch (CacheException cacheException) {
            // empty catch block
        }
        AssertJUnit.assertEquals((String)"Correct state", (Object)CacheStatus.FAILED, (Object)wrapper.getCacheStatus());
        listener.setDisrupt(false);
        wrapper.stop();
        AssertJUnit.assertEquals((String)"Correct state", (Object)CacheStatus.STOPPED, (Object)wrapper.getCacheStatus());
        wrapper.destroy();
        AssertJUnit.assertEquals((String)"Correct state", (Object)CacheStatus.DESTROYED, (Object)wrapper.getCacheStatus());
    }

    private String printCacheDetailsTest(boolean html) throws Exception {
        CacheJmxWrapperMBean<String, String> wrapper = this.registerWrapper();
        this.cache.start();
        Fqn fqn = Fqn.fromString((String)"/testing/jmx");
        this.cache.put(fqn, (Object)"foobar", (Object)"barfoo");
        AssertJUnit.assertEquals((String)"barfoo", (String)((String)this.cache.get(fqn, (Object)"foobar")));
        String details = html ? wrapper.printCacheDetailsAsHtml() : wrapper.printCacheDetails();
        AssertJUnit.assertTrue((String)"Details include testing", (boolean)details.contains("testing"));
        AssertJUnit.assertTrue((String)"Details include jmx", (boolean)details.contains("jmx"));
        AssertJUnit.assertTrue((String)"Details include foobar", (boolean)details.contains("foobar"));
        AssertJUnit.assertTrue((String)"Details include barfoo", (boolean)details.contains("barfoo"));
        return details;
    }

    private String printLockInfoTest(boolean html) throws Exception {
        Configuration config = this.createConfiguration();
        config.setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        Cache<String, String> c = this.createCache(config);
        CacheJmxWrapperMBean<String, String> wrapper = this.registerWrapper(c);
        wrapper.create();
        wrapper.start();
        TransactionManager tm = config.getRuntimeConfig().getTransactionManager();
        tm.begin();
        try {
            Fqn fqn = Fqn.fromString((String)"/testing/jmx");
            this.cache.put(fqn, (Object)"foobar", (Object)"barfoo");
            String locks = html ? wrapper.printLockInfoAsHtml() : wrapper.printLockInfo();
            AssertJUnit.assertTrue((String)"Details include testing", (boolean)locks.contains("testing"));
            AssertJUnit.assertTrue((String)"Details include jmx", (boolean)locks.contains("jmx"));
            String string = locks;
            return string;
        }
        catch (Exception e) {
            tm.setRollbackOnly();
            throw e;
        }
        finally {
            tm.commit();
        }
    }

    private void checkHtml(String html, boolean checkBR) {
        if (checkBR) {
            AssertJUnit.assertTrue((String)"Has <br", (boolean)html.contains("<br"));
        }
        AssertJUnit.assertTrue((String)"No tabs", (html.indexOf(9) == -1 ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"No spaces", (html.indexOf(32) == -1 ? 1 : 0) != 0);
    }

    @CacheListener
    public class DisruptLifecycleListener {
        private boolean disrupt;

        @CacheStarted
        public void cacheStarted(Event e) {
            if (this.disrupt) {
                throw new IllegalStateException("I don't want to start");
            }
        }

        @CacheStopped
        public void cacheStopped(Event e) {
            if (this.disrupt) {
                throw new IllegalStateException("I don't want to stop");
            }
        }

        public void setDisrupt(boolean disrupt) {
            this.disrupt = disrupt;
        }
    }
}

