/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.util.Iterator;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.interceptors.CacheStoreInterceptor;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.loader.AbstractCacheLoaderTestBase;
import org.jboss.cache.loader.DummyCountingCacheLoader;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class SharedCacheLoaderTest
extends AbstractCacheLoaderTestBase {
    private CacheSPI<Object, Object> cache1;
    private CacheSPI<Object, Object> cache2;
    private DummyCountingCacheLoader dummyCacheLoader;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        if (this.cache1 != null || this.cache2 != null) {
            this.tearDown();
        }
        this.cache1 = (CacheSPI)new DefaultCacheFactory().createCache(false);
        this.cache2 = (CacheSPI)new DefaultCacheFactory().createCache(false);
        this.cache1.getConfiguration().setCacheMode("REPL_SYNC");
        this.cache2.getConfiguration().setCacheMode("REPL_SYNC");
        this.cache1.getConfiguration().setCacheLoaderConfig(this.getSingleCacheLoaderConfig("", DummyCountingCacheLoader.class.getName(), "", false, false, true));
        this.cache2.getConfiguration().setCacheLoaderConfig(this.getSingleCacheLoaderConfig("", DummyCountingCacheLoader.class.getName(), "", false, false, true));
        this.cache1.start();
        this.cache2.start();
        this.dummyCacheLoader = new DummyCountingCacheLoader();
        this.dummyCacheLoader.scrubStats();
    }

    protected CacheStoreInterceptor findCacheStoreInterceptor(CacheSPI cache) {
        Iterator ints = cache.getInterceptorChain().iterator();
        CacheStoreInterceptor csi = null;
        while (ints.hasNext()) {
            Interceptor i = (Interceptor)ints.next();
            if (!(i instanceof CacheStoreInterceptor)) continue;
            csi = (CacheStoreInterceptor)i;
            break;
        }
        return csi;
    }

    @AfterMethod(alwaysRun=true)
    protected void tearDown() {
        if (this.cache1 != null) {
            this.cache1.stop();
        }
        if (this.cache2 != null) {
            this.cache2.stop();
        }
        this.cache1 = null;
        this.cache2 = null;
    }

    public void testReplicationWithSharedCL() {
        this.cache1.put("/test", (Object)"one", (Object)"two");
        AssertJUnit.assertEquals((Object)"two", (Object)this.cache1.get("/test", (Object)"one"));
        AssertJUnit.assertEquals((Object)"two", (Object)this.cache2.get("/test", (Object)"one"));
        AssertJUnit.assertEquals((int)1, (int)this.dummyCacheLoader.getPutCount());
    }
}

