/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.lock;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.lock.IdentityLock;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.lock.LockMap;
import org.jboss.cache.lock.LockStrategyFactory;
import org.jboss.cache.lock.LockingException;
import org.jboss.cache.lock.NodeLock;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.misc.TestingUtil;
import org.jboss.cache.transaction.GlobalTransaction;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class IdentityLockTest {
    NodeLock lock_;
    Object other_ = new Object();
    Log logger_ = LogFactory.getLog(IdentityLockTest.class);
    static Throwable thread_ex = null;
    final NodeSPI NODE = null;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.lock_ = new IdentityLock(this.NODE);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.lock_.releaseAll();
        this.lock_ = null;
        thread_ex = null;
    }

    private void setLevelRW() {
        this.log("set lock level to RWUpgrade ...");
        LockStrategyFactory.setIsolationLevel((IsolationLevel)IsolationLevel.REPEATABLE_READ);
        this.lock_ = new IdentityLock(this.NODE);
    }

    private void setLevelSerial() {
        this.log("set lock level to SimpleLock ...");
        LockStrategyFactory.setIsolationLevel((IsolationLevel)IsolationLevel.SERIALIZABLE);
        this.lock_ = new IdentityLock(this.NODE);
    }

    private GlobalTransaction getGlobalTransactionFromThread() {
        return GlobalTransaction.create(null);
    }

    public void testNullOwner_RWLock() throws InterruptedException {
        this.setLevelRW();
        this.nullOwner();
    }

    public void testNullOwner_SimpleLock() throws InterruptedException {
        this.setLevelSerial();
        this.nullOwner();
    }

    private void nullOwner() throws InterruptedException {
        this.log("testNullOwner ...");
        try {
            GlobalTransaction gtx = this.getGlobalTransactionFromThread();
            this.lock_.acquireWriteLock((Object)gtx, 50L);
            this.lock_.release((Object)gtx);
            this.lock_.acquireReadLock((Object)gtx, 50L);
            this.lock_.release((Object)gtx);
        }
        catch (LockingException e) {
            AssertJUnit.fail((String)e.toString());
        }
        catch (TimeoutException e) {
            AssertJUnit.fail((String)e.toString());
        }
    }

    public void testNullOwner2_RWLock() throws InterruptedException {
        this.setLevelRW();
        this.nullOwner2();
    }

    public void testNullOwner2_SimpleLock() throws InterruptedException {
        this.setLevelSerial();
        this.nullOwner2();
    }

    private void nullOwner2() throws InterruptedException {
        this.log("testNullOwner2 ...");
        try {
            GlobalTransaction gtx = this.getGlobalTransactionFromThread();
            this.lock_.acquireReadLock((Object)gtx, 50L);
            this.lock_.acquireWriteLock((Object)gtx, 50L);
            this.lock_.release((Object)gtx);
        }
        catch (LockingException e) {
            AssertJUnit.fail((String)e.toString());
        }
        catch (TimeoutException e2) {
            AssertJUnit.fail((String)e2.toString());
        }
    }

    public void testNullOwner3_RWLock() throws InterruptedException {
        this.setLevelRW();
        this.nullOwner3();
    }

    public void testNullOwner3_SimpleLock() throws InterruptedException {
        this.setLevelSerial();
        this.nullOwner3();
    }

    private void nullOwner3() throws InterruptedException {
        this.log("testNullOwner3 ...");
        try {
            GlobalTransaction gtx = this.getGlobalTransactionFromThread();
            this.lock_.acquireWriteLock((Object)gtx, 50L);
            this.lock_.acquireReadLock((Object)gtx, 50L);
            this.lock_.release((Object)gtx);
        }
        catch (LockingException e) {
            AssertJUnit.fail((String)e.toString());
        }
        catch (TimeoutException e2) {
            AssertJUnit.fail((String)e2.toString());
        }
    }

    public void testAcquireAndRelease_RWLock() throws InterruptedException {
        this.setLevelRW();
        this.acquireAndRelease();
    }

    public void testAcquireAndRelease_SimpleLock() throws InterruptedException {
        this.setLevelSerial();
        this.acquireAndRelease();
    }

    private void acquireAndRelease() throws InterruptedException {
        this.log("testAcquireAndRelease ...");
        try {
            this.lock_.acquireReadLock((Object)this, 50L);
            AssertJUnit.assertTrue((String)"Is the lock owner", (boolean)this.lock_.isOwner((Object)this));
            AssertJUnit.assertTrue((boolean)this.lock_.getReaderOwners().contains(this));
            this.lock_.acquireReadLock((Object)this, 50L);
            AssertJUnit.assertTrue((String)"Is the lock owner", (boolean)this.lock_.isOwner((Object)this));
            AssertJUnit.assertTrue((boolean)this.lock_.getReaderOwners().contains(this));
            this.lock_.acquireWriteLock((Object)this, 50L);
            AssertJUnit.assertTrue((String)"Is the lock owner", (boolean)this.lock_.isOwner((Object)this));
            AssertJUnit.assertTrue((!this.lock_.getReaderOwners().contains(this) ? 1 : 0) != 0);
            AssertJUnit.assertTrue((boolean)this.lock_.getWriterOwner().equals(this));
            this.lock_.release((Object)this);
            AssertJUnit.assertTrue((!this.lock_.isOwner((Object)this) ? 1 : 0) != 0);
        }
        catch (LockingException e) {
            AssertJUnit.fail((String)e.toString());
        }
        catch (TimeoutException e2) {
            AssertJUnit.fail((String)e2.toString());
        }
    }

    public void testThreadedAccess_RWLock() throws Throwable {
        this.setLevelRW();
        this.log("testThreadedAccess_RWLock ...");
        final Object o1 = new Object();
        final Object o2 = new Object();
        System.out.println("");
        Thread t1 = new Thread(){

            public void run() {
                try {
                    IdentityLockTest.this.log("o1 acquiring lock");
                    IdentityLockTest.this.lock_.acquireReadLock(o1, 50L);
                    IdentityLockTest.this.log("o1: OK");
                }
                catch (Throwable e) {
                    IdentityLockTest.this.log("o1: FAIL");
                    thread_ex = e;
                }
            }
        };
        Thread t2 = new Thread(){

            public void run() {
                try {
                    IdentityLockTest.this.log("o2 acquiring lock");
                    IdentityLockTest.this.lock_.acquireWriteLock(o2, 2000L);
                    IdentityLockTest.this.log("o2: OK");
                }
                catch (Throwable e) {
                    IdentityLockTest.this.log("o2: FAIL");
                    thread_ex = e;
                }
            }
        };
        Thread t3 = new Thread(){

            public void run() {
                try {
                    IdentityLockTest.this.log("o1 acquiring lock");
                    IdentityLockTest.this.lock_.acquireWriteLock(o1, 10L);
                    IdentityLockTest.this.log("o1: OK");
                }
                catch (Throwable e) {
                    IdentityLockTest.this.log("o1: FAIL");
                    thread_ex = e;
                }
            }
        };
        t1.start();
        TestingUtil.sleepThread(100L);
        t2.start();
        TestingUtil.sleepThread(1000L);
        AssertJUnit.assertTrue((boolean)this.lock_.isOwner(o1));
        TestingUtil.sleepThread(100L);
        AssertJUnit.assertTrue((boolean)this.lock_.isOwner(o1));
        t3.start();
        TestingUtil.sleepThread(100L);
        AssertJUnit.assertTrue((boolean)this.lock_.isOwner(o1));
        this.log("o1 releasing lock");
        this.lock_.release(o1);
        this.log("o1: OK");
        TestingUtil.sleepThread(200L);
        t1.join(20000L);
        t2.join(20000L);
        t3.join(20000L);
        if (thread_ex != null) {
            throw thread_ex;
        }
    }

    public void testThreadedAccess_SimpleLock() throws Throwable {
        this.setLevelSerial();
        this.log("testThreadedAccess_SimpleLock() ...");
        final Object o1 = new Object();
        final Object o2 = new Object();
        System.out.println("");
        Thread t1 = new Thread(){

            public void run() {
                try {
                    IdentityLockTest.this.log("o1 acquiring lock");
                    IdentityLockTest.this.lock_.acquireReadLock(o1, 50L);
                    IdentityLockTest.this.log("o1: OK");
                }
                catch (Throwable e) {
                    IdentityLockTest.this.log("o1: FAIL");
                    thread_ex = e;
                }
            }
        };
        Thread t2 = new Thread(){

            public void run() {
                try {
                    IdentityLockTest.this.log("o2 acquiring lock");
                    IdentityLockTest.this.lock_.acquireWriteLock(o2, 2000L);
                    IdentityLockTest.this.log("o2: OK");
                }
                catch (Throwable e) {
                    IdentityLockTest.this.log("o2: FAIL");
                    thread_ex = e;
                }
            }
        };
        Thread t3 = new Thread(){

            public void run() {
                try {
                    IdentityLockTest.this.log("o1 acquiring lock");
                    IdentityLockTest.this.lock_.acquireWriteLock(o1, 10L);
                    IdentityLockTest.this.log("o1: OK");
                }
                catch (Throwable e) {
                    IdentityLockTest.this.log("o1: FAIL");
                    thread_ex = e;
                }
            }
        };
        t1.start();
        t1.join();
        t2.start();
        TestingUtil.sleepThread(1000L);
        AssertJUnit.assertTrue((boolean)this.lock_.isOwner(o1));
        TestingUtil.sleepThread(100L);
        AssertJUnit.assertTrue((boolean)this.lock_.isOwner(o1));
        t3.start();
        TestingUtil.sleepThread(100L);
        AssertJUnit.assertTrue((boolean)this.lock_.isOwner(o1));
        this.log("o1 releasing lock");
        this.lock_.release(o1);
        this.log("o1: OK");
        TestingUtil.sleepThread(200L);
        t2.join(20000L);
        t3.join(20000L);
        if (thread_ex != null) {
            throw thread_ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadAndReleaseAll() {
        this.setLevelRW();
        this.log("testReadAndReleaseAll() ...");
        Object o1 = new Object();
        Object o2 = new Object();
        System.out.println("");
        try {
            this.log("o1: acquiring");
            this.lock_.acquireReadLock(o1, 50L);
            this.log("o1: OK");
            this.log("o2: acquiring");
            this.lock_.acquireReadLock(o2, 50L);
            this.log("o2: OK");
        }
        catch (Throwable t) {
            this.log("read lock: FAIL");
            AssertJUnit.fail((String)t.getMessage());
        }
        Thread t1 = new Thread(){

            public void run() {
                try {
                    IdentityLockTest.this.log("calling releaseAll()");
                    IdentityLockTest.this.lock_.releaseAll();
                    IdentityLockTest.this.log("releaseAll(): OK");
                }
                catch (Throwable e) {
                    IdentityLockTest.this.log("releaseAll(): FAIL");
                    thread_ex = e;
                }
            }
        };
        try {
            t1.setDaemon(true);
            t1.start();
            TestingUtil.sleepThread(1000L);
            AssertJUnit.assertFalse((String)"Lock map cleared", (boolean)this.lock_.isReadLocked());
        }
        finally {
            this.lock_.release(o1);
            this.lock_.release(o2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWriteAndReleaseAll() {
        this.setLevelSerial();
        this.log("testWriteAndReleaseAll() ...");
        Object o1 = new Object();
        System.out.println("");
        try {
            this.log("o1: acquiring");
            this.lock_.acquireWriteLock(o1, 50L);
            this.log("o1: OK");
        }
        catch (Throwable t) {
            this.log("write lock: FAIL");
            AssertJUnit.fail((String)t.getMessage());
        }
        Thread t1 = new Thread(){

            public void run() {
                try {
                    IdentityLockTest.this.log("calling releaseAll()");
                    IdentityLockTest.this.lock_.releaseAll();
                    IdentityLockTest.this.log("releaseAll(): OK");
                }
                catch (Throwable e) {
                    IdentityLockTest.this.log("releaseAll(): FAIL");
                    thread_ex = e;
                }
            }
        };
        try {
            t1.setDaemon(true);
            t1.start();
            TestingUtil.sleepThread(1000L);
            AssertJUnit.assertFalse((String)"Lock map cleared", (boolean)this.lock_.isReadLocked());
        }
        finally {
            this.lock_.release(o1);
        }
    }

    void log(String msg) {
        this.logger_.info((Object)("-- [" + Thread.currentThread() + "]: " + msg));
    }

    public void testConcurrentModificationOfReadLocksAndToString() throws Exception {
        final IdentityLock iLock = (IdentityLock)this.lock_;
        final LockMap lockMap = iLock.getLockMap();
        int opCount = 100000;
        Thread readLockChanger = new Thread(){

            public void run() {
                for (int i = 0; i < 100000; ++i) {
                    if (i % 10 == 0) {
                        System.out.println("readLockChanger loop# " + i);
                    }
                    lockMap.addReader(new Object());
                }
            }
        };
        final boolean[] flags = new boolean[]{false, false};
        Thread toStringProcessor = new Thread(){

            public void run() {
                long initialTime = System.currentTimeMillis();
                for (int i = 0; i < 100000; ++i) {
                    if (i % 10 == 0) {
                        System.out.println("toStringProcessor loop# " + i + ", " + (System.currentTimeMillis() - initialTime));
                        initialTime = System.currentTimeMillis();
                    }
                    try {
                        iLock.toString(new StringBuffer(), false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        flags[0] = true;
                        break;
                    }
                    if (flags[1]) break;
                }
            }
        };
        toStringProcessor.start();
        System.out.println("toStringProcessor started");
        readLockChanger.start();
        System.out.println("readLockChanger started");
        readLockChanger.join();
        flags[1] = true;
        System.out.println("readLockChanger stopped");
        toStringProcessor.join();
        System.out.println("toStringProcessor stopped");
        System.out.println("flags[0]=" + flags[0]);
        AssertJUnit.assertFalse((boolean)flags[0]);
    }
}

