/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.invocation.RemoteCacheInvocationDelegate;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.misc.TestingUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class RemoteCallerReturnValuesTest {
    private CacheSPI<Object, Object> cache;
    private Fqn fqn = Fqn.fromString((String)"/a");
    private Object key = "key";
    private Object value = "value";
    private RemoteCacheInvocationDelegate rcid;
    private Method invokeMethod;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.cache = (CacheSPI)new DefaultCacheFactory().createCache();
        this.cache.put(this.fqn, this.key, this.value);
        this.rcid = TestingUtil.getRemoteDelegate(this.cache);
        this.invokeMethod = this.cache.getClass().getSuperclass().getDeclaredMethod("invoke", MethodCall.class);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.cache.stop();
    }

    public void testMethodsThatShouldReturnValues() throws Throwable {
        MethodCall mc = MethodCallFactory.create((int)25, (Object[])new Object[]{this.fqn});
        assert (this.rcid._replicate(mc) == null);
        List l = this.rcid.clusteredGet(mc, Boolean.valueOf(false));
        assert (l != null);
        assert (((Boolean)l.get(0)).booleanValue());
        assert (l.get(1).equals(Collections.singleton(this.key)));
    }

    public void testMethodsThatShouldReturnNull() throws Throwable {
        this.doNullReturnTest(24, Collections.singletonMap(this.key, this.value), this.fqn);
        this.doNullReturnTest(31, this.cache.getNode(this.fqn), this.fqn);
        this.doNullReturnTest(25, Collections.singleton(this.key), this.fqn);
        this.doNullReturnTest(23, Collections.emptySet(), this.fqn);
        this.doNullReturnTest(3, this.value, null, this.fqn, this.key, this.value, true);
        this.doNullReturnTest(6, this.value, null, this.fqn, this.key, true);
    }

    private void doNullReturnTest(int methodId, Object expectedretValForLocalTest, Object ... args) throws Throwable {
        MethodCall mc = MethodCallFactory.create((int)methodId, (Object[])args);
        Object retVal = this.invokeCallDirectly(mc);
        assert (retVal != null && retVal.equals(expectedretValForLocalTest));
        Object retVal2 = this.rcid._replicate(mc);
        assert (retVal2 == null);
    }

    private Object invokeCallDirectly(MethodCall mc) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        this.invokeMethod.setAccessible(true);
        return this.invokeMethod.invoke(this.cache, mc);
    }
}

