/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.replicated;

import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.misc.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional", "jgroups"})
public class AsyncReplTest {
    private CacheSPI<Object, Object> cache1;
    private CacheSPI<Object, Object> cache2;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.log("creating cache1");
        this.cache1 = this.createCache("CacheGroup");
        this.log("creating cache2");
        this.cache2 = this.createCache("CacheGroup");
    }

    private CacheSPI<Object, Object> createCache(String name) throws Exception {
        CacheSPI cache = (CacheSPI)new DefaultCacheFactory().createCache(UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_ASYNC), false);
        cache.getConfiguration().setClusterName(name);
        this.configureMultiplexer((Cache)cache);
        cache.create();
        cache.start();
        this.validateMultiplexer((Cache)cache);
        return cache;
    }

    protected void configureMultiplexer(Cache cache) throws Exception {
    }

    protected void validateMultiplexer(Cache cache) {
        AssertJUnit.assertFalse((String)"Cache is not using multiplexer", (boolean)cache.getConfiguration().isUsingMultiplexer());
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this.cache1 != null) {
            this.log("stopping cache1");
            this.cache1.stop();
            this.cache1 = null;
        }
        if (this.cache2 != null) {
            this.log("stopping cache2");
            this.cache2.stop();
            this.cache2 = null;
        }
    }

    public void testTxCompletion() throws Exception {
        Fqn fqn = Fqn.fromString((String)"/a");
        String key = "key";
        this.cache1.put(fqn, (Object)key, (Object)"value1");
        TestingUtil.sleepThread(500L);
        AssertJUnit.assertEquals((Object)"value1", (Object)this.cache1.get(fqn, (Object)key));
        AssertJUnit.assertEquals((Object)"value1", (Object)this.cache2.get(fqn, (Object)key));
        TransactionManager mgr = this.cache1.getTransactionManager();
        mgr.begin();
        this.cache1.put(fqn, (Object)key, (Object)"value2");
        AssertJUnit.assertEquals((Object)"value2", (Object)this.cache1.get(fqn, (Object)key));
        AssertJUnit.assertEquals((Object)"value1", (Object)this.cache2.get(fqn, (Object)key));
        mgr.commit();
        TestingUtil.sleepThread(500L);
        AssertJUnit.assertEquals((Object)"value2", (Object)this.cache1.get(fqn, (Object)key));
        AssertJUnit.assertEquals((Object)"value2", (Object)this.cache2.get(fqn, (Object)key));
        mgr.begin();
        this.cache1.put(fqn, (Object)key, (Object)"value3");
        AssertJUnit.assertEquals((Object)"value3", (Object)this.cache1.get(fqn, (Object)key));
        AssertJUnit.assertEquals((Object)"value2", (Object)this.cache2.get(fqn, (Object)key));
        mgr.rollback();
        TestingUtil.sleepThread(500L);
        AssertJUnit.assertEquals((Object)"value2", (Object)this.cache1.get(fqn, (Object)key));
        AssertJUnit.assertEquals((Object)"value2", (Object)this.cache2.get(fqn, (Object)key));
        if (this.cache1 != null) {
            this.cache1.stop();
            this.cache1 = null;
        }
        if (this.cache2 != null) {
            this.cache2.stop();
            this.cache2 = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPutShouldNotReplicateToDifferentCluster() {
        CacheSPI<Object, Object> cache3 = null;
        CacheSPI<Object, Object> cache4 = null;
        try {
            cache3 = this.createCache("DifferentGroup");
            cache4 = this.createCache("DifferentGroup");
            this.cache1.put("/a/b/c", (Object)"age", (Object)38);
            TestingUtil.sleepThread(1000L);
            AssertJUnit.assertNull((String)"Should not have replicated", (Object)cache3.get("/a/b/c", (Object)"age"));
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
        finally {
            if (cache3 != null) {
                cache3.stop();
            }
            if (cache4 != null) {
                cache4.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStateTransfer() {
        CacheSPI<Object, Object> cache4 = null;
        try {
            this.cache1.put("a/b/c", (Object)"age", (Object)38);
            cache4 = this.createCache("CacheGroup");
            System.out.println("" + cache4.getMembers());
            AssertJUnit.assertEquals((int)3, (int)cache4.getMembers().size());
            AssertJUnit.assertEquals((String)"\"age\" should be 38", (Object)38, (Object)cache4.get("/a/b/c", (Object)"age"));
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
        finally {
            if (cache4 != null) {
                System.out.println("cache4's view: " + cache4.getMembers());
                cache4.stop();
            }
        }
    }

    public void testAsyncReplDelay() {
        try {
            this.cache1.put("/a/b/c", (Object)"age", (Object)38);
            Integer age = (Integer)this.cache2.get("/a/b/c", (Object)"age");
            this.log("attr \"age\" of \"/a/b/c\" on cache2=" + age);
            AssertJUnit.assertTrue((String)"should be either null or 38", (age == null || age == 38 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
    }

    public void testAsyncReplTxDelay() {
        try {
            TransactionManager tm = this.cache1.getTransactionManager();
            tm.begin();
            this.cache1.put("/a/b/c", (Object)"age", (Object)38);
            tm.commit();
            Integer age = (Integer)this.cache2.get("/a/b/c", (Object)"age");
            this.log("attr \"age\" of \"/a/b/c\" on cache2=" + age);
            AssertJUnit.assertTrue((String)"should be either null or 38", (age == null || age == 38 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
    }

    private void log(String msg) {
        System.out.println("-- [" + Thread.currentThread() + "]: " + msg);
    }
}

