/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import javassist.CtClass;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.SecurityActions;
import org.jboss.aop.instrument.InstrumentorEnum;
import org.jboss.aop.instrument.InstrumentorFactory;
import org.jboss.aop.util.logging.AOPLogger;
import org.jboss.logging.Logger;

public class AdvisorFactory {
    private static final Logger logger = AOPLogger.getLogger(AdvisorFactory.class);
    protected static final int CLASS = 1;
    protected static final int OTHER_ADVISOR = 1000;
    protected static int advisor = 0;
    protected static Constructor otherAdvisorConstructor;
    private static final Class[] NO_ARGS;
    private static final Class[] CONSTRUCTOR_SIG;

    public static void initialise(String property) {
        if (AspectManager.verbose && logger.isDebugEnabled()) {
            logger.debug((Object)("Passed in advisor: " + property));
        }
        if (property != null) {
            if (property.equals(ClassAdvisor.class.getName())) {
                advisor = 1;
            } else {
                try {
                    Class<?> otherAdvisorClass = SecurityActions.getContextClassLoader().loadClass(property);
                    otherAdvisorConstructor = otherAdvisorClass.getConstructor(CONSTRUCTOR_SIG);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Invalid advisor " + property + " was used");
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(property + " does not have a constructor with the expected signature");
                }
            }
        } else {
            if (AspectManager.verbose && logger.isDebugEnabled()) {
                logger.debug((Object)("[debug] Defaulting advisor to: " + ClassAdvisor.class.getName()));
            }
            advisor = 1;
        }
    }

    public static ClassAdvisor getClassAdvisor(Class clazz, AspectManager am) {
        return AdvisorFactory.getClassAdvisor(clazz.getName(), am, clazz);
    }

    public static ClassAdvisor getClassAdvisor(CtClass clazz, AspectManager am) {
        return AdvisorFactory.getClassAdvisor(clazz.getName(), am, null);
    }

    private static ClassAdvisor getClassAdvisor(String className, AspectManager am, Class loadedClass) {
        if (advisor == 1) {
            if (loadedClass != null && InstrumentorFactory.getInstrumentor() == InstrumentorEnum.GENERATED_ADVISOR) {
                try {
                    ClassAdvisor advisor;
                    final Method getAdvisor = loadedClass.getMethod("_getClassAdvisor", NO_ARGS);
                    if (!getAdvisor.isAccessible()) {
                        if (System.getSecurityManager() == null) {
                            getAdvisor.setAccessible(true);
                        } else {
                            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                                @Override
                                public Object run() throws Exception {
                                    getAdvisor.setAccessible(true);
                                    return null;
                                }
                            });
                        }
                    }
                    if ((advisor = (ClassAdvisor)getAdvisor.invoke(null, null)) != null && advisor.getClazz() == loadedClass) {
                        return advisor;
                    }
                }
                catch (NoSuchMethodException e) {
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return new ClassAdvisor(className, am);
        }
        if (otherAdvisorConstructor != null) {
            try {
                return (ClassAdvisor)otherAdvisorConstructor.newInstance(className, am);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("Advisor is not set");
    }

    static {
        NO_ARGS = new Class[0];
        CONSTRUCTOR_SIG = new Class[]{String.class, AspectManager.class};
    }
}

