/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice.annotation;

import java.lang.reflect.Method;
import org.jboss.aop.advice.AdviceMethodProperties;
import org.jboss.aop.advice.annotation.AdviceMethodFactory;
import org.jboss.aop.advice.annotation.assignability.DegreeAlgorithm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AdviceInfo
implements Comparable<AdviceInfo> {
    protected static final DegreeAlgorithm DEGREE = DegreeAlgorithm.getInstance();
    protected int rank;
    protected Method method;
    protected Class<?>[] parameterTypes;

    protected AdviceInfo(Method method, int rank) {
        this.method = method;
        this.rank = rank;
        this.parameterTypes = method.getParameterTypes();
    }

    public final short getReturnAssignabilityDegree(AdviceMethodProperties properties) {
        Class<?> returnType = this.method.getReturnType();
        if (returnType == Void.TYPE) {
            return Short.MAX_VALUE;
        }
        short degree = DEGREE.getAssignabilityDegree(properties.getJoinpointReturnType(), returnType);
        if (degree == Short.MAX_VALUE) {
            return 32766;
        }
        return degree;
    }

    public final int getRank() {
        return this.rank;
    }

    @Override
    public int compareTo(AdviceInfo o) {
        return o.rank - this.rank;
    }

    public String toString() {
        return this.method.toString();
    }

    public abstract boolean matches(AdviceMethodProperties var1, AdviceMethodFactory.ReturnType var2);

    public abstract void resetMatching();

    public abstract short getAssignabilityDegree(int var1, boolean var2, AdviceMethodProperties var3);

    public abstract void assignAdviceInfo(AdviceMethodProperties var1);
}

