/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.util.Map;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNode<K, V> {
    protected boolean deleted;
    protected Map<Object, Node<K, V>> children;
    protected Fqn<?> fqn;
    protected boolean resident;

    public boolean isDeleted() {
        return this.deleted;
    }

    public void markAsDeleted(boolean marker) {
        this.markAsDeleted(marker, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAsDeleted(boolean marker, boolean recursive) {
        this.deleted = marker;
        if (recursive && this.children != null) {
            AbstractNode abstractNode = this;
            synchronized (abstractNode) {
                for (Node<K, V> child : this.children.values()) {
                    ((NodeSPI)child).markAsDeleted(marker, true);
                }
            }
        }
    }

    public void setResident(boolean resident) {
        this.resident = resident;
    }

    public boolean isResident() {
        return this.resident;
    }

    public boolean equals(Object another) {
        if (another instanceof AbstractNode) {
            AbstractNode anotherNode = (AbstractNode)another;
            return this.fqn == null && anotherNode.fqn == null || this.fqn != null && anotherNode.fqn != null && this.fqn.equals(anotherNode.fqn);
        }
        return false;
    }

    public int hashCode() {
        return this.fqn.hashCode();
    }
}

