/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.notifications;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.transaction.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.buddyreplication.BuddyGroup;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.marshall.MarshalledValueMap;
import org.jboss.cache.notifications.IncorrectCacheListenerException;
import org.jboss.cache.notifications.annotation.BuddyGroupChanged;
import org.jboss.cache.notifications.annotation.CacheBlocked;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.CacheStarted;
import org.jboss.cache.notifications.annotation.CacheStopped;
import org.jboss.cache.notifications.annotation.CacheUnblocked;
import org.jboss.cache.notifications.annotation.NodeActivated;
import org.jboss.cache.notifications.annotation.NodeCreated;
import org.jboss.cache.notifications.annotation.NodeEvicted;
import org.jboss.cache.notifications.annotation.NodeLoaded;
import org.jboss.cache.notifications.annotation.NodeModified;
import org.jboss.cache.notifications.annotation.NodeMoved;
import org.jboss.cache.notifications.annotation.NodePassivated;
import org.jboss.cache.notifications.annotation.NodeRemoved;
import org.jboss.cache.notifications.annotation.NodeVisited;
import org.jboss.cache.notifications.annotation.TransactionCompleted;
import org.jboss.cache.notifications.annotation.TransactionRegistered;
import org.jboss.cache.notifications.annotation.ViewChanged;
import org.jboss.cache.notifications.event.BuddyGroupChangedEvent;
import org.jboss.cache.notifications.event.CacheBlockedEvent;
import org.jboss.cache.notifications.event.CacheStartedEvent;
import org.jboss.cache.notifications.event.CacheStoppedEvent;
import org.jboss.cache.notifications.event.CacheUnblockedEvent;
import org.jboss.cache.notifications.event.Event;
import org.jboss.cache.notifications.event.EventImpl;
import org.jboss.cache.notifications.event.NodeActivatedEvent;
import org.jboss.cache.notifications.event.NodeCreatedEvent;
import org.jboss.cache.notifications.event.NodeEvictedEvent;
import org.jboss.cache.notifications.event.NodeLoadedEvent;
import org.jboss.cache.notifications.event.NodeModifiedEvent;
import org.jboss.cache.notifications.event.NodeMovedEvent;
import org.jboss.cache.notifications.event.NodePassivatedEvent;
import org.jboss.cache.notifications.event.NodeRemovedEvent;
import org.jboss.cache.notifications.event.NodeVisitedEvent;
import org.jboss.cache.notifications.event.TransactionCompletedEvent;
import org.jboss.cache.notifications.event.TransactionRegisteredEvent;
import org.jboss.cache.notifications.event.ViewChangedEvent;
import org.jboss.cache.util.MapCopy;
import org.jgroups.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Notifier {
    private Cache cache;
    private static final Log log = LogFactory.getLog(Notifier.class);
    private static Class emptyMap = Collections.emptyMap().getClass();
    private static Class singletonMap = Collections.singletonMap(null, null).getClass();
    private static final Class[] allowedMethodAnnotations = new Class[]{CacheStarted.class, CacheStopped.class, CacheBlocked.class, CacheUnblocked.class, NodeCreated.class, NodeRemoved.class, NodeVisited.class, NodeModified.class, NodeMoved.class, NodeActivated.class, NodePassivated.class, NodeLoaded.class, NodeEvicted.class, TransactionRegistered.class, TransactionCompleted.class, ViewChanged.class, BuddyGroupChanged.class};
    private static final Class[] parameterTypes = new Class[]{CacheStartedEvent.class, CacheStoppedEvent.class, CacheBlockedEvent.class, CacheUnblockedEvent.class, NodeCreatedEvent.class, NodeRemovedEvent.class, NodeVisitedEvent.class, NodeModifiedEvent.class, NodeMovedEvent.class, NodeActivatedEvent.class, NodePassivatedEvent.class, NodeLoadedEvent.class, NodeEvictedEvent.class, TransactionRegisteredEvent.class, TransactionCompletedEvent.class, ViewChangedEvent.class, BuddyGroupChangedEvent.class};
    final Map<Class, List<ListenerInvocation>> listenerInvocations = new ConcurrentHashMap<Class, List<ListenerInvocation>>();

    public Notifier() {
    }

    @Inject
    private void injectDependencies(CacheSPI cache) {
        this.cache = cache;
    }

    public Notifier(Cache cache) {
        this.cache = cache;
    }

    private void validateAndAddListenerInvocation(Object listener) {
        Notifier.testListenerClassValidity(listener.getClass());
        boolean foundMethods = false;
        for (Method m : listener.getClass().getMethods()) {
            for (int i = 0; i < allowedMethodAnnotations.length; ++i) {
                if (!m.isAnnotationPresent(allowedMethodAnnotations[i])) continue;
                Notifier.testListenerMethodValidity(m, parameterTypes[i], allowedMethodAnnotations[i].getName());
                this.addListenerInvocation(allowedMethodAnnotations[i], new ListenerInvocation(listener, m));
                foundMethods = true;
            }
        }
        if (!foundMethods && log.isWarnEnabled()) {
            log.warn((Object)("Attempted to register listener of class " + listener.getClass() + ", but no valid, public methods annotated with method-level event annotations found! Ignoring listener."));
        }
    }

    private static void testListenerClassValidity(Class<?> listenerClass) {
        if (!listenerClass.isAnnotationPresent(CacheListener.class)) {
            throw new IncorrectCacheListenerException("Cache listener class MUST be annotated with org.jboss.cache.notifications.annotation.CacheListener");
        }
        if (!Modifier.isPublic(listenerClass.getModifiers())) {
            throw new IncorrectCacheListenerException("Cache listener class MUST be public!");
        }
    }

    private static void testListenerMethodValidity(Method m, Class allowedParameter, String annotationName) {
        if (m.getParameterTypes().length != 1 || !m.getParameterTypes()[0].isAssignableFrom(allowedParameter)) {
            throw new IncorrectCacheListenerException("Methods annotated with " + annotationName + " must accept exactly one parameter, of assignable from type " + allowedParameter.getName());
        }
        if (!m.getReturnType().equals(Void.TYPE)) {
            throw new IncorrectCacheListenerException("Methods annotated with " + annotationName + " should have a return type of void.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addListenerInvocation(Class annotation, ListenerInvocation li) {
        Map<Class, List<ListenerInvocation>> map = this.listenerInvocations;
        synchronized (map) {
            List<ListenerInvocation> l = this.listenerInvocations.get(annotation);
            if (l == null) {
                l = new CopyOnWriteArrayList<ListenerInvocation>();
                this.listenerInvocations.put(annotation, l);
            }
            l.add(li);
        }
    }

    public void addCacheListener(Object listener) {
        this.validateAndAddListenerInvocation(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCacheListener(Object listener) {
        Map<Class, List<ListenerInvocation>> map = this.listenerInvocations;
        synchronized (map) {
            for (Class annotation : allowedMethodAnnotations) {
                this.removeListenerInvocation(annotation, listener);
            }
        }
    }

    private void removeListenerInvocation(Class annotation, Object listener) {
        if (listener == null) {
            return;
        }
        List<ListenerInvocation> l = this.listenerInvocations.get(annotation);
        HashSet<ListenerInvocation> markedForRemoval = new HashSet<ListenerInvocation>();
        if (l != null) {
            for (ListenerInvocation li : l) {
                if (!listener.equals(li.target)) continue;
                markedForRemoval.add(li);
            }
            l.removeAll(markedForRemoval);
            if (l.isEmpty()) {
                this.listenerInvocations.remove(annotation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllCacheListeners() {
        Map<Class, List<ListenerInvocation>> map = this.listenerInvocations;
        synchronized (map) {
            this.listenerInvocations.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Object> getCacheListeners() {
        HashSet<Object> s = new HashSet<Object>();
        Map<Class, List<ListenerInvocation>> map = this.listenerInvocations;
        synchronized (map) {
            for (Class annotation : allowedMethodAnnotations) {
                List<ListenerInvocation> l = this.listenerInvocations.get(annotation);
                if (l == null) continue;
                for (ListenerInvocation li : l) {
                    s.add(li.target);
                }
            }
        }
        return Collections.unmodifiableSet(s);
    }

    public void notifyNodeCreated(Fqn fqn, boolean pre, InvocationContext ctx) {
        List<ListenerInvocation> listeners = this.listenerInvocations.get(NodeCreated.class);
        if (listeners != null && !listeners.isEmpty()) {
            boolean originLocal = ctx.isOriginLocal();
            Transaction tx = ctx.getTransaction();
            InvocationContext backup = this.resetInvocationContext(ctx);
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setOriginLocal(originLocal);
            e.setPre(pre);
            e.setFqn(fqn);
            e.setTransaction(tx);
            e.setType(Event.Type.NODE_CREATED);
            for (ListenerInvocation listener : listeners) {
                listener.invoke(e);
            }
            this.restoreInvocationContext(backup);
        }
    }

    public void notifyNodeModified(Fqn fqn, boolean pre, NodeModifiedEvent.ModificationType modificationType, Map data, InvocationContext ctx) {
        List<ListenerInvocation> listeners = this.listenerInvocations.get(NodeModified.class);
        if (listeners != null && !listeners.isEmpty()) {
            boolean originLocal = ctx.isOriginLocal();
            Map dataCopy = Notifier.copy(data);
            Transaction tx = ctx.getTransaction();
            InvocationContext backup = this.resetInvocationContext(ctx);
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setOriginLocal(originLocal);
            e.setPre(pre);
            e.setFqn(fqn);
            e.setTransaction(tx);
            e.setModificationType(modificationType);
            e.setData(dataCopy);
            e.setType(Event.Type.NODE_MODIFIED);
            for (ListenerInvocation listener : listeners) {
                listener.invoke(e);
            }
            this.restoreInvocationContext(backup);
        }
    }

    public void notifyNodeRemoved(Fqn fqn, boolean pre, Map data, InvocationContext ctx) {
        List<ListenerInvocation> listeners = this.listenerInvocations.get(NodeRemoved.class);
        if (listeners != null && !listeners.isEmpty()) {
            boolean originLocal = ctx.isOriginLocal();
            Map dataCopy = Notifier.copy(data);
            Transaction tx = ctx.getTransaction();
            InvocationContext backup = this.resetInvocationContext(ctx);
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setOriginLocal(originLocal);
            e.setPre(pre);
            e.setFqn(fqn);
            e.setTransaction(tx);
            e.setData(dataCopy);
            e.setType(Event.Type.NODE_REMOVED);
            for (ListenerInvocation listener : listeners) {
                listener.invoke(e);
            }
            this.restoreInvocationContext(backup);
        }
    }

    public void notifyNodeVisited(Fqn fqn, boolean pre, InvocationContext ctx) {
        List<ListenerInvocation> listeners = this.listenerInvocations.get(NodeVisited.class);
        if (listeners != null && !listeners.isEmpty()) {
            Transaction tx = ctx.getTransaction();
            InvocationContext backup = this.resetInvocationContext(ctx);
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setPre(pre);
            e.setFqn(fqn);
            e.setTransaction(tx);
            e.setType(Event.Type.NODE_VISITED);
            for (ListenerInvocation listener : listeners) {
                listener.invoke(e);
            }
            this.restoreInvocationContext(backup);
        }
    }

    public void notifyNodeMoved(Fqn originalFqn, Fqn newFqn, boolean pre, InvocationContext ctx) {
        List<ListenerInvocation> listeners = this.listenerInvocations.get(NodeMoved.class);
        if (listeners != null && !listeners.isEmpty()) {
            boolean originLocal = ctx.isOriginLocal();
            Transaction tx = ctx.getTransaction();
            InvocationContext backup = this.resetInvocationContext(ctx);
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setOriginLocal(originLocal);
            e.setPre(pre);
            e.setFqn(originalFqn);
            e.setTargetFqn(newFqn);
            e.setTransaction(tx);
            e.setType(Event.Type.NODE_MOVED);
            for (ListenerInvocation listener : listeners) {
                listener.invoke(e);
            }
            this.restoreInvocationContext(backup);
        }
    }

    public void notifyNodeEvicted(Fqn fqn, boolean pre, InvocationContext ctx) {
        List<ListenerInvocation> listeners = this.listenerInvocations.get(NodeEvicted.class);
        if (listeners != null && !listeners.isEmpty()) {
            boolean originLocal = ctx.isOriginLocal();
            Transaction tx = ctx.getTransaction();
            InvocationContext backup = this.resetInvocationContext(ctx);
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setOriginLocal(originLocal);
            e.setPre(pre);
            e.setFqn(fqn);
            e.setTransaction(tx);
            e.setType(Event.Type.NODE_EVICTED);
            for (ListenerInvocation listener : listeners) {
                listener.invoke(e);
            }
            this.restoreInvocationContext(backup);
        }
    }

    public void notifyNodeLoaded(Fqn fqn, boolean pre, Map data, InvocationContext ctx) {
        List<ListenerInvocation> listeners = this.listenerInvocations.get(NodeLoaded.class);
        if (listeners != null && !listeners.isEmpty()) {
            boolean originLocal = ctx.isOriginLocal();
            Map dataCopy = Notifier.copy(data);
            Transaction tx = ctx.getTransaction();
            InvocationContext backup = this.resetInvocationContext(ctx);
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setOriginLocal(originLocal);
            e.setPre(pre);
            e.setFqn(fqn);
            e.setTransaction(tx);
            e.setData(dataCopy);
            e.setType(Event.Type.NODE_LOADED);
            for (ListenerInvocation listener : listeners) {
                listener.invoke(e);
            }
            this.restoreInvocationContext(backup);
        }
    }

    public void notifyNodeActivated(Fqn fqn, boolean pre, Map data, InvocationContext ctx) {
        List<ListenerInvocation> listeners = this.listenerInvocations.get(NodeActivated.class);
        if (listeners != null && !listeners.isEmpty()) {
            boolean originLocal = ctx.isOriginLocal();
            Map dataCopy = Notifier.copy(data);
            Transaction tx = ctx.getTransaction();
            InvocationContext backup = this.resetInvocationContext(ctx);
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setOriginLocal(originLocal);
            e.setPre(pre);
            e.setFqn(fqn);
            e.setTransaction(tx);
            e.setData(dataCopy);
            e.setType(Event.Type.NODE_ACTIVATED);
            for (ListenerInvocation listener : listeners) {
                listener.invoke(e);
            }
            this.restoreInvocationContext(backup);
        }
    }

    public void notifyNodePassivated(Fqn fqn, boolean pre, Map data, InvocationContext ctx) {
        List<ListenerInvocation> listeners = this.listenerInvocations.get(NodePassivated.class);
        if (listeners != null && !listeners.isEmpty()) {
            Map dataCopy = Notifier.copy(data);
            Transaction tx = ctx.getTransaction();
            InvocationContext backup = this.resetInvocationContext(ctx);
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setPre(pre);
            e.setFqn(fqn);
            e.setTransaction(tx);
            e.setData(dataCopy);
            e.setType(Event.Type.NODE_PASSIVATED);
            for (ListenerInvocation listener : listeners) {
                listener.invoke(e);
            }
            this.restoreInvocationContext(backup);
        }
    }

    public void notifyCacheStarted(CacheSPI cache, InvocationContext ctx) {
        List<ListenerInvocation> listeners = this.listenerInvocations.get(CacheStarted.class);
        if (listeners != null && !listeners.isEmpty()) {
            InvocationContext backup = this.resetInvocationContext(ctx);
            EventImpl e = new EventImpl();
            e.setCache(cache);
            e.setType(Event.Type.CACHE_STARTED);
            for (ListenerInvocation listener : listeners) {
                listener.invoke(e);
            }
            this.restoreInvocationContext(backup);
        }
    }

    public void notifyCacheStopped(CacheSPI cache, InvocationContext ctx) {
        List<ListenerInvocation> listeners = this.listenerInvocations.get(CacheStopped.class);
        if (listeners != null && !listeners.isEmpty()) {
            InvocationContext backup = this.resetInvocationContext(ctx);
            EventImpl e = new EventImpl();
            e.setCache(cache);
            e.setType(Event.Type.CACHE_STOPPED);
            for (ListenerInvocation listener : listeners) {
                listener.invoke(e);
            }
            this.restoreInvocationContext(backup);
        }
    }

    public void notifyViewChange(View new_view, InvocationContext ctx) {
        List<ListenerInvocation> listeners = this.listenerInvocations.get(ViewChanged.class);
        if (listeners != null && !listeners.isEmpty()) {
            InvocationContext backup = this.resetInvocationContext(ctx);
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setNewView(new_view);
            e.setType(Event.Type.VIEW_CHANGED);
            for (ListenerInvocation listener : listeners) {
                listener.invoke(e);
            }
            this.restoreInvocationContext(backup);
        }
    }

    public void notifyBuddyGroupChange(BuddyGroup buddyGroup, boolean pre) {
        List<ListenerInvocation> listeners = this.listenerInvocations.get(BuddyGroupChanged.class);
        if (listeners != null && !listeners.isEmpty()) {
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setBuddyGroup(buddyGroup);
            e.setPre(pre);
            e.setType(Event.Type.BUDDY_GROUP_CHANGED);
            for (ListenerInvocation listener : listeners) {
                listener.invoke(e);
            }
        }
    }

    public void notifyTransactionCompleted(Transaction transaction, boolean successful, InvocationContext ctx) {
        List<ListenerInvocation> listeners = this.listenerInvocations.get(TransactionCompleted.class);
        if (listeners != null && !listeners.isEmpty()) {
            Transaction tx = ctx.getTransaction();
            boolean isOriginLocal = ctx.isOriginLocal();
            InvocationContext backup = this.resetInvocationContext(ctx);
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setOriginLocal(isOriginLocal);
            e.setTransaction(tx);
            e.setSuccessful(successful);
            e.setType(Event.Type.TRANSACTION_COMPLETED);
            for (ListenerInvocation listener : listeners) {
                listener.invoke(e);
            }
            this.restoreInvocationContext(backup);
        }
    }

    public void notifyTransactionRegistered(Transaction transaction, InvocationContext ctx) {
        List<ListenerInvocation> listeners = this.listenerInvocations.get(TransactionRegistered.class);
        if (listeners != null && !listeners.isEmpty()) {
            Transaction tx = ctx.getTransaction();
            boolean isOriginLocal = ctx.isOriginLocal();
            InvocationContext backup = this.resetInvocationContext(ctx);
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setOriginLocal(isOriginLocal);
            e.setTransaction(tx);
            e.setType(Event.Type.TRANSACTION_REGISTERED);
            for (ListenerInvocation listener : listeners) {
                listener.invoke(e);
            }
            this.restoreInvocationContext(backup);
        }
    }

    public void notifyCacheBlocked(CacheSPI cache, boolean pre) {
        List<ListenerInvocation> listeners = this.listenerInvocations.get(CacheBlocked.class);
        if (listeners != null && !listeners.isEmpty()) {
            EventImpl e = new EventImpl();
            e.setCache(cache);
            e.setPre(pre);
            e.setType(Event.Type.CACHE_BLOCKED);
            for (ListenerInvocation listener : listeners) {
                listener.invoke(e);
            }
        }
    }

    public void notifyCacheUnblocked(CacheSPI cache, boolean pre) {
        List<ListenerInvocation> listeners = this.listenerInvocations.get(CacheUnblocked.class);
        if (listeners != null && !listeners.isEmpty()) {
            EventImpl e = new EventImpl();
            e.setCache(cache);
            e.setPre(pre);
            e.setType(Event.Type.CACHE_UNBLOCKED);
            for (ListenerInvocation listener : listeners) {
                listener.invoke(e);
            }
        }
    }

    private static Map copy(Map data) {
        if (data == null) {
            return null;
        }
        if (data.isEmpty()) {
            return Collections.emptyMap();
        }
        if (Notifier.safe(data)) {
            return new MarshalledValueMap(data);
        }
        return new MarshalledValueMap(new MapCopy(data));
    }

    private void restoreInvocationContext(InvocationContext backup) {
        this.cache.setInvocationContext(backup);
    }

    private InvocationContext resetInvocationContext(InvocationContext ctx) {
        this.cache.setInvocationContext(null);
        return ctx;
    }

    private static boolean safe(Map map) {
        return map == null || map instanceof MapCopy || map.getClass().equals(emptyMap) || map.getClass().equals(singletonMap);
    }

    class ListenerInvocation {
        private Object target;
        private Method method;

        public ListenerInvocation(Object target, Method method) {
            this.target = target;
            this.method = method;
        }

        public void invoke(Event e) {
            try {
                this.method.invoke(this.target, e);
            }
            catch (InvocationTargetException e1) {
                Throwable cause = e1.getCause();
                if (cause != null) {
                    throw new CacheException("Caught exception invoking method " + this.method + " on listener instance " + this.target, cause);
                }
                throw new CacheException("Caught exception invoking method " + this.method + " on listener instance " + this.target, e1);
            }
            catch (IllegalAccessException e1) {
                log.warn((Object)("Unable to invoke method " + this.method + " on Object instance " + this.target + " - removing this target object from list of listeners!"), (Throwable)e1);
                Notifier.this.removeCacheListener(this.target);
            }
        }
    }
}

