/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.cache.pojo;

import static org.testng.AssertJUnit.assertEquals;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.config.Configuration.CacheMode;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.pojo.test.Resource;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * Replicate POJO with byte array field.
 *
 * @author Ben Wang
 */
@Test(groups = {"functional"})
public class ReplicatedByteTest 
{
   Log log = LogFactory.getLog(ReplicatedByteTest.class);
   PojoCache cache, cache1;



   @BeforeMethod(alwaysRun = true)
   protected void setUp() throws Exception
   {
      log.info("setUp() ....");
      boolean toStart = false;
      cache = PojoCacheFactory.createCache(UnitTestCacheConfigurationFactory.createConfiguration(CacheMode.REPL_SYNC), toStart);
      cache.start();
      cache1 = PojoCacheFactory.createCache(UnitTestCacheConfigurationFactory.createConfiguration(CacheMode.REPL_SYNC), toStart);
      cache1.start();
   }

   @AfterMethod(alwaysRun = true)
   protected void tearDown() throws Exception
   {
      cache.stop();
      cache1.stop();
   }

   public void testSimple() throws Exception
   {
      log.info("testSimple() ....");
      Resource res = new Resource();
      res.setName("mapping");
      res.setConnection("wire");
      byte by = 1;
      byte[] b = new byte[1];
      b[0] = by;
      res.setByte(b);

      cache.attach("resource", res);

      Resource res1 = (Resource) cache1.find("resource");
      assertEquals("Name ", res.getName(), res1.getName());

      assertEquals("byte ", res.getByte()[0], res1.getByte()[0]);

      // field modification
      by = 2;
      b[0] = by;
      res1.setByte(b);
      assertEquals("Name ", res.getName(), res1.getName());
      assertEquals("byte ", res.getByte()[0], res1.getByte()[0]);
   }
}
