package org.jboss.cache.pojo.demo;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.demo.CacheModelDelegate;
import org.jboss.cache.demo.JBossCacheGUI;
import org.jboss.cache.demo.JBossCacheView;
import org.jboss.cache.pojo.PojoCache;
import org.jboss.cache.pojo.PojoCacheFactory;

/**
 * PojoCac
 *
 * @author <a href="mailto:galder.zamarreno@jboss.com">Galder Zamarreno</a>
 */
public class PojoCacheView extends JBossCacheView
{
   private static Log log = LogFactory.getLog(PojoCacheView.class.getName());

   @Override
   protected JBossCacheGUI createCacheGUI(CacheModelDelegate cacheDelegate, boolean useConsole) throws Exception
   {
      return new PojoCacheGUI(cacheDelegate, useConsole);
   }

   @Override
   protected CacheModelDelegate createCacheDelegate() throws Exception
   {
      PojoCache pojoCache = PojoCacheFactory.createCache(getConfigurationFile(), false);
      pojoCache.getCache().getConfiguration().setFetchInMemoryState(false);

      CacheModelDelegate delegate = new PojoCacheModelDelegate();
      delegate.setCacheShellVariable(pojoCache);

      return delegate;
   }

   public static void main(String args[])
   {
      try
      {
         JBossCacheView view = new PojoCacheView();
         view.doMain(args);
      }
      catch (Exception ex)
      {
         log.error("Cannot start up!!", ex);
         System.exit(-1);
      }
   }
}
