/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.api;

import java.util.Map;
import java.util.Set;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class NodeSPITest {
    private CacheSPI<Object, Object> cache;
    private NodeSPI<Object, Object> root;

    @BeforeMethod(alwaysRun=true)
    public void setUp() {
        this.cache = (CacheSPI)new DefaultCacheFactory().createCache();
        this.root = this.cache.getRoot();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        if (this.cache != null) {
            this.cache.stop();
        }
        this.root = null;
        this.cache = null;
    }

    public void testDeepOperations() throws Exception {
        Fqn A = Fqn.fromString((String)"/a");
        Fqn B = Fqn.fromString((String)"/b");
        Fqn A_B = Fqn.fromString((String)"/a/b");
        this.cache.put(A, (Object)"k", (Object)"v");
        this.cache.put(A_B, (Object)"k", (Object)"v");
        NodeSPI nodeA = this.cache.getRoot().getChildDirect(A);
        NodeSPI nodeB = this.cache.getRoot().getChildDirect(A_B);
        AssertJUnit.assertEquals((Object)A_B, (Object)nodeB.getFqn());
        nodeB = nodeA.getChildDirect(B);
        AssertJUnit.assertEquals((Object)A_B, (Object)nodeB.getFqn());
        AssertJUnit.assertEquals((boolean)true, (boolean)this.cache.getRoot().removeChildDirect(A_B));
        AssertJUnit.assertEquals((boolean)false, (boolean)this.cache.getRoot().removeChildDirect(A_B));
        this.cache.put(A_B, (Object)"k", (Object)"v");
        AssertJUnit.assertEquals((boolean)true, (boolean)nodeA.removeChildDirect(B));
        AssertJUnit.assertEquals((boolean)false, (boolean)nodeA.removeChildDirect(B));
        AssertJUnit.assertEquals((boolean)true, (boolean)this.cache.getRoot().removeChildDirect(A.getLastElement()));
        AssertJUnit.assertEquals((boolean)false, (boolean)this.cache.getRoot().removeChildDirect(A.getLastElement()));
        try {
            this.cache.getRoot().addChildDirect(A_B);
            AssertJUnit.fail((String)"Should have failed");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        nodeA = this.cache.getRoot().addChildDirect(A);
        nodeA.addChildDirect(B);
    }

    public void testDataImmutabilityAndDefensiveCopy() {
        this.root.put((Object)"k", (Object)"v");
        Map dataDirect = this.root.getDataDirect();
        Set keysDirect = this.root.getKeysDirect();
        try {
            dataDirect.remove("k");
            AssertJUnit.fail((String)"getDataDirect() should return an unmodifiable collection object");
        }
        catch (UnsupportedOperationException uoe) {
            // empty catch block
        }
        try {
            keysDirect.clear();
            AssertJUnit.fail((String)"getKeysDirect() should return an unmodifiable collection object");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.root.put((Object)"k2", (Object)"v2");
        AssertJUnit.assertTrue((String)"root.put() should have succeeded", (boolean)this.root.getDataDirect().containsKey("k2"));
        AssertJUnit.assertTrue((String)"getKeysDirect() should have made a defensive copy of the data collection object", (!keysDirect.contains("k2") ? 1 : 0) != 0);
    }

    public void testChildrenImmutabilityAndDefensiveCopy() {
        String childName = "childName";
        String newChild = "newChild";
        this.root.addChild(new Fqn((Object[])new String[]{childName}));
        Set childrenDirect = this.root.getChildrenDirect();
        try {
            childrenDirect.clear();
            AssertJUnit.fail((String)"getChildrenDirect() should return an unmodifiable collection object");
        }
        catch (UnsupportedOperationException uoe) {
            // empty catch block
        }
        this.root.addChild(new Fqn((Object[])new String[]{newChild}));
        AssertJUnit.assertTrue((String)"root.addChild() should have succeeded", (boolean)this.root.getChildrenNamesDirect().contains(newChild));
        AssertJUnit.assertTrue((String)"getChildrenDirect() should have made a defensive copy of the data collection object", (!childrenDirect.contains(newChild) ? 1 : 0) != 0);
    }

    public void testNullCollections() {
        AssertJUnit.assertNotNull((String)"Should not be null", (Object)this.root.getDataDirect());
        AssertJUnit.assertTrue((String)"Should be empty", (boolean)this.root.getDataDirect().isEmpty());
        AssertJUnit.assertNotNull((String)"Should not be null", (Object)this.root.getKeysDirect());
        AssertJUnit.assertTrue((String)"Should be empty", (boolean)this.root.getKeysDirect().isEmpty());
        AssertJUnit.assertNotNull((String)"Should not be null", (Object)this.root.getChildrenDirect());
        AssertJUnit.assertTrue((String)"Should be empty", (boolean)this.root.getChildrenDirect().isEmpty());
        AssertJUnit.assertNotNull((String)"Should not be null", (Object)this.root.getChildrenNamesDirect());
        AssertJUnit.assertTrue((String)"Should be empty", (boolean)this.root.getChildrenNamesDirect().isEmpty());
    }
}

