/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.lock;

import java.util.Collections;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.lock.TimeoutException;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class WriteLockOnParentTest {
    private CacheSPI<Object, Object> cache;
    private TransactionManager tm;
    private Fqn<String> a = Fqn.fromString((String)"/a");
    private Fqn<String> a_b = Fqn.fromString((String)"/a/b");
    private Fqn<String> a_c = Fqn.fromString((String)"/a/c");

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.cache = (CacheSPI)new DefaultCacheFactory().createCache(false);
        this.cache.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        this.cache.getConfiguration().setLockAcquisitionTimeout(500L);
        this.cache.start();
        this.tm = this.cache.getTransactionManager();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this.tm.getTransaction() != null) {
            try {
                this.tm.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.cache.stop();
    }

    public void testDefaultCfg() {
        AssertJUnit.assertFalse((String)"Locking of parent nodes for child inserts and removes should be false by default", (boolean)this.cache.getConfiguration().isLockParentForChildInsertRemove());
    }

    public void testDefaultChildInsert() throws Exception {
        this.cache.put(this.a, Collections.emptyMap());
        AssertJUnit.assertNotNull((String)"/a should exist", (Object)this.cache.peek(this.a, false));
        this.tm.begin();
        this.cache.put(this.a_b, Collections.emptyMap());
        Transaction t1 = this.tm.suspend();
        this.tm.begin();
        this.cache.put(this.a_c, Collections.emptyMap());
        this.tm.commit();
        this.tm.resume(t1);
        this.tm.commit();
        AssertJUnit.assertNotNull((String)"/a/b should exist", (Object)this.cache.peek(this.a_b, false));
        AssertJUnit.assertNotNull((String)"/a/c should exist", (Object)this.cache.peek(this.a_c, false));
    }

    public void testLockParentChildInsert() throws Exception {
        this.cache.getConfiguration().setLockParentForChildInsertRemove(true);
        this.cache.put(this.a, Collections.emptyMap());
        AssertJUnit.assertNotNull((String)"/a should exist", (Object)this.cache.peek(this.a, false));
        this.tm.begin();
        this.cache.put(this.a_b, Collections.emptyMap());
        Transaction t1 = this.tm.suspend();
        this.tm.begin();
        try {
            this.cache.put(this.a_c, Collections.emptyMap());
            AssertJUnit.fail((String)"Should not get here.");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        this.tm.commit();
        this.tm.resume(t1);
        this.tm.commit();
        AssertJUnit.assertNotNull((String)"/a/b should exist", (Object)this.cache.peek(this.a_b, false));
        AssertJUnit.assertNull((String)"/a/c should not exist", (Object)this.cache.peek(this.a_c, false));
    }

    public void testDefaultChildRemove() throws Exception {
        this.cache.put(this.a, Collections.emptyMap());
        this.cache.put(this.a_b, Collections.emptyMap());
        this.cache.put(this.a_c, Collections.emptyMap());
        AssertJUnit.assertNotNull((String)"/a should exist", (Object)this.cache.peek(this.a, false));
        AssertJUnit.assertNotNull((String)"/a/b should exist", (Object)this.cache.peek(this.a_b, false));
        AssertJUnit.assertNotNull((String)"/a/c should exist", (Object)this.cache.peek(this.a_c, false));
        this.tm.begin();
        this.cache.removeNode(this.a_b);
        Transaction t1 = this.tm.suspend();
        this.tm.begin();
        this.cache.removeNode(this.a_c);
        this.tm.commit();
        this.tm.resume(t1);
        this.tm.commit();
        AssertJUnit.assertNotNull((String)"/a should exist", (Object)this.cache.peek(this.a, false));
        AssertJUnit.assertNull((String)"/a/b should not exist", (Object)this.cache.peek(this.a_b, false));
        AssertJUnit.assertNull((String)"/a/c should not exist", (Object)this.cache.peek(this.a_c, false));
    }

    public void testLockParentChildRemove() throws Exception {
        this.cache.getConfiguration().setLockParentForChildInsertRemove(true);
        this.cache.put(this.a, Collections.emptyMap());
        this.cache.put(this.a_b, Collections.emptyMap());
        this.cache.put(this.a_c, Collections.emptyMap());
        AssertJUnit.assertNotNull((String)"/a should exist", (Object)this.cache.peek(this.a, false));
        AssertJUnit.assertNotNull((String)"/a/b should exist", (Object)this.cache.peek(this.a_b, false));
        AssertJUnit.assertNotNull((String)"/a/c should exist", (Object)this.cache.peek(this.a_c, false));
        this.tm.begin();
        this.cache.removeNode(this.a_b);
        Transaction t1 = this.tm.suspend();
        this.tm.begin();
        try {
            this.cache.removeNode(this.a_c);
            AssertJUnit.fail((String)"Should not get here.");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        this.tm.commit();
        this.tm.resume(t1);
        this.tm.commit();
        AssertJUnit.assertNotNull((String)"/a should exist", (Object)this.cache.peek(this.a, false));
        AssertJUnit.assertNull((String)"/a/b should not exist", (Object)this.cache.peek(this.a_b, false));
        AssertJUnit.assertNotNull((String)"/a/c should exist", (Object)this.cache.peek(this.a_c, false));
    }

    public void testPerNodeConfigurationDefaultLock() throws Exception {
        this.testPerNodeConfiguration(true);
    }

    public void testPerNodeConfigurationDefaultNoLock() throws Exception {
        this.testPerNodeConfiguration(false);
    }

    private void testPerNodeConfiguration(boolean defaultLock) throws Exception {
        this.cache.getConfiguration().setLockParentForChildInsertRemove(defaultLock);
        this.cache.put(this.a, Collections.emptyMap());
        if (!defaultLock) {
            this.cache.getRoot().getChild(this.a).setLockForChildInsertRemove(true);
        }
        this.cache.put(this.a_b, Collections.emptyMap());
        this.cache.put(this.a_c, Collections.emptyMap());
        AssertJUnit.assertNotNull((String)"/a should exist", (Object)this.cache.peek(this.a, false));
        AssertJUnit.assertNotNull((String)"/a/b should exist", (Object)this.cache.peek(this.a_b, false));
        AssertJUnit.assertNotNull((String)"/a/c should exist", (Object)this.cache.peek(this.a_c, false));
        this.tm.begin();
        this.cache.removeNode(this.a_b);
        Transaction t1 = this.tm.suspend();
        this.tm.begin();
        try {
            this.cache.removeNode(this.a_c);
            AssertJUnit.fail((String)"Should not get here.");
        }
        catch (TimeoutException e) {
            // empty catch block
        }
        this.tm.commit();
        this.tm.resume(t1);
        this.tm.commit();
        AssertJUnit.assertNotNull((String)"/a should exist", (Object)this.cache.peek(this.a, false));
        AssertJUnit.assertNull((String)"/a/b should not exist", (Object)this.cache.peek(this.a_b, false));
        AssertJUnit.assertNotNull((String)"/a/c should exist", (Object)this.cache.peek(this.a_c, false));
        Fqn b = Fqn.fromString((String)"/b");
        Fqn b_b = Fqn.fromString((String)"/b/b");
        Fqn b_c = Fqn.fromString((String)"/b/c");
        this.cache.put(b, Collections.emptyMap());
        if (defaultLock) {
            this.cache.getRoot().getChild(b).setLockForChildInsertRemove(false);
        }
        this.cache.put(b_b, Collections.emptyMap());
        this.cache.put(b_c, Collections.emptyMap());
        AssertJUnit.assertNotNull((String)"/a should exist", (Object)this.cache.peek(b, false));
        AssertJUnit.assertNotNull((String)"/a/b should exist", (Object)this.cache.peek(b_b, false));
        AssertJUnit.assertNotNull((String)"/a/c should exist", (Object)this.cache.peek(b_c, false));
        this.tm.begin();
        this.cache.removeNode(b_b);
        t1 = this.tm.suspend();
        this.tm.begin();
        this.cache.removeNode(b_c);
        this.tm.commit();
        this.tm.resume(t1);
        this.tm.commit();
        AssertJUnit.assertNotNull((String)"/b should exist", (Object)this.cache.peek(b, false));
        AssertJUnit.assertNull((String)"/b/b should not exist", (Object)this.cache.peek(b_b, false));
        AssertJUnit.assertNull((String)"/b/c should not exist", (Object)this.cache.peek(b_c, false));
    }
}

