/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import java.lang.reflect.Method;
import java.util.List;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.loader.SamplePojo;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.misc.TestingUtil;
import org.jboss.cache.optimistic.AbstractOptimisticTestCase;
import org.jboss.cache.optimistic.MockInterceptor;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.OptimisticTransactionEntry;
import org.jboss.cache.transaction.TransactionSetup;
import org.jboss.cache.transaction.TransactionTable;
import org.jgroups.Address;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional", "transaction"})
public class TxInterceptorTest
extends AbstractOptimisticTestCase {
    @Override
    protected CacheSPI<Object, Object> createCacheUnstarted(boolean optimistic) throws Exception {
        CacheSPI<Object, Object> cache = super.createCacheUnstarted(optimistic);
        cache.getConfiguration().setTransactionManagerLookupClass(TransactionSetup.getManagerLookup());
        return cache;
    }

    public void testNoTransaction() throws Exception {
        CacheSPI<Object, Object> cache = this.createCache();
        MockInterceptor dummy = new MockInterceptor();
        this.setAlteredInterceptorChain(dummy, cache);
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        SamplePojo pojo = new SamplePojo(21, "test");
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        List<Integer> calls = dummy.getAllCalledIds();
        AssertJUnit.assertEquals((Object)18, (Object)calls.get(0));
        AssertJUnit.assertEquals((Object)11, (Object)calls.get(1));
    }

    public void testLocalTransactionExists() throws Exception {
        CacheSPI<Object, Object> cache = this.createCache();
        MockInterceptor dummy = new MockInterceptor();
        this.setAlteredInterceptorChain(dummy, cache);
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        SamplePojo pojo = new SamplePojo(21, "test");
        AssertJUnit.assertNotNull((Object)mgr.getTransaction());
        TransactionTable txTable = cache.getTransactionTable();
        AssertJUnit.assertNull((Object)txTable.get(tx));
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        AssertJUnit.assertNotNull((Object)mgr.getTransaction());
        mgr.commit();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        List<Integer> calls = dummy.getAllCalledIds();
        AssertJUnit.assertEquals((Object)18, (Object)calls.get(0));
        AssertJUnit.assertEquals((Object)11, (Object)calls.get(1));
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        cache.stop();
    }

    public void testRollbackTransaction() throws Exception {
        CacheSPI<Object, Object> cache = this.createCache();
        MockInterceptor dummy = new MockInterceptor();
        this.setAlteredInterceptorChain(dummy, cache);
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        mgr.begin();
        SamplePojo pojo = new SamplePojo(21, "test");
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        AssertJUnit.assertNotNull((Object)mgr.getTransaction());
        mgr.rollback();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        List<Integer> calls = dummy.getAllCalledIds();
        AssertJUnit.assertEquals((int)1, (int)calls.size());
        AssertJUnit.assertEquals((Object)12, (Object)calls.get(0));
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        cache.stop();
    }

    public void testEmptyLocalTransaction() throws Exception {
        CacheSPI<Object, Object> cache = this.createCache();
        MockInterceptor dummy = new MockInterceptor();
        this.setAlteredInterceptorChain(dummy, cache);
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        mgr.begin();
        AssertJUnit.assertNotNull((Object)mgr.getTransaction());
        mgr.commit();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        List<Method> calls = dummy.getAllCalled();
        AssertJUnit.assertEquals((int)0, (int)calls.size());
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        cache.stop();
    }

    public void testEmptyRollbackLocalTransaction() throws Exception {
        CacheSPI<Object, Object> cache = this.createCache();
        MockInterceptor dummy = new MockInterceptor();
        this.setAlteredInterceptorChain(dummy, cache);
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        mgr.begin();
        AssertJUnit.assertNotNull((Object)mgr.getTransaction());
        mgr.rollback();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        List<Method> calls = dummy.getAllCalled();
        AssertJUnit.assertEquals((int)0, (int)calls.size());
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        cache.stop();
    }

    public void testLocalRollbackAftercommitTransaction() throws Exception {
        CacheSPI<Object, Object> cache = this.createCache();
        MockInterceptor dummy = new MockInterceptor();
        this.setAlteredInterceptorChain(dummy, cache);
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        mgr.begin();
        SamplePojo pojo = new SamplePojo(21, "test");
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        AssertJUnit.assertNotNull((Object)mgr.getTransaction());
        mgr.commit();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        List<Integer> calls = dummy.getAllCalledIds();
        AssertJUnit.assertEquals((Object)18, (Object)calls.get(0));
        AssertJUnit.assertEquals((Object)11, (Object)calls.get(1));
        boolean failed = false;
        try {
            mgr.rollback();
            AssertJUnit.fail();
        }
        catch (Exception e) {
            e.printStackTrace();
            failed = true;
            AssertJUnit.assertTrue((boolean)true);
        }
        AssertJUnit.assertTrue((boolean)failed);
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        cache.stop();
    }

    public void testgtxTransactionExists() throws Exception {
        CacheSPI<Object, Object> cache = this.createCache();
        MockInterceptor dummy = new MockInterceptor();
        this.setAlteredInterceptorChain(dummy, cache);
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        cache.getCurrentTransaction(tx, true);
        SamplePojo pojo = new SamplePojo(21, "test");
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        AssertJUnit.assertNotNull((Object)mgr.getTransaction());
        mgr.commit();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        List<Integer> calls = dummy.getAllCalledIds();
        AssertJUnit.assertEquals((Object)18, (Object)calls.get(0));
        AssertJUnit.assertEquals((Object)11, (Object)calls.get(1));
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        cache.stop();
    }

    public void testRemotePrepareTransaction() throws Exception {
        CacheSPI<Object, Object> cache = this.createCache();
        MockInterceptor dummy = new MockInterceptor();
        this.setAlteredInterceptorChain(dummy, cache);
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        SamplePojo pojo = new SamplePojo(21, "test");
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        GlobalTransaction gtx = cache.getCurrentTransaction(tx, true);
        TransactionTable table = cache.getTransactionTable();
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        AssertJUnit.assertNotNull((Object)mgr.getTransaction());
        mgr.commit();
        List<Integer> calls = dummy.getAllCalledIds();
        AssertJUnit.assertEquals((Object)18, (Object)calls.get(0));
        AssertJUnit.assertEquals((Object)11, (Object)calls.get(1));
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        GlobalTransaction remoteGtx = new GlobalTransaction();
        remoteGtx.setAddress((Address)new AbstractOptimisticTestCase.DummyAddress());
        MethodCall meth = (MethodCall)entry.getModifications().get(0);
        meth.getArgs()[0] = remoteGtx;
        MethodCall prepareMethod = MethodCallFactory.create((int)18, (Object[])new Object[]{remoteGtx, this.injectDataVersion(entry.getModifications()), null, remoteGtx.getAddress(), Boolean.FALSE});
        try {
            TestingUtil.getRemoteDelegate(cache)._replicate(prepareMethod);
        }
        catch (Throwable t) {
            AssertJUnit.fail();
        }
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertNotNull((Object)table.get(remoteGtx));
        AssertJUnit.assertNotNull((Object)table.getLocalTransaction(remoteGtx));
        calls = dummy.getAllCalledIds();
        AssertJUnit.assertEquals((Object)18, (Object)calls.get(2));
        AssertJUnit.assertEquals((int)1, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)1, (int)cache.getTransactionTable().getNumLocalTransactions());
        cache.stop();
    }

    public void testRemotePrepareSuspendTransaction() throws Exception {
        CacheSPI<Object, Object> cache = this.createCache();
        MockInterceptor dummy = new MockInterceptor();
        this.setAlteredInterceptorChain(dummy, cache);
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        SamplePojo pojo = new SamplePojo(21, "test");
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        GlobalTransaction gtx = cache.getCurrentTransaction(tx, true);
        TransactionTable table = cache.getTransactionTable();
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        AssertJUnit.assertEquals((Object)tx, (Object)mgr.getTransaction());
        GlobalTransaction remoteGtx = new GlobalTransaction();
        remoteGtx.setAddress((Address)new AbstractOptimisticTestCase.DummyAddress());
        MethodCall meth = (MethodCall)entry.getModifications().get(0);
        meth.getArgs()[0] = remoteGtx;
        MethodCall prepareMethod = MethodCallFactory.create((int)18, (Object[])new Object[]{remoteGtx, this.injectDataVersion(entry.getModifications()), null, remoteGtx.getAddress(), Boolean.FALSE});
        try {
            TestingUtil.getRemoteDelegate(cache)._replicate(prepareMethod);
        }
        catch (Throwable t) {
            t.printStackTrace();
            AssertJUnit.fail();
        }
        AssertJUnit.assertEquals((Object)tx, (Object)mgr.getTransaction());
        AssertJUnit.assertNotNull((Object)table.get(remoteGtx));
        AssertJUnit.assertNotNull((Object)table.getLocalTransaction(remoteGtx));
        List<Integer> calls = dummy.getAllCalledIds();
        AssertJUnit.assertEquals((Object)18, (Object)calls.get(0));
        AssertJUnit.assertEquals((int)2, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)2, (int)cache.getTransactionTable().getNumLocalTransactions());
        mgr.commit();
        calls = dummy.getAllCalledIds();
        AssertJUnit.assertEquals((Object)18, (Object)calls.get(1));
        AssertJUnit.assertEquals((Object)11, (Object)calls.get(2));
        AssertJUnit.assertEquals((int)1, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)1, (int)cache.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertNotNull((Object)table.get(remoteGtx));
        AssertJUnit.assertNotNull((Object)table.getLocalTransaction(remoteGtx));
        AssertJUnit.assertNull((Object)table.get(gtx));
        AssertJUnit.assertNull((Object)table.getLocalTransaction(gtx));
        AssertJUnit.assertEquals(null, (Object)mgr.getTransaction());
        cache.stop();
    }

    public void testRemoteCommitSuspendTransaction() throws Exception {
        CacheSPI<Object, Object> cache = this.createCache();
        MockInterceptor dummy = new MockInterceptor();
        this.setAlteredInterceptorChain(dummy, cache);
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        cache.getCurrentTransaction(tx, true);
        SamplePojo pojo = new SamplePojo(21, "test");
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        GlobalTransaction gtx = cache.getCurrentTransaction(tx, true);
        TransactionTable table = cache.getTransactionTable();
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        AssertJUnit.assertEquals((Object)tx, (Object)mgr.getTransaction());
        GlobalTransaction remoteGtx = new GlobalTransaction();
        remoteGtx.setAddress((Address)new AbstractOptimisticTestCase.DummyAddress());
        MethodCall meth = (MethodCall)entry.getModifications().get(0);
        meth.getArgs()[0] = remoteGtx;
        MethodCall prepareMethod = MethodCallFactory.create((int)18, (Object[])new Object[]{remoteGtx, this.injectDataVersion(entry.getModifications()), null, remoteGtx.getAddress(), Boolean.FALSE});
        try {
            TestingUtil.getRemoteDelegate(cache)._replicate(prepareMethod);
        }
        catch (Throwable t) {
            AssertJUnit.fail();
        }
        AssertJUnit.assertEquals((int)2, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)2, (int)cache.getTransactionTable().getNumLocalTransactions());
        MethodCall commitMethod = MethodCallFactory.create((int)11, (Object[])new Object[]{remoteGtx});
        try {
            TestingUtil.getRemoteDelegate(cache)._replicate(commitMethod);
        }
        catch (Throwable t) {
            t.printStackTrace();
            AssertJUnit.fail();
        }
        AssertJUnit.assertEquals((Object)tx, (Object)mgr.getTransaction());
        AssertJUnit.assertNull((Object)table.get(remoteGtx));
        AssertJUnit.assertNull((Object)table.getLocalTransaction(remoteGtx));
        List<Integer> calls = dummy.getAllCalledIds();
        AssertJUnit.assertEquals((Object)18, (Object)calls.get(0));
        AssertJUnit.assertEquals((Object)11, (Object)calls.get(1));
        AssertJUnit.assertEquals((int)1, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)1, (int)cache.getTransactionTable().getNumLocalTransactions());
        mgr.commit();
        calls = dummy.getAllCalledIds();
        AssertJUnit.assertEquals((Object)18, (Object)calls.get(2));
        AssertJUnit.assertEquals((Object)11, (Object)calls.get(3));
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertEquals(null, (Object)mgr.getTransaction());
        cache.stop();
    }

    public void testRemoteRollbackSuspendTransaction() throws Exception {
        CacheSPI<Object, Object> cache = this.createCache();
        MockInterceptor dummy = new MockInterceptor();
        this.setAlteredInterceptorChain(dummy, cache);
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        cache.getCurrentTransaction(tx, true);
        SamplePojo pojo = new SamplePojo(21, "test");
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        GlobalTransaction gtx = cache.getCurrentTransaction(tx, true);
        TransactionTable table = cache.getTransactionTable();
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        AssertJUnit.assertEquals((Object)tx, (Object)mgr.getTransaction());
        GlobalTransaction remoteGtx = new GlobalTransaction();
        remoteGtx.setAddress((Address)new AbstractOptimisticTestCase.DummyAddress());
        MethodCall meth = (MethodCall)entry.getModifications().get(0);
        meth.getArgs()[0] = remoteGtx;
        MethodCall prepareMethod = MethodCallFactory.create((int)18, (Object[])new Object[]{remoteGtx, this.injectDataVersion(entry.getModifications()), null, remoteGtx.getAddress(), Boolean.FALSE});
        try {
            TestingUtil.getRemoteDelegate(cache)._replicate(prepareMethod);
        }
        catch (Throwable t) {
            AssertJUnit.fail();
        }
        AssertJUnit.assertEquals((int)2, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)2, (int)cache.getTransactionTable().getNumLocalTransactions());
        MethodCall rollbackMethod = MethodCallFactory.create((int)12, (Object[])new Object[]{remoteGtx});
        try {
            TestingUtil.getRemoteDelegate(cache)._replicate(rollbackMethod);
        }
        catch (Throwable t) {
            AssertJUnit.fail();
        }
        AssertJUnit.assertEquals((Object)tx, (Object)mgr.getTransaction());
        AssertJUnit.assertNull((Object)table.get(remoteGtx));
        AssertJUnit.assertNull((Object)table.getLocalTransaction(remoteGtx));
        List<Integer> calls = dummy.getAllCalledIds();
        AssertJUnit.assertEquals((Object)18, (Object)calls.get(0));
        AssertJUnit.assertEquals((Object)12, (Object)calls.get(1));
        AssertJUnit.assertEquals((int)1, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)1, (int)cache.getTransactionTable().getNumLocalTransactions());
        mgr.commit();
        calls = dummy.getAllCalledIds();
        AssertJUnit.assertEquals((Object)18, (Object)calls.get(2));
        AssertJUnit.assertEquals((Object)11, (Object)calls.get(3));
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertEquals(null, (Object)mgr.getTransaction());
        cache.stop();
    }

    public void testRemoteCommitTransaction() throws Exception {
        CacheSPI<Object, Object> cache = this.createCache();
        MockInterceptor dummy = new MockInterceptor();
        this.setAlteredInterceptorChain(dummy, cache);
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        cache.getCurrentTransaction(tx, true);
        SamplePojo pojo = new SamplePojo(21, "test");
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        GlobalTransaction gtx = cache.getCurrentTransaction(tx, true);
        TransactionTable table = cache.getTransactionTable();
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        AssertJUnit.assertNotNull((Object)mgr.getTransaction());
        mgr.commit();
        List<Integer> calls = dummy.getAllCalledIds();
        AssertJUnit.assertEquals((Object)18, (Object)calls.get(0));
        AssertJUnit.assertEquals((Object)11, (Object)calls.get(1));
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        GlobalTransaction remoteGtx = new GlobalTransaction();
        remoteGtx.setAddress((Address)new AbstractOptimisticTestCase.DummyAddress());
        MethodCall meth = (MethodCall)entry.getModifications().get(0);
        meth.getArgs()[0] = remoteGtx;
        MethodCall prepareMethod = MethodCallFactory.create((int)18, (Object[])new Object[]{remoteGtx, this.injectDataVersion(entry.getModifications()), null, remoteGtx.getAddress(), Boolean.FALSE});
        try {
            TestingUtil.getRemoteDelegate(cache)._replicate(prepareMethod);
        }
        catch (Throwable t) {
            AssertJUnit.fail();
        }
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)1, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)1, (int)cache.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertNotNull((Object)table.get(remoteGtx));
        AssertJUnit.assertNotNull((Object)table.getLocalTransaction(remoteGtx));
        AssertJUnit.assertEquals((int)1, (int)table.get(remoteGtx).getModifications().size());
        calls = dummy.getAllCalledIds();
        AssertJUnit.assertEquals((Object)18, (Object)calls.get(2));
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        MethodCall commitMethod = MethodCallFactory.create((int)11, (Object[])new Object[]{remoteGtx, Boolean.TRUE});
        try {
            TestingUtil.getRemoteDelegate(cache)._replicate(commitMethod);
        }
        catch (Throwable t) {
            AssertJUnit.fail();
        }
        AssertJUnit.assertNull((Object)table.get(remoteGtx));
        AssertJUnit.assertNull((Object)table.getLocalTransaction(remoteGtx));
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        cache.stop();
    }

    public void testRemoteRollbackTransaction() throws Exception {
        CacheSPI<Object, Object> cache = this.createCache();
        MockInterceptor dummy = new MockInterceptor();
        this.setAlteredInterceptorChain(dummy, cache);
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        cache.getCurrentTransaction(tx, true);
        SamplePojo pojo = new SamplePojo(21, "test");
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        GlobalTransaction gtx = cache.getCurrentTransaction(tx, true);
        TransactionTable table = cache.getTransactionTable();
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        AssertJUnit.assertNotNull((Object)mgr.getTransaction());
        mgr.commit();
        List<Integer> calls = dummy.getAllCalledIds();
        AssertJUnit.assertEquals((Object)18, (Object)calls.get(0));
        AssertJUnit.assertEquals((Object)11, (Object)calls.get(1));
        GlobalTransaction remoteGtx = new GlobalTransaction();
        remoteGtx.setAddress((Address)new AbstractOptimisticTestCase.DummyAddress());
        MethodCall meth = (MethodCall)entry.getModifications().get(0);
        meth.getArgs()[0] = remoteGtx;
        MethodCall prepareMethod = MethodCallFactory.create((int)18, (Object[])new Object[]{remoteGtx, this.injectDataVersion(entry.getModifications()), null, remoteGtx.getAddress(), Boolean.FALSE});
        try {
            TestingUtil.getRemoteDelegate(cache)._replicate(prepareMethod);
        }
        catch (Throwable t) {
            AssertJUnit.fail();
        }
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertNotNull((Object)table.get(remoteGtx));
        AssertJUnit.assertNotNull((Object)table.getLocalTransaction(remoteGtx));
        AssertJUnit.assertEquals((int)1, (int)table.get(remoteGtx).getModifications().size());
        calls = dummy.getAllCalledIds();
        AssertJUnit.assertEquals((Object)18, (Object)calls.get(2));
        MethodCall rollbackMethod = MethodCallFactory.create((int)12, (Object[])new Object[]{remoteGtx});
        try {
            TestingUtil.getRemoteDelegate(cache)._replicate(rollbackMethod);
        }
        catch (Throwable t) {
            AssertJUnit.fail();
        }
        calls = dummy.getAllCalledIds();
        AssertJUnit.assertEquals((Object)18, (Object)calls.get(2));
        AssertJUnit.assertEquals((Object)12, (Object)calls.get(3));
        AssertJUnit.assertNull((Object)table.get(remoteGtx));
        AssertJUnit.assertNull((Object)table.getLocalTransaction(remoteGtx));
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        cache.stop();
    }

    public void testSequentialTransactionExists() throws Exception {
        CacheSPI<Object, Object> cache = this.createCache();
        MockInterceptor dummy = new MockInterceptor();
        this.setAlteredInterceptorChain(dummy, cache);
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        SamplePojo pojo = new SamplePojo(21, "test");
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        AssertJUnit.assertNotNull((Object)mgr.getTransaction());
        mgr.commit();
        mgr.begin();
        Transaction tx1 = mgr.getTransaction();
        AssertJUnit.assertNotNull((Object)tx1);
        AssertJUnit.assertNotSame((Object)tx, (Object)tx1);
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        mgr.commit();
        List<Integer> calls = dummy.getAllCalledIds();
        AssertJUnit.assertEquals((Object)18, (Object)calls.get(0));
        AssertJUnit.assertEquals((Object)11, (Object)calls.get(1));
        AssertJUnit.assertEquals((Object)18, (Object)calls.get(2));
        AssertJUnit.assertEquals((Object)11, (Object)calls.get(3));
        cache.stop();
    }
}

