/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.io.InputStream;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheFactory;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.factories.ComponentFactory;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.invocation.CacheInvocationDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCacheFactory<K, V>
extends ComponentFactory
implements CacheFactory<K, V> {
    private ClassLoader defaultClassLoader;

    @Deprecated
    public static <K, V> CacheFactory<K, V> getInstance() {
        return new DefaultCacheFactory<K, V>();
    }

    @Override
    public Cache<K, V> createCache() throws ConfigurationException {
        return this.createCache(true);
    }

    @Override
    public Cache<K, V> createCache(boolean start) throws ConfigurationException {
        return this.createCache(new Configuration(), start);
    }

    @Override
    public Cache<K, V> createCache(String configFileName) throws ConfigurationException {
        return this.createCache(configFileName, true);
    }

    @Override
    public Cache<K, V> createCache(String configFileName, boolean start) throws ConfigurationException {
        XmlConfigurationParser parser = new XmlConfigurationParser();
        Configuration c = parser.parseFile(configFileName);
        return this.createCache(c, start);
    }

    @Override
    public Cache<K, V> createCache(Configuration configuration) throws ConfigurationException {
        return this.createCache(configuration, true);
    }

    @Override
    public Cache<K, V> createCache(Configuration configuration, boolean start) throws ConfigurationException {
        try {
            CacheSPI<K, V> cache = this.createAndWire(configuration);
            if (start) {
                cache.start();
            }
            return cache;
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected CacheSPI<K, V> createAndWire(Configuration configuration) throws Exception {
        CacheImpl cache = new CacheImpl(configuration);
        CacheInvocationDelegate spi = new CacheInvocationDelegate();
        this.bootstrap(cache, spi, configuration);
        this.componentRegistry.wire();
        return spi;
    }

    protected void bootstrap(CacheImpl cache, CacheSPI spi, Configuration configuration) {
        this.componentRegistry = cache.getComponentRegistry();
        this.componentRegistry.registerDefaultClassLoader(this.defaultClassLoader);
        this.configuration = configuration;
        this.componentRegistry.registerComponent(cache, CacheImpl.class);
        this.componentRegistry.registerComponent(CacheSPI.class.getName(), spi, CacheSPI.class);
    }

    public void setDefaultClassLoader(ClassLoader loader) {
        this.defaultClassLoader = loader;
    }

    @Override
    public Cache<K, V> createCache(InputStream is) throws ConfigurationException {
        XmlConfigurationParser parser = new XmlConfigurationParser();
        Configuration c = parser.parseStream(is);
        return this.createCache(c);
    }

    @Override
    public Cache<K, V> createCache(InputStream is, boolean start) throws ConfigurationException {
        XmlConfigurationParser parser = new XmlConfigurationParser();
        Configuration c = parser.parseStream(is);
        return this.createCache(c, start);
    }

    @Override
    protected <T> T construct(String componentName, Class<T> componentType) {
        throw new UnsupportedOperationException("Should never be invoked - this is a bootstrap factory.");
    }
}

