/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.io.NotSerializableException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.marshall.MarshalledValue;
import org.jboss.cache.marshall.MarshalledValueHelper;
import org.jboss.cache.marshall.MarshalledValueMap;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodDeclarations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarshalledValueInterceptor
extends Interceptor {
    @Override
    public Object invoke(InvocationContext context) throws Throwable {
        MethodCall call = context.getMethodCall();
        boolean isAPICall = false;
        int id = call.getMethodId();
        HashSet<MarshalledValue> marshalledValues = null;
        if (MethodDeclarations.isAPIMethodCall(id) && id != 31 && id != 5) {
            marshalledValues = new HashSet<MarshalledValue>();
            isAPICall = true;
            if (this.trace) {
                this.log.trace((Object)"Is API method; wrapping any args that need to be wrapped");
            }
            Object[] args = call.getArgs();
            Object[] replacementArgs = new Object[args.length];
            int counter = -1;
            for (Object o : args) {
                if (o == null || MarshalledValueHelper.isTypeExcluded(o.getClass()) || this.isInternalCollection(++counter, id)) {
                    replacementArgs[counter] = o;
                    continue;
                }
                if (this.needToReplaceMap(counter, id)) {
                    if (this.trace) {
                        this.log.trace((Object)("Wrapping map contents of argument " + counter));
                    }
                    replacementArgs[counter] = this.wrapMap((Map)o, marshalledValues, context);
                    continue;
                }
                if (this.trace) {
                    this.log.trace((Object)("Wrapping argument " + counter + " which contains type " + o.getClass()));
                }
                replacementArgs[counter] = this.createAndAddMarshalledValue(o, marshalledValues, context);
            }
            call.setArgs(replacementArgs);
        }
        Object retVal = this.nextInterceptor(context);
        if (isAPICall) {
            if (this.trace) {
                this.log.trace((Object)"Compacting MarshalledValues created");
            }
            for (MarshalledValue mv : marshalledValues) {
                mv.compact(false, false);
            }
            if (retVal instanceof MarshalledValue) {
                if (this.trace) {
                    this.log.trace((Object)"Return value is a MarshalledValue.  Unwrapping.");
                }
                retVal = ((MarshalledValue)retVal).get();
            } else if (retVal instanceof Map && call.getMethodId() == 24) {
                Map retValMap;
                if (this.trace) {
                    this.log.trace((Object)"Return value is a Map and we're retrieving data.  Wrapping as a MarshalledValueMap.");
                }
                if (!(retValMap = (Map)retVal).isEmpty()) {
                    retVal = new MarshalledValueMap(retValMap);
                }
            }
        }
        return retVal;
    }

    protected boolean isInternalCollection(int argSubscript, int methodId) {
        return methodId == 10 && argSubscript == 1 || methodId == 18 && (argSubscript == 1 || argSubscript == 2);
    }

    protected boolean needToReplaceMap(int argSubscript, int methodId) {
        return (methodId == 2 || methodId == 1) && argSubscript == 2;
    }

    protected Map wrapMap(Map m, Set<MarshalledValue> marshalledValues, InvocationContext ctx) throws NotSerializableException {
        HashMap copy = new HashMap();
        for (Object key : m.keySet()) {
            Object value = m.get(key);
            copy.put(key == null || MarshalledValueHelper.isTypeExcluded(key.getClass()) ? key : this.createAndAddMarshalledValue(key, marshalledValues, ctx), value == null || MarshalledValueHelper.isTypeExcluded(value.getClass()) ? value : this.createAndAddMarshalledValue(value, marshalledValues, ctx));
        }
        return copy;
    }

    protected MarshalledValue createAndAddMarshalledValue(Object toWrap, Set<MarshalledValue> marshalledValues, InvocationContext ctx) throws NotSerializableException {
        MarshalledValue mv = new MarshalledValue(toWrap);
        marshalledValues.add(mv);
        if (!ctx.isOriginLocal()) {
            mv.setEqualityPreferenceForInstance(false);
        }
        return mv;
    }
}

