/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.jmx;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.AttributeChangeNotification;
import javax.management.JMException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.config.BuddyReplicationConfig;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.RuntimeConfig;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.jmx.CacheJmxWrapperMBean;
import org.jboss.cache.jmx.CacheNotificationBroadcaster;
import org.jboss.cache.jmx.CacheNotificationListener;
import org.jboss.cache.jmx.JmxUtil;
import org.jboss.cache.util.CachePrinter;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelFactory;
import org.jgroups.jmx.JChannelFactoryMBean;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheJmxWrapper<K, V>
extends NotificationBroadcasterSupport
implements CacheJmxWrapperMBean<K, V>,
MBeanRegistration,
CacheNotificationBroadcaster {
    private Log log = LogFactory.getLog((String)this.getClass().getName());
    private MBeanServer server;
    private String cacheObjectName;
    private boolean interceptorsRegistered;
    private CacheSPI<K, V> cache;
    private Configuration config;
    private boolean registerInterceptors = true;
    private final AtomicInteger listenerCount = new AtomicInteger(0);
    private final AtomicLong sequence = new AtomicLong(0L);
    private final CacheNotificationListener cacheNotificationListener = new CacheNotificationListener(this);
    private CacheStatus cacheStatus = CacheStatus.INSTANTIATED;
    private String notificationServiceName;
    private boolean registered;
    private boolean disableStateChangeNotifications;
    private Element buddyReplConfig;
    private Element evictionConfig;
    private Element cacheLoaderConfig;
    private Element clusterConfig;
    private JChannelFactoryMBean multiplexerService;

    public CacheJmxWrapper() {
    }

    public CacheJmxWrapper(Cache<K, V> cache) {
        this();
        this.setCache(cache);
    }

    @Override
    public Cache<K, V> getCache() {
        return this.cache;
    }

    @Override
    public Configuration getConfiguration() {
        Configuration cfg;
        Configuration configuration = cfg = this.cache == null ? this.config : this.cache.getConfiguration();
        if (cfg == null) {
            cfg = this.config = new Configuration();
        }
        return cfg;
    }

    @Override
    public String printConfigurationAsString() {
        Configuration cfg = this.getConfiguration();
        return cfg == null ? "Configuration is null" : cfg.toString();
    }

    @Override
    public String printConfigurationAsHtmlString() {
        Configuration cfg = this.getConfiguration();
        return cfg == null ? "Configuration is null" : CacheJmxWrapper.formatHtml(cfg.toString());
    }

    @Override
    public String printCacheDetails() {
        return this.cache == null ? "Cache is null" : CachePrinter.printCacheDetails(this.cache);
    }

    @Override
    public String printCacheDetailsAsHtml() {
        return this.cache == null ? "Cache is null" : CacheJmxWrapper.formatHtml(CachePrinter.printCacheDetails(this.cache));
    }

    @Override
    public CacheStatus getCacheStatus() {
        return this.cacheStatus;
    }

    @Override
    public int getState() {
        switch (this.cacheStatus) {
            case INSTANTIATED: 
            case CREATING: {
                return this.registered ? 8 : 7;
            }
            case CREATED: {
                return 6;
            }
            case STARTING: {
                return 2;
            }
            case STARTED: {
                return 3;
            }
            case STOPPING: {
                return 1;
            }
            case STOPPED: 
            case DESTROYING: {
                return 0;
            }
            case DESTROYED: {
                return this.registered ? 5 : 7;
            }
        }
        return 4;
    }

    @Override
    public Address getLocalAddress() {
        return this.cache == null ? null : this.cache.getLocalAddress();
    }

    @Override
    public List<Address> getMembers() {
        return this.cache == null ? null : this.cache.getMembers();
    }

    @Override
    public int getNumberOfNodes() {
        return this.cache == null ? -1 : this.cache.getNumberOfNodes();
    }

    @Override
    public int getNumberOfAttributes() {
        return this.cache == null ? -1 : this.cache.getNumberOfAttributes();
    }

    @Override
    public String printLockInfo() {
        return this.cache == null ? "Cache is null" : CachePrinter.printCacheLockingInfo(this.cache);
    }

    @Override
    public String printLockInfoAsHtml() {
        return this.cache == null ? "Cache is null" : CacheJmxWrapper.formatHtml(CachePrinter.printCacheLockingInfo(this.cache));
    }

    @Override
    public boolean getRegisterInterceptors() {
        return this.registerInterceptors;
    }

    @Override
    public void setRegisterInterceptors(boolean register) {
        this.registerInterceptors = register;
    }

    @Override
    public Element getBuddyReplicationConfig() {
        return this.buddyReplConfig;
    }

    @Override
    public Element getCacheLoaderConfig() {
        return this.cacheLoaderConfig;
    }

    @Override
    public Element getCacheLoaderConfiguration() {
        return this.getCacheLoaderConfig();
    }

    @Override
    public String getCacheMode() {
        return this.getConfiguration().getCacheModeString();
    }

    @Override
    public String getClusterName() {
        return this.getConfiguration().getClusterName();
    }

    @Override
    public String getClusterProperties() {
        return this.getConfiguration().getClusterConfig();
    }

    @Override
    public Element getClusterConfig() {
        return this.clusterConfig;
    }

    @Override
    public Element getEvictionPolicyConfig() {
        return this.evictionConfig;
    }

    @Override
    public boolean getExposeManagementStatistics() {
        return this.getConfiguration().getExposeManagementStatistics();
    }

    @Override
    public boolean getUseInterceptorMbeans() {
        return this.getExposeManagementStatistics();
    }

    @Override
    public boolean getFetchInMemoryState() {
        return this.getConfiguration().isFetchInMemoryState();
    }

    @Override
    public long getStateRetrievalTimeout() {
        return this.getConfiguration().getStateRetrievalTimeout();
    }

    @Override
    @Deprecated
    public void setInitialStateRetrievalTimeout(long timeout) {
        this.setStateRetrievalTimeout(timeout);
    }

    @Override
    public String getIsolationLevel() {
        return this.getConfiguration().getIsolationLevelString();
    }

    @Override
    public long getLockAcquisitionTimeout() {
        return this.getConfiguration().getLockAcquisitionTimeout();
    }

    @Override
    public JChannelFactoryMBean getMultiplexerService() {
        return this.multiplexerService;
    }

    @Override
    public String getMultiplexerStack() {
        return this.getConfiguration().getMultiplexerStack();
    }

    @Override
    public ChannelFactory getMuxChannelFactory() {
        return this.getConfiguration().getRuntimeConfig().getMuxChannelFactory();
    }

    @Override
    public String getNodeLockingScheme() {
        return this.getConfiguration().getNodeLockingSchemeString();
    }

    @Override
    public long getReplQueueInterval() {
        return this.getConfiguration().getReplQueueInterval();
    }

    @Override
    public int getReplQueueMaxElements() {
        return this.getConfiguration().getReplQueueMaxElements();
    }

    @Override
    public String getReplicationVersion() {
        return this.getConfiguration().getReplVersionString();
    }

    @Override
    public boolean getSyncCommitPhase() {
        return this.getConfiguration().isSyncCommitPhase();
    }

    @Override
    public long getSyncReplTimeout() {
        return this.getConfiguration().getSyncReplTimeout();
    }

    @Override
    public boolean getSyncRollbackPhase() {
        return this.getConfiguration().isSyncRollbackPhase();
    }

    @Override
    public TransactionManager getTransactionManager() {
        return this.getConfiguration().getRuntimeConfig().getTransactionManager();
    }

    @Override
    public String getTransactionManagerLookupClass() {
        return this.getConfiguration().getTransactionManagerLookupClass();
    }

    @Override
    @Deprecated
    public boolean getUseRegionBasedMarshalling() {
        return this.getConfiguration().isUseRegionBasedMarshalling();
    }

    public boolean isUseLazyDeserialization() {
        return this.getConfiguration().isUseLazyDeserialization();
    }

    @Override
    public boolean getUseReplQueue() {
        return this.getConfiguration().isUseReplQueue();
    }

    @Override
    public boolean isInactiveOnStartup() {
        return this.getConfiguration().isInactiveOnStartup();
    }

    @Override
    public void setBuddyReplicationConfig(Element config) {
        BuddyReplicationConfig brc = null;
        if (config != null) {
            brc = XmlConfigurationParser.parseBuddyReplicationConfig(config);
        }
        this.getConfiguration().setBuddyReplicationConfig(brc);
        this.buddyReplConfig = config;
    }

    @Override
    public void setCacheLoaderConfig(Element cache_loader_config) {
        CacheLoaderConfig clc = null;
        if (cache_loader_config != null) {
            clc = XmlConfigurationParser.parseCacheLoaderConfig(cache_loader_config);
        }
        this.getConfiguration().setCacheLoaderConfig(clc);
        this.cacheLoaderConfig = cache_loader_config;
    }

    @Override
    public void setCacheLoaderConfiguration(Element config) {
        this.log.warn((Object)"MBean attribute 'CacheLoaderConfiguration' is deprecated; use 'CacheLoaderConfig'");
        this.setCacheLoaderConfig(config);
    }

    @Override
    public void setCacheMode(String mode) throws Exception {
        this.getConfiguration().setCacheModeString(mode);
    }

    @Override
    public void setClusterConfig(Element config) {
        String props = null;
        if (config != null) {
            props = XmlConfigurationParser.parseClusterConfigXml(config);
        }
        this.getConfiguration().setClusterConfig(props);
        this.clusterConfig = config;
    }

    @Override
    @Deprecated
    public long getInitialStateRetrievalTimeout() {
        return this.getStateRetrievalTimeout();
    }

    @Override
    public void setClusterName(String name) {
        this.getConfiguration().setClusterName(name);
    }

    @Override
    public void setClusterProperties(String cluster_props) {
        this.getConfiguration().setClusterConfig(cluster_props);
    }

    @Override
    public void setEvictionPolicyConfig(Element config) {
        EvictionConfig ec = null;
        if (config != null) {
            ec = XmlConfigurationParser.parseEvictionConfig(config);
        }
        this.getConfiguration().setEvictionConfig(ec);
        this.evictionConfig = config;
    }

    @Override
    public void setExposeManagementStatistics(boolean expose) {
        this.getConfiguration().setExposeManagementStatistics(expose);
    }

    @Override
    public void setUseInterceptorMbeans(boolean use) {
        this.log.warn((Object)"MBean attribute 'UseInterceptorMbeans' is deprecated; use 'ExposeManagementStatistics'");
        this.setExposeManagementStatistics(use);
    }

    @Override
    public void setFetchInMemoryState(boolean flag) {
        this.getConfiguration().setFetchInMemoryState(flag);
    }

    @Override
    public void setInactiveOnStartup(boolean inactiveOnStartup) {
        this.getConfiguration().setInactiveOnStartup(inactiveOnStartup);
    }

    @Override
    public void setStateRetrievalTimeout(long timeout) {
        this.getConfiguration().setStateRetrievalTimeout(timeout);
    }

    @Override
    public void setIsolationLevel(String level) {
        this.getConfiguration().setIsolationLevelString(level);
    }

    @Override
    public void setLockAcquisitionTimeout(long timeout) {
        this.getConfiguration().setLockAcquisitionTimeout(timeout);
    }

    @Override
    public void setMultiplexerService(JChannelFactoryMBean muxService) {
        this.multiplexerService = muxService;
    }

    @Override
    public void setMultiplexerStack(String stackName) {
        this.getConfiguration().setMultiplexerStack(stackName);
    }

    @Override
    public void setMuxChannelFactory(ChannelFactory factory) {
        this.getConfiguration().getRuntimeConfig().setMuxChannelFactory(factory);
    }

    @Override
    public void setNodeLockingScheme(String nodeLockingScheme) {
        this.getConfiguration().setNodeLockingSchemeString(nodeLockingScheme);
    }

    @Override
    public void setReplQueueInterval(long interval) {
        this.getConfiguration().setReplQueueInterval(interval);
    }

    @Override
    public void setReplQueueMaxElements(int max_elements) {
        this.getConfiguration().setReplQueueMaxElements(max_elements);
    }

    @Override
    public void setReplicationVersion(String version) {
        this.getConfiguration().setReplVersionString(version);
    }

    @Override
    public void setSyncCommitPhase(boolean sync_commit_phase) {
        this.getConfiguration().setSyncCommitPhase(sync_commit_phase);
    }

    @Override
    public void setSyncReplTimeout(long timeout) {
        this.getConfiguration().setSyncReplTimeout(timeout);
    }

    @Override
    public void setSyncRollbackPhase(boolean sync_rollback_phase) {
        this.getConfiguration().setSyncRollbackPhase(sync_rollback_phase);
    }

    @Override
    public void setTransactionManager(TransactionManager manager) {
        this.getConfiguration().getRuntimeConfig().setTransactionManager(manager);
    }

    @Override
    public void setTransactionManagerLookupClass(String cl) throws Exception {
        this.getConfiguration().setTransactionManagerLookupClass(cl);
    }

    @Override
    public void setUseRegionBasedMarshalling(boolean isTrue) {
        this.getConfiguration().setUseRegionBasedMarshalling(isTrue);
    }

    @Override
    public void setUseReplQueue(boolean flag) {
        this.getConfiguration().setUseReplQueue(flag);
    }

    @Override
    public void create() throws CacheException {
        if (!this.cacheStatus.createAllowed()) {
            if (this.cacheStatus.needToDestroyFailedCache()) {
                this.destroy();
            } else {
                return;
            }
        }
        try {
            this.cacheStatus = CacheStatus.CREATING;
            if (this.cache == null) {
                if (this.config == null) {
                    throw new ConfigurationException("Must call setConfiguration() or setCache() before call to create()");
                }
                this.constructCache();
            }
            this.cache.create();
            this.cacheStatus = CacheStatus.CREATED;
        }
        catch (Throwable t) {
            this.handleLifecycleTransitionFailure(t);
        }
    }

    @Override
    public void start() throws CacheException {
        if (!this.cacheStatus.startAllowed()) {
            if (this.cacheStatus.needToDestroyFailedCache()) {
                this.destroy();
            }
            if (this.cacheStatus.needCreateBeforeStart()) {
                this.create();
            } else {
                return;
            }
        }
        try {
            int oldState = this.getState();
            this.cacheStatus = CacheStatus.STARTING;
            int startingState = this.getState();
            this.sendStateChangeNotification(oldState, startingState, this.getClass().getSimpleName() + " starting", null);
            this.cache.start();
            this.registerInterceptors();
            this.cacheStatus = CacheStatus.STARTED;
            this.sendStateChangeNotification(startingState, this.getState(), this.getClass().getSimpleName() + " started", null);
        }
        catch (Throwable t) {
            this.handleLifecycleTransitionFailure(t);
        }
    }

    @Override
    public void stop() {
        if (!this.cacheStatus.stopAllowed()) {
            return;
        }
        boolean failed = this.cacheStatus == CacheStatus.FAILED;
        try {
            int oldState = this.getState();
            this.cacheStatus = CacheStatus.STOPPING;
            int stoppingState = this.getState();
            this.sendStateChangeNotification(oldState, stoppingState, this.getClass().getSimpleName() + " stopping", null);
            this.cache.stop();
            if (this.cache.getCacheStatus() == CacheStatus.DESTROYED) {
                this.unregisterInterceptors();
            }
            this.cacheStatus = CacheStatus.STOPPED;
            this.sendStateChangeNotification(stoppingState, this.getState(), this.getClass().getSimpleName() + " stopped", null);
        }
        catch (Throwable t) {
            if (failed) {
                this.log.warn((Object)"Attempted to stop() from FAILED state, but caught exception; try calling destroy()", t);
            }
            this.handleLifecycleTransitionFailure(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        if (!this.cacheStatus.destroyAllowed()) {
            if (this.cacheStatus.needStopBeforeDestroy()) {
                try {
                    this.stop();
                }
                catch (CacheException e) {
                    this.log.warn((Object)"Needed to call stop() before destroying but stop() threw exception. Proceeding to destroy", (Throwable)e);
                }
            } else {
                return;
            }
        }
        try {
            this.cacheStatus = CacheStatus.DESTROYING;
            this.unregisterInterceptors();
            if (this.cache != null) {
                this.cache.destroy();
            }
        }
        finally {
            this.cacheStatus = CacheStatus.DESTROYED;
        }
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName objName) throws Exception {
        this.server = server;
        if (this.cacheObjectName == null) {
            if (objName == null) {
                this.getCacheObjectName();
            } else {
                this.cacheObjectName = objName.getCanonicalName();
            }
        }
        ObjectName result = new ObjectName(this.cacheObjectName);
        if (this.notificationServiceName == null) {
            this.notificationServiceName = result.getCanonicalName();
        }
        this.cacheNotificationListener.setServiceName(this.notificationServiceName);
        return result;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        if (Boolean.TRUE.equals(registrationDone)) {
            this.log.debug((Object)("Registered in JMX under " + this.cacheObjectName));
            if (this.cache != null && CacheStatus.STARTED.equals((Object)this.cache.getCacheStatus())) {
                try {
                    this.registerInterceptors();
                }
                catch (Exception e) {
                    this.log.error((Object)"Caught exception registering cache interceptors with JMX", (Throwable)e);
                }
            }
            this.registered = true;
        }
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
        this.unregisterInterceptors();
        this.server = null;
        this.registered = false;
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCache(Cache<K, V> cache) {
        if (this.cacheStatus != CacheStatus.INSTANTIATED && this.cacheStatus != CacheStatus.CREATING && this.cacheStatus != CacheStatus.DESTROYED) {
            throw new IllegalStateException("Cannot set underlying cache after call to create()");
        }
        this.cache = (CacheSPI)cache;
        this.config = cache == null ? null : cache.getConfiguration();
        AtomicInteger atomicInteger = this.listenerCount;
        synchronized (atomicInteger) {
            if (this.listenerCount.get() > 0 && cache != null) {
                cache.addCacheListener(this.cacheNotificationListener);
            }
        }
    }

    public String getCacheObjectName() {
        if (this.cacheObjectName == null) {
            this.cacheObjectName = JmxUtil.getDefaultCacheObjectName(this.config, CacheImpl.class.getName());
        }
        return this.cacheObjectName;
    }

    public void setCacheObjectName(String name) throws MalformedObjectNameException {
        if (name != null) {
            new ObjectName(name);
        }
        this.cacheObjectName = name;
    }

    public boolean isDisableStateChangeNotifications() {
        return this.disableStateChangeNotifications;
    }

    public void setDisableStateChangeNotifications(boolean disableStateChangeNotifications) {
        this.disableStateChangeNotifications = disableStateChangeNotifications;
    }

    public MBeanServer getMBeanServer() {
        return this.server;
    }

    public static String formatHtml(String s) {
        s = s.replaceAll("\r\n", "<br />");
        s = s.replaceAll("\r", "<br />");
        s = s.replaceAll("\n", "<br />");
        s = s.replaceAll("\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
        s = s.replaceAll(" ", "&nbsp;");
        return s;
    }

    public String getNotificationServiceName() {
        return this.notificationServiceName;
    }

    public void setNotificationServiceName(String notificationServiceName) {
        this.notificationServiceName = notificationServiceName;
        this.cacheNotificationListener.setServiceName(notificationServiceName);
    }

    @Override
    public long getNextNotificationSequenceNumber() {
        return this.sequence.getAndIncrement();
    }

    @Override
    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws IllegalArgumentException {
        super.addNotificationListener(notificationListener, notificationFilter, object);
        this.notificationRegistration(true);
    }

    @Override
    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        super.removeNotificationListener(notificationListener);
        this.notificationRegistration(false);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        super.removeNotificationListener(listener, filter, handback);
        this.notificationRegistration(false);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return CacheNotificationListener.getNotificationInfo();
    }

    protected void constructCache() throws ConfigurationException {
        this.log.debug((Object)"Constructing Cache");
        DefaultCacheFactory cf = new DefaultCacheFactory();
        this.setCache(cf.createCache(this.config, false));
        if (this.multiplexerService != null) {
            this.injectMuxChannel();
        }
    }

    protected boolean registerInterceptors() throws CacheException {
        if (this.registerInterceptors && !this.interceptorsRegistered && this.server != null) {
            this.log.debug((Object)"Registering interceptors");
            List<Interceptor> interc = this.cache.getInterceptorChain();
            if (interc != null && interc.size() > 0) {
                try {
                    JmxUtil.registerInterceptors(this.server, interc, this.cacheObjectName);
                    this.interceptorsRegistered = true;
                    return true;
                }
                catch (JMException e) {
                    throw new CacheException("Failed to register interceptors", e);
                }
            }
        }
        return false;
    }

    protected void unregisterInterceptors() {
        if (this.registerInterceptors && this.interceptorsRegistered && this.server != null) {
            try {
                this.log.debug((Object)"Unregistering interceptors");
                JmxUtil.unregisterInterceptors(this.server, this.cache.getInterceptorChain(), this.getCacheObjectName());
                this.interceptorsRegistered = false;
            }
            catch (Exception e) {
                this.log.error((Object)"Exception unregistering interceptors from JMX", (Throwable)e);
            }
        }
    }

    private void injectMuxChannel() throws CacheException {
        Configuration cfg = this.getConfiguration();
        RuntimeConfig rtcfg = cfg.getRuntimeConfig();
        if (rtcfg.getMuxChannelFactory() == null && rtcfg.getChannel() == null) {
            Channel ch;
            try {
                ch = this.multiplexerService.createMultiplexerChannel(cfg.getMultiplexerStack(), cfg.getClusterName());
            }
            catch (Exception e) {
                throw new CacheException("Exception creating multiplexed channel", e);
            }
            rtcfg.setChannel(ch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notificationRegistration(boolean add) {
        AtomicInteger atomicInteger = this.listenerCount;
        synchronized (atomicInteger) {
            if (add) {
                this.listenerCount.incrementAndGet();
                if (this.cache != null) {
                    this.cache.addCacheListener(this.cacheNotificationListener);
                }
            } else if (this.listenerCount.decrementAndGet() <= 0) {
                if (this.cache != null) {
                    this.cache.removeCacheListener(this.cacheNotificationListener);
                }
                this.listenerCount.set(0);
            }
        }
    }

    private void handleLifecycleTransitionFailure(Throwable t) throws RuntimeException, Error {
        int oldState = this.getState();
        this.cacheStatus = CacheStatus.FAILED;
        this.sendStateChangeNotification(oldState, this.getState(), this.getClass().getSimpleName() + " failed", t);
        if (t instanceof CacheException) {
            throw (CacheException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new CacheException(t);
    }

    private void sendStateChangeNotification(int oldState, int newState, String msg, Throwable t) {
        if (this.isDisableStateChangeNotifications()) {
            return;
        }
        long now = System.currentTimeMillis();
        AttributeChangeNotification stateChangeNotification = new AttributeChangeNotification(this, this.getNextNotificationSequenceNumber(), now, msg, "State", "java.lang.Integer", oldState, newState);
        stateChangeNotification.setUserData(t);
        this.sendNotification(stateChangeNotification);
    }
}

