/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.hook;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import org.jboss.aop.hook.GeneratePluggableInstrumentedClassLoader;
import org.jboss.aop.hook.SecurityActions;

public class GenerateInstrumentedClassLoader {
    private static void declare5(CtClass clazz, CtMethod method) throws NotFoundException, CannotCompileException {
        method.setName("wrappedDefineClass");
        CtMethod wrapper = CtNewMethod.make((int)4, (CtClass)method.getReturnType(), (String)"defineClass", (CtClass[])method.getParameterTypes(), (CtClass[])method.getExceptionTypes(), null, (CtClass)clazz);
        String code = "{ if (!$1.startsWith(\"org.jboss.aop\") && !$1.endsWith(\"$aop\") && !$1.startsWith(\"javassist\") && !$1.startsWith(\"org.jboss.util.\") && !$1.startsWith(\"gnu.trove.\") && !$1.startsWith(\"EDU.oswego.cs.dl.util.concurrent.\") && !$1.startsWith(\"org.apache.crimson\") && !$1.startsWith(\"org.apache.xalan\") && !$1.startsWith(\"org.apache.xml\") && !$1.startsWith(\"org.apache.xpath\") && !$1.startsWith(\"org.ietf.\") && !$1.startsWith(\"org.omg.\") && !$1.startsWith(\"org.w3c.\") && !$1.startsWith(\"org.xml.sax.\") && !$1.startsWith(\"sunw.\") && !$1.startsWith(\"sun.\") && !$1.startsWith(\"java.\") && !$1.startsWith(\"javax.\") && !$1.startsWith(\"com.sun.\") && !$1.startsWith(\"$Proxy\")) {      byte[] newBytes = org.jboss.aop.AspectManager.instance().translate($1, $0, $2) ;      if (newBytes != (byte[])null) {         return wrappedDefineClass($1, newBytes, 0, newBytes.length, $5);       }}  return wrappedDefineClass($1, $2, $3, $4, $5);   }";
        wrapper.setBody(code);
        clazz.addMethod(wrapper);
    }

    public static byte[] getInstrumentedClassLoader() throws NotFoundException, IOException, CannotCompileException {
        ClassPool classpool = ClassPool.getDefault();
        classpool = ClassPool.getDefault();
        ClassLoader cl = SecurityActions.getContextClassLoader();
        classpool.insertClassPath((ClassPath)new LoaderClassPath(cl));
        CtClass clazz = classpool.get(ClassLoader.class.getName());
        CtMethod[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals("defineClass") || methods[i].getParameterTypes().length != 5 || !methods[i].getParameterTypes()[1].isArray()) continue;
            GenerateInstrumentedClassLoader.declare5(clazz, methods[i]);
        }
        return clazz.toBytecode();
    }

    public static void main(String[] args) {
        byte[] bytes;
        String filename;
        File file;
        if (args.length != 1) {
            System.err.println("Usage: java " + GeneratePluggableInstrumentedClassLoader.class.getName() + " <output directory>");
            System.exit(1);
        }
        if ((file = new File(filename = args[0] + File.separatorChar + "java" + File.separatorChar + "lang" + File.separatorChar + "ClassLoader.class")).exists()) {
            if (!file.canWrite()) {
                System.err.println("Cannot write to existing file: " + file.getAbsolutePath());
                System.exit(2);
            }
        } else {
            File dir = file.getParentFile();
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (!dir.canWrite()) {
                System.err.println("Cannot write to parent directory: " + dir.getAbsolutePath());
            }
        }
        try {
            bytes = GenerateInstrumentedClassLoader.getInstrumentedClassLoader();
        }
        catch (Throwable th) {
            System.err.println("Unexpected exception caught during instrumentation: " + th.getMessage());
            th.printStackTrace(System.err);
            System.exit(5);
            return;
        }
        try {
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(bytes);
            fos.close();
        }
        catch (IOException ioe) {
            System.err.println("Unexpected exception caught while writing class file: " + ioe.getMessage());
            ioe.printStackTrace(System.err);
            System.exit(6);
        }
    }
}

