/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.api;

import java.util.HashMap;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.Node;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.NodeCreated;
import org.jboss.cache.notifications.event.Event;
import org.jboss.cache.transaction.GenericTransactionManagerLookup;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class DestroyedCacheAPITest {
    private Cache<String, String> cache;
    protected boolean optimistic;
    private Fqn parent = Fqn.fromString((String)"/test/fqn");
    private Fqn child = Fqn.fromString((String)"/test/fqn/child");
    private String version;
    private Node<String, String> root;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        DefaultCacheFactory cf = new DefaultCacheFactory();
        this.cache = cf.createCache("META-INF/conf-test/local-tx-service.xml", false);
        this.cache.getConfiguration().setNodeLockingScheme(this.optimistic ? Configuration.NodeLockingScheme.OPTIMISTIC : Configuration.NodeLockingScheme.PESSIMISTIC);
        this.cache.start();
        this.version = this.cache.getVersion();
        this.cache.getRoot().addChild(this.parent);
        this.cache.getRoot().addChild(this.child);
        this.root = this.cache.getRoot();
        this.cache.stop();
        this.cache.destroy();
    }

    public void testConfiguration() {
        Configuration c = this.cache.getConfiguration();
        AssertJUnit.assertEquals((Object)Configuration.CacheMode.LOCAL, (Object)c.getCacheMode());
        AssertJUnit.assertEquals((String)GenericTransactionManagerLookup.class.getName(), (String)c.getTransactionManagerLookupClass());
        c.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        AssertJUnit.assertEquals((Object)Configuration.CacheMode.REPL_SYNC, (Object)c.getCacheMode());
        c.setLockAcquisitionTimeout(100L);
        AssertJUnit.assertEquals((long)100L, (long)c.getLockAcquisitionTimeout());
    }

    public void testCacheListeners() {
        try {
            this.cache.getCacheListeners();
        }
        catch (IllegalStateException good) {
            // empty catch block
        }
        Listener dummy = new Listener();
        try {
            this.cache.addCacheListener((Object)dummy);
        }
        catch (IllegalStateException good) {
            // empty catch block
        }
        try {
            this.cache.removeCacheListener((Object)dummy);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testConvenienceMethods() {
        String key = "key";
        String value = "value";
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(key, value);
        try {
            this.cache.get(this.parent, (Object)key);
            AssertJUnit.fail((String)"Get key on destroyed cache did not throw ISE");
        }
        catch (IllegalStateException good) {
            // empty catch block
        }
        try {
            this.cache.getNode(this.parent);
            AssertJUnit.fail((String)"Get node on destroyed cache did not throw ISE");
        }
        catch (IllegalStateException good) {
            // empty catch block
        }
        try {
            this.cache.put(this.parent, (Object)key, (Object)value);
            AssertJUnit.fail((String)"Put key/value on destroyed cache did not throw ISE");
        }
        catch (IllegalStateException good) {
            // empty catch block
        }
        try {
            this.cache.putForExternalRead(this.parent, (Object)key, (Object)value);
            AssertJUnit.fail((String)"Put for external read on destroyed cache did not throw ISE");
        }
        catch (IllegalStateException good) {
            // empty catch block
        }
        try {
            this.cache.put(this.parent, data);
            AssertJUnit.fail((String)"Put Map on destroyed cache did not throw ISE");
        }
        catch (IllegalStateException good) {
            // empty catch block
        }
        try {
            this.cache.move(this.child, Fqn.ROOT);
            AssertJUnit.fail((String)"Remove move on destroyed cache did not throw ISE");
        }
        catch (IllegalStateException good) {
            // empty catch block
        }
        try {
            this.cache.getData(this.parent);
            AssertJUnit.fail((String)"getData on destroyed cache did not throw ISE");
        }
        catch (IllegalStateException good) {
            // empty catch block
        }
        try {
            this.cache.getKeys(this.parent);
            AssertJUnit.fail((String)"getKeys on destroyed cache did not throw ISE");
        }
        catch (IllegalStateException good) {
            // empty catch block
        }
        try {
            this.cache.clearData(this.parent);
            AssertJUnit.fail((String)"clearData on destroyed cache did not throw ISE");
        }
        catch (IllegalStateException good) {
            // empty catch block
        }
        try {
            this.cache.remove(this.parent, (Object)key);
            AssertJUnit.fail((String)"Remove key on destroyed cache did not throw ISE");
        }
        catch (IllegalStateException good) {
            // empty catch block
        }
        try {
            this.cache.removeNode(this.parent);
            AssertJUnit.fail((String)"Remove node on destroyed cache did not throw ISE");
        }
        catch (IllegalStateException good) {
            // empty catch block
        }
    }

    public void testNodeAPI() {
        try {
            this.root.addChild(this.parent);
            AssertJUnit.fail((String)"addChild on destroyed cache did not throw ISE");
        }
        catch (IllegalStateException good) {
            // empty catch block
        }
        try {
            this.root.hasChild(this.parent);
            AssertJUnit.fail((String)"hasChild on destroyed cache did not throw ISE");
        }
        catch (IllegalStateException good) {
            // empty catch block
        }
        try {
            this.root.getChild(this.parent);
            AssertJUnit.fail((String)"getChild on destroyed cache did not throw ISE");
        }
        catch (IllegalStateException good) {
            // empty catch block
        }
        try {
            this.root.removeChild(this.parent);
            AssertJUnit.fail((String)"removeChild on destroyed cache did not throw ISE");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testEvict() {
        try {
            this.cache.evict(this.parent, false);
            assert (false) : "Should throw ISE";
        }
        catch (IllegalStateException ok) {
            // empty catch block
        }
        try {
            this.cache.evict(this.child, false);
            assert (false) : "Should throw ISE";
        }
        catch (IllegalStateException ok) {
            // empty catch block
        }
        try {
            this.cache.evict(this.parent, true);
            assert (false) : "Should throw ISE";
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGetRegion() {
        AssertJUnit.assertNull((Object)this.cache.getRegion(this.parent, false));
        AssertJUnit.assertNotNull((Object)this.cache.getRegion(Fqn.ROOT, true));
    }

    public void testRemoveRegion() {
        AssertJUnit.assertFalse((boolean)this.cache.removeRegion(this.parent));
    }

    public void testGetLocalAddress() {
        AssertJUnit.assertEquals((String)"CacheMode.LOCAL cache has no address", null, (Object)this.cache.getLocalAddress());
    }

    public void testGetMembers() {
        AssertJUnit.assertNull((Object)this.cache.getMembers());
    }

    public void testGetCacheStatus() {
        AssertJUnit.assertEquals((Object)CacheStatus.DESTROYED, (Object)this.cache.getCacheStatus());
    }

    public void testInvocationContext() {
        InvocationContext ctx = new InvocationContext();
        this.cache.setInvocationContext(ctx);
        AssertJUnit.assertSame((Object)ctx, (Object)this.cache.getInvocationContext());
    }

    public void testGetVersion() {
        AssertJUnit.assertEquals((String)this.version, (String)this.cache.getVersion());
    }

    @CacheListener
    public class Listener {
        @NodeCreated
        public void nodeCreated(Event e) {
        }
    }
}

