/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.RegionManager;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.config.EvictionPolicyConfig;
import org.jboss.cache.eviction.BaseEvictionAlgorithm;
import org.jboss.cache.eviction.BaseEvictionPolicy;
import org.jboss.cache.eviction.EvictedEventNode;
import org.jboss.cache.eviction.EvictionAlgorithm;
import org.jboss.cache.eviction.EvictionException;
import org.jboss.cache.eviction.EvictionQueue;
import org.jboss.cache.eviction.LRUQueue;
import org.jboss.cache.eviction.NodeEntry;
import org.jboss.cache.eviction.NodeEventType;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class BaseEvictionAlgorithmTest {
    private static final Log log = LogFactory.getLog(BaseEvictionAlgorithmTest.class);
    private RegionManager regionManager;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.regionManager = new RegionManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFillUpRecycleQueue() throws Exception {
        int recycleQueueCapacity = 10;
        MockEvictionAlgorithm algorithm = new MockEvictionAlgorithm(10);
        Region region = this.regionManager.getRegion("/a/b/c", true);
        region.setEvictionPolicy((EvictionPolicyConfig)new MockEvictionPolicyConfig());
        for (int i = 0; i < 11; ++i) {
            Fqn fqn = Fqn.fromString((String)("/a/b/c/" + Integer.toString(i + 1)));
            region.putNodeEvent(new EvictedEventNode(fqn, NodeEventType.ADD_NODE_EVENT));
        }
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Void> future = executor.submit(new ProcessEvictionRegion(region, (EvictionAlgorithm)algorithm));
        try {
            future.get(20L, TimeUnit.SECONDS);
        }
        catch (TimeoutException te) {
            log.error((Object)"Region eviction processing did not finish on time", (Throwable)te);
            AssertJUnit.fail((String)"Region eviction processing should have finished by now, something is wrong. Recycle queue may have filled up.");
        }
        finally {
            log.info((Object)("recycle queue size: " + algorithm.recycleQueue.size()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ProcessEvictionRegion
    implements Callable<Void> {
        private Region region;
        private EvictionAlgorithm algorithm;

        public ProcessEvictionRegion(Region region, EvictionAlgorithm algorithm) {
            this.region = region;
            this.algorithm = algorithm;
        }

        @Override
        public Void call() throws Exception {
            try {
                this.algorithm.process(this.region);
            }
            catch (EvictionException e) {
                log.error((Object)"Eviction exception reported", (Throwable)e);
                AssertJUnit.fail((String)("Eviction exception reported" + (Object)((Object)e)));
            }
            return null;
        }
    }

    public static class MockEvictionPolicyConfig
    implements EvictionPolicyConfig {
        public String getEvictionPolicyClass() {
            return MockEvictionPolicy.class.getName();
        }

        public void reset() {
        }

        public void validate() throws ConfigurationException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MockEvictionPolicy
    extends BaseEvictionPolicy {
        public void evict(Fqn fqn) throws Exception {
            throw new Exception("Unable to evict");
        }

        public void setCache(CacheSPI cache) {
        }

        public EvictionAlgorithm getEvictionAlgorithm() {
            return null;
        }

        public Class<? extends EvictionPolicyConfig> getEvictionConfigurationClass() {
            return MockEvictionPolicyConfig.class;
        }
    }

    public static class MockEvictionAlgorithm
    extends BaseEvictionAlgorithm {
        public MockEvictionAlgorithm(int recycleQueueCapacity) {
            this.recycleQueue = new LinkedBlockingQueue(recycleQueueCapacity);
        }

        protected EvictionQueue setupEvictionQueue(Region region) throws EvictionException {
            return new LRUQueue();
        }

        protected boolean shouldEvictNode(NodeEntry ne) {
            return true;
        }
    }
}

