/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Map;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.commands.VisitableCommand;
import org.jboss.cache.commands.write.PutDataMapCommand;
import org.jboss.cache.commands.write.PutKeyValueCommand;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.ComponentRegistry;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.interceptors.MarshalledValueInterceptor;
import org.jboss.cache.interceptors.base.CommandInterceptor;
import org.jboss.cache.invocation.CacheInvocationDelegate;
import org.jboss.cache.loader.DummyInMemoryCacheLoader;
import org.jboss.cache.marshall.CacheMarshaller210;
import org.jboss.cache.marshall.MarshalledValue;
import org.jboss.cache.marshall.Marshaller;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.NodeModified;
import org.jboss.cache.notifications.event.NodeModifiedEvent;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class MarshalledValueTest {
    private CacheSPI<Object, Object> cache1;
    private CacheSPI<Object, Object> cache2;
    private MarshalledValueListenerInterceptor mvli;

    @BeforeMethod
    public void setUp() throws CloneNotSupportedException {
        this.cache1 = (CacheSPI)new DefaultCacheFactory().createCache(UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_SYNC, false), false);
        if (this.cache1.getConfiguration().getBuddyReplicationConfig() != null) {
            this.cache1.getConfiguration().setBuddyReplicationConfig(null);
        }
        this.cache1.getConfiguration().setUseLazyDeserialization(true);
        this.cache2 = (CacheSPI)new DefaultCacheFactory().createCache(this.cache1.getConfiguration().clone(), false);
        this.cache1.start();
        this.cache2.start();
        assert (TestingUtil.findInterceptor(this.cache1, MarshalledValueInterceptor.class) != null) : "Marshalled value interceptor not in chain!";
        assert (TestingUtil.findInterceptor(this.cache2, MarshalledValueInterceptor.class) != null) : "Marshalled value interceptor not in chain!";
        this.mvli = new MarshalledValueListenerInterceptor();
        this.cache1.addInterceptor((CommandInterceptor)this.mvli, MarshalledValueInterceptor.class);
    }

    @AfterMethod
    public void tearDown() {
        TestingUtil.killCaches(new Cache[]{this.cache1, this.cache2});
        Pojo.serializationCount = 0;
        Pojo.deserializationCount = 0;
    }

    private void assertOnlyOneRepresentationExists(MarshalledValue mv) {
        assert (mv.instance != null && mv.raw == null || mv.instance == null && mv.raw != null) : "Only instance or raw representations should exist in a MarshalledValue; never both";
    }

    private void assertSerialized(MarshalledValue mv) {
        assert (mv.raw != null) : "Should be serialized";
    }

    private void assertDeserialized(MarshalledValue mv) {
        assert (mv.instance != null) : "Should be deserialized";
    }

    private void assertSerializationCounts(int serializationCount, int deserializationCount) {
        assert (Pojo.serializationCount == serializationCount) : "Serialization count: expected " + serializationCount + " but was " + Pojo.serializationCount;
        assert (Pojo.deserializationCount == deserializationCount) : "Deserialization count: expected " + deserializationCount + " but was " + Pojo.deserializationCount;
    }

    public void testNonSerializable() {
        try {
            this.cache1.put("/a", (Object)"Hello", new Object());
            assert (false) : "Should have failed";
        }
        catch (CacheException expected) {
            // empty catch block
        }
        assert (this.mvli.invocationCount == 0) : "Call should not have gone beyond the MarshalledValueInterceptor";
        try {
            this.cache1.put("/a", new Object(), (Object)"Hello");
            assert (false) : "Should have failed";
        }
        catch (CacheException cacheException) {
            // empty catch block
        }
        assert (this.mvli.invocationCount == 0) : "Call should not have gone beyond the MarshalledValueInterceptor";
    }

    public void testNodeReleaseObjectValueReferences() {
        Pojo value = new Pojo();
        this.cache1.put("/a", (Object)"key", (Object)value);
        this.assertSerializationCounts(1, 0);
        NodeSPI node = this.cache1.getNode("/a");
        Object o = node.getDirect((Object)"key");
        assert (o instanceof MarshalledValue);
        MarshalledValue mv = (MarshalledValue)o;
        this.assertDeserialized(mv);
        assert (node.get((Object)"key").equals(value));
        this.assertDeserialized(mv);
        this.assertSerializationCounts(1, 0);
        node.releaseObjectReferences(false);
        this.assertSerializationCounts(2, 0);
        this.assertOnlyOneRepresentationExists(mv);
        this.assertSerialized(mv);
        node = this.cache2.getNode("/a");
        o = node.getDirect((Object)"key");
        assert (o instanceof MarshalledValue);
        mv = (MarshalledValue)o;
        this.assertSerialized(mv);
        assert (node.get((Object)"key").equals(value));
        this.assertDeserialized(mv);
        this.assertSerializationCounts(2, 1);
        node.releaseObjectReferences(false);
        this.assertSerializationCounts(2, 1);
        this.assertOnlyOneRepresentationExists(mv);
        this.assertSerialized(mv);
    }

    public void testNodeReleaseObjectKeyReferences() throws IOException, ClassNotFoundException {
        Pojo key = new Pojo();
        this.cache1.put("/a", (Object)key, (Object)"value");
        this.assertSerializationCounts(1, 0);
        NodeSPI node = this.cache1.getNode("/a");
        Object o = node.getKeysDirect().iterator().next();
        assert (o instanceof MarshalledValue);
        MarshalledValue mv = (MarshalledValue)o;
        this.assertDeserialized(mv);
        assert (node.get((Object)key).equals("value"));
        this.assertDeserialized(mv);
        this.assertSerializationCounts(1, 0);
        node.releaseObjectReferences(false);
        this.assertSerializationCounts(2, 0);
        this.assertOnlyOneRepresentationExists(mv);
        this.assertSerialized(mv);
        node = this.cache2.getNode("/a");
        o = node.getKeysDirect().iterator().next();
        assert (o instanceof MarshalledValue);
        mv = (MarshalledValue)o;
        this.assertSerialized(mv);
        assert (node.get((Object)key).equals("value"));
        this.assertSerializationCounts(2, 1);
        this.assertDeserialized(mv);
        node.releaseObjectReferences(false);
        this.assertOnlyOneRepresentationExists(mv);
        this.assertSerialized(mv);
        this.assertSerializationCounts(2, 1);
    }

    public void testEqualsAndHashCode() throws Exception {
        Pojo pojo = new Pojo();
        MarshalledValue mv = new MarshalledValue((Object)pojo);
        this.assertDeserialized(mv);
        int oldHashCode = mv.hashCode();
        mv.serialize();
        this.assertSerialized(mv);
        assert (oldHashCode == mv.hashCode());
        MarshalledValue mv2 = new MarshalledValue((Object)pojo);
        this.assertSerialized(mv);
        this.assertDeserialized(mv2);
        assert (mv2.hashCode() == oldHashCode);
        assert (mv.equals((Object)mv2));
    }

    public void assertUseOfMagicNumbers() throws Exception {
        Pojo pojo = new Pojo();
        MarshalledValue mv = new MarshalledValue((Object)pojo);
        Configuration c = new Configuration();
        ComponentRegistry cr = new ComponentRegistry(c, (CacheSPI)new CacheInvocationDelegate());
        CacheMarshaller210 marshaller = new CacheMarshaller210();
        cr.registerComponent((Object)marshaller, Marshaller.class);
        cr.start();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bout);
        marshaller.objectToObjectStream((Object)mv, out);
        out.close();
        bout.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream in = new ObjectInputStream(bin);
        assert (in.read() == 22);
        MarshalledValue recreated = new MarshalledValue();
        recreated.readExternal((ObjectInput)in);
        assert (in.available() == 0);
        in.close();
        bin.close();
        this.assertSerialized(recreated);
        assert (recreated.equals((Object)mv));
        this.assertSerialized(recreated);
        this.assertOnlyOneRepresentationExists(recreated);
    }

    public void testCacheLoaders() throws CloneNotSupportedException {
        this.tearDown();
        this.cache1 = (CacheSPI)new DefaultCacheFactory().createCache(UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_SYNC), false);
        this.cache2 = (CacheSPI)new DefaultCacheFactory().createCache(UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_SYNC), false);
        CacheLoaderConfig clc = new CacheLoaderConfig();
        CacheLoaderConfig.IndividualCacheLoaderConfig iclc = new CacheLoaderConfig.IndividualCacheLoaderConfig();
        iclc.setClassName(DummyInMemoryCacheLoader.class.getName());
        clc.addIndividualCacheLoaderConfig(iclc);
        this.cache1.getConfiguration().setCacheLoaderConfig(clc);
        this.cache2.getConfiguration().setCacheLoaderConfig(clc.clone());
        this.cache1.getConfiguration().setUseLazyDeserialization(true);
        this.cache2.getConfiguration().setUseLazyDeserialization(true);
        this.cache1.start();
        this.cache2.start();
        TestingUtil.blockUntilViewsReceived(60000L, new Cache[]{this.cache1, this.cache2});
        Pojo pojo = new Pojo();
        this.cache1.put("/a", (Object)"key", (Object)pojo);
        this.assertSerializationCounts(1, 0);
        this.cache2.get("/a", (Object)"key");
        this.assertSerializationCounts(1, 1);
    }

    public void testCallbackValues() {
        Listener l = new Listener();
        this.cache1.addCacheListener((Object)l);
        Pojo pojo = new Pojo();
        this.cache1.put("/a", (Object)"key", (Object)pojo);
        assert (l.modData.size() == 1);
        assert (l.modData.get("key") instanceof Pojo);
        this.assertSerializationCounts(1, 0);
    }

    public void testRemoteCallbackValues() {
        Listener l = new Listener();
        this.cache2.addCacheListener((Object)l);
        Pojo pojo = new Pojo();
        this.cache1.put("/a", (Object)"key", (Object)pojo);
        assert (l.modData.size() == 1);
        pojo = (Pojo)l.modData.get("key");
        assert (pojo != null);
        this.assertSerializationCounts(1, 1);
    }

    public static class Pojo
    implements Externalizable {
        int i;
        boolean b;
        static int serializationCount;
        static int deserializationCount;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Pojo pojo = (Pojo)o;
            if (this.b != pojo.b) {
                return false;
            }
            return this.i == pojo.i;
        }

        public int hashCode() {
            int result = this.i;
            result = 31 * result + (this.b ? 1 : 0);
            return result;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.i);
            out.writeBoolean(this.b);
            ++serializationCount;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.i = in.readInt();
            this.b = in.readBoolean();
            ++deserializationCount;
        }
    }

    class MarshalledValueListenerInterceptor
    extends CommandInterceptor {
        int invocationCount = 0;

        MarshalledValueListenerInterceptor() {
        }

        public Object visitPutDataMapCommand(InvocationContext ctx, PutDataMapCommand command) throws Throwable {
            ++this.invocationCount;
            Object retval = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
            if (retval instanceof MarshalledValue) {
                MarshalledValueTest.this.assertOnlyOneRepresentationExists((MarshalledValue)retval);
            }
            return retval;
        }

        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            Object retval;
            ++this.invocationCount;
            if (command.getKey() instanceof MarshalledValue) {
                MarshalledValueTest.this.assertOnlyOneRepresentationExists((MarshalledValue)command.getKey());
            }
            if (command.getValue() instanceof MarshalledValue) {
                MarshalledValueTest.this.assertOnlyOneRepresentationExists((MarshalledValue)command.getValue());
            }
            if ((retval = this.invokeNextInterceptor(ctx, (VisitableCommand)command)) instanceof MarshalledValue) {
                MarshalledValueTest.this.assertOnlyOneRepresentationExists((MarshalledValue)retval);
            }
            return retval;
        }
    }

    @CacheListener
    public static class Listener {
        Map modData;

        @NodeModified
        public void nodeModified(NodeModifiedEvent e) {
            if (!e.isPre()) {
                this.modData = e.getData();
            }
        }
    }
}

