/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import java.util.ArrayList;
import java.util.List;
import org.jboss.cache.Cache;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class DataVersionTransferTest {
    private List<Cache<Object, Object>> caches = new ArrayList<Cache<Object, Object>>(2);

    @BeforeMethod
    public void setUp() {
        this.caches.add((Cache<Object, Object>)new DefaultCacheFactory().createCache(false));
        this.caches.get(0).getConfiguration().setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        this.caches.get(0).getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        this.caches.get(0).getConfiguration().setCacheMode(Configuration.CacheMode.REPL_SYNC);
        this.caches.get(0).start();
        this.caches.add((Cache<Object, Object>)new DefaultCacheFactory().createCache(false));
        this.caches.get(1).getConfiguration().setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        this.caches.get(1).getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        this.caches.get(1).getConfiguration().setCacheMode(Configuration.CacheMode.REPL_SYNC);
    }

    @AfterMethod
    public void tearDown() {
        if (this.caches != null) {
            for (Cache<Object, Object> cache : this.caches) {
                try {
                    cache.getConfiguration().getRuntimeConfig().getTransactionManager().rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                cache.stop();
            }
        }
    }

    public void testStateTransferDefaultVersions() throws Exception {
        Fqn f = Fqn.fromString((String)"/one/two/three");
        this.caches.get(0).put(f, (Object)"k", (Object)"v");
        this.caches.get(0).put(f, (Object)"k1", (Object)"v1");
        this.caches.get(0).remove(f, (Object)"k1");
        NodeSPI n = (NodeSPI)this.caches.get(0).getRoot().getChild(f);
        DataVersion dv = n.getVersion();
        assert (dv instanceof DefaultDataVersion) : "Should be an instance of DefaultDataVersion";
        assert (((DefaultDataVersion)dv).getRawVersion() == 3L) : "Should have accurate data version";
        this.caches.get(1).start();
        TestingUtil.blockUntilViewsReceived(10000L, this.caches.get(0), this.caches.get(1));
        assert (this.caches.get(1).get(f, (Object)"k").equals("v")) : "Value should have transferred";
        n = (NodeSPI)this.caches.get(1).getRoot().getChild(f);
        dv = n.getVersion();
        assert (dv instanceof DefaultDataVersion) : "Should be an instance of DefaultDataVersion";
        assert (((DefaultDataVersion)dv).getRawVersion() == 3L) : "Version should have transferred";
        assert (n.getData().size() == 1);
    }

    public void testStateTransferCustomVersion() throws Exception {
        Fqn f = Fqn.fromString((String)"/one/two/three");
        this.caches.get(0).getInvocationContext().getOptionOverrides().setDataVersion((DataVersion)new CharVersion('A'));
        this.caches.get(0).put(f, (Object)"k", (Object)"v");
        this.caches.get(0).getInvocationContext().getOptionOverrides().setDataVersion((DataVersion)new CharVersion('B'));
        this.caches.get(0).put(f, (Object)"k1", (Object)"v1");
        this.caches.get(0).getInvocationContext().getOptionOverrides().setDataVersion((DataVersion)new CharVersion('C'));
        this.caches.get(0).remove(f, (Object)"k1");
        NodeSPI n = (NodeSPI)this.caches.get(0).getRoot().getChild(f);
        DataVersion dv = n.getVersion();
        assert (dv instanceof CharVersion) : "Should be an instance of CharVersion";
        assert (((CharVersion)dv).version == 'C') : "Should have accurate data version";
        this.caches.get(1).start();
        TestingUtil.blockUntilViewsReceived(10000L, this.caches.get(0), this.caches.get(1));
        assert (this.caches.get(1).get(f, (Object)"k").equals("v")) : "Value should have transferred";
        n = (NodeSPI)this.caches.get(1).getRoot().getChild(f);
        dv = n.getVersion();
        assert (dv instanceof CharVersion) : "Should be an instance of CharVersion";
        assert (((CharVersion)dv).version == 'C') : "Version should have transferred";
        assert (n.getData().size() == 1);
    }

    public void testStateTransferIntermediateNodeDefaultVersions() throws Exception {
        Fqn f = Fqn.fromString((String)"/one/two/three");
        Fqn intermediate = f.getParent();
        this.caches.get(0).put(f, (Object)"k", (Object)"v");
        this.caches.get(0).put(intermediate, (Object)"k", (Object)"v");
        NodeSPI n = (NodeSPI)this.caches.get(0).getRoot().getChild(intermediate);
        DataVersion dv = n.getVersion();
        assert (dv instanceof DefaultDataVersion) : "Should be an instance of DefaultDataVersion";
        assert (((DefaultDataVersion)dv).getRawVersion() == 1L) : "Should have accurate data version";
        this.caches.get(1).start();
        TestingUtil.blockUntilViewsReceived(10000L, this.caches.get(0), this.caches.get(1));
        assert (this.caches.get(1).get(intermediate, (Object)"k").equals("v")) : "Value should have transferred";
        n = (NodeSPI)this.caches.get(0).getRoot().getChild(intermediate);
        dv = n.getVersion();
        assert (dv instanceof DefaultDataVersion) : "Should be an instance of DefaultDataVersion";
        assert (((DefaultDataVersion)dv).getRawVersion() == 1L) : "Should have accurate data version";
        assert (n.getData().size() == 1);
    }

    public void testStateTransferIntermediateNodeCustomVersion() throws Exception {
        Fqn f = Fqn.fromString((String)"/one/two/three");
        Fqn intermediate = f.getParent();
        this.caches.get(0).put(f, (Object)"k", (Object)"v");
        this.caches.get(0).getInvocationContext().getOptionOverrides().setDataVersion((DataVersion)new CharVersion('X'));
        this.caches.get(0).put(intermediate, (Object)"k", (Object)"v");
        NodeSPI n = (NodeSPI)this.caches.get(0).getRoot().getChild(intermediate);
        DataVersion dv = n.getVersion();
        assert (dv instanceof CharVersion) : "Should be an instance of CharVersion";
        assert (((CharVersion)dv).version == 'X') : "Should have accurate data version";
        this.caches.get(1).start();
        TestingUtil.blockUntilViewsReceived(10000L, this.caches.get(0), this.caches.get(1));
        assert (this.caches.get(1).get(intermediate, (Object)"k").equals("v")) : "Value should have transferred";
        n = (NodeSPI)this.caches.get(0).getRoot().getChild(intermediate);
        dv = n.getVersion();
        assert (dv instanceof CharVersion) : "Should be an instance of CharVersion";
        assert (((CharVersion)dv).version == 'X') : "Should have accurate data version";
        assert (n.getData().size() == 1);
    }

    public static class CharVersion
    implements DataVersion {
        private char version = (char)65;

        public CharVersion(char version) {
            this.version = version;
        }

        public boolean newerThan(DataVersion other) {
            if (other instanceof CharVersion) {
                CharVersion otherVersion = (CharVersion)other;
                return this.version > otherVersion.version;
            }
            return true;
        }
    }
}

