/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.util.internals;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.RPCManager;
import org.jboss.cache.commands.ReplicableCommand;
import org.jboss.cache.commands.remote.ReplicateCommand;
import org.jboss.cache.commands.tx.PrepareCommand;
import org.jboss.cache.factories.ComponentRegistry;
import org.jboss.cache.marshall.CommandAwareRpcDispatcher;
import org.jboss.cache.marshall.InactiveRegionAwareRpcDispatcher;
import org.jboss.cache.marshall.Marshaller;
import org.jboss.cache.marshall.RegionalizedMethodCall;
import org.jboss.cache.util.TestingUtil;
import org.jgroups.blocks.RpcDispatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationListener {
    private CountDownLatch latch = new CountDownLatch(1);
    private Set<Class<? extends ReplicableCommand>> expectedCommands;

    public ReplicationListener(Cache cache) {
        ComponentRegistry componentRegistry = TestingUtil.extractComponentRegistry(cache);
        RPCManager rpcManager = (RPCManager)componentRegistry.getComponent(RPCManager.class);
        CommandAwareRpcDispatcher realDispatcher = (CommandAwareRpcDispatcher)TestingUtil.extractField(rpcManager, "rpcDispatcher");
        if (realDispatcher instanceof InactiveRegionAwareRpcDispatcher) {
            Marshaller realMarshaller = (Marshaller)TestingUtil.extractField(InactiveRegionAwareRpcDispatcher.class, realDispatcher, "requestMarshaller");
            RegionMarshallerDelegate delegate = new RegionMarshallerDelegate(realMarshaller);
            TestingUtil.replaceField(delegate, "requestMarshaller", realDispatcher, InactiveRegionAwareRpcDispatcher.class);
        } else {
            RpcDispatcher.Marshaller realMarshaller = (RpcDispatcher.Marshaller)TestingUtil.extractField(RpcDispatcher.class, realDispatcher, "req_marshaller");
            MarshallerDelegate delegate = new MarshallerDelegate(realMarshaller);
            TestingUtil.replaceField(delegate, "req_marshaller", realDispatcher, RpcDispatcher.class);
        }
    }

    public void waitForReplicationToOccur(long timeoutMillis) {
        System.out.println("enter... ReplicationListener.waitForReplicationToOccur");
        this.waitForReplicationToOccur(timeoutMillis, TimeUnit.MILLISECONDS);
        System.out.println("exit... ReplicationListener.waitForReplicationToOccur");
    }

    public void waitForReplicationToOccur(long timeout, TimeUnit timeUnit) {
        assert (this.expectedCommands != null) : "there are no replication expectations; please use AsyncReplicationListener.expect(...) before calling this method";
        try {
            if (!this.latch.await(timeout, timeUnit)) assert (false) : "waiting for more than " + timeout + " " + (Object)((Object)timeUnit) + " and following commands did not replicate: " + this.expectedCommands;
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("unexpected", e);
        }
        finally {
            this.expectedCommands = null;
            this.latch = new CountDownLatch(1);
        }
    }

    public void expect(Class<? extends ReplicableCommand> ... expectedCommands) {
        if (this.expectedCommands == null) {
            this.expectedCommands = new HashSet<Class<? extends ReplicableCommand>>();
        }
        this.expectedCommands.addAll(Arrays.asList(expectedCommands));
    }

    public void expectAny() {
        this.expect(new Class[0]);
    }

    private class RegionMarshallerDelegate
    implements Marshaller {
        private Marshaller realOne;

        private RegionMarshallerDelegate(Marshaller realOne) {
            this.realOne = realOne;
        }

        public void objectToObjectStream(Object obj, ObjectOutputStream out) throws Exception {
            this.realOne.objectToObjectStream(obj, out);
        }

        public Object objectFromObjectStream(ObjectInputStream in) throws Exception {
            return this.realOne.objectFromObjectStream(in);
        }

        public Object objectFromStream(InputStream is) throws Exception {
            return this.realOne.objectFromStream(is);
        }

        public void objectToObjectStream(Object obj, ObjectOutputStream out, Fqn region) throws Exception {
            this.realOne.objectToObjectStream(obj, out, region);
        }

        public RegionalizedMethodCall regionalizedMethodCallFromByteBuffer(byte[] buffer) throws Exception {
            RegionalizedMethodCall result = this.realOne.regionalizedMethodCallFromByteBuffer(buffer);
            if (result.command instanceof ReplicateCommand && ReplicationListener.this.expectedCommands != null) {
                ReplicateCommand replicateCommand = (ReplicateCommand)result.command;
                result.command = new ReplicateCommandDelegate(replicateCommand);
            }
            return result;
        }

        public RegionalizedMethodCall regionalizedMethodCallFromObjectStream(ObjectInputStream in) throws Exception {
            return this.realOne.regionalizedMethodCallFromObjectStream(in);
        }

        public byte[] objectToByteBuffer(Object o) throws Exception {
            return this.realOne.objectToByteBuffer(o);
        }

        public Object objectFromByteBuffer(byte[] bytes) throws Exception {
            return this.realOne.objectFromByteBuffer(bytes);
        }
    }

    private class ReplicateCommandDelegate
    extends ReplicateCommand {
        ReplicateCommand realOne;

        private ReplicateCommandDelegate(ReplicateCommand realOne) {
            this.realOne = realOne;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object perform(InvocationContext ctx) throws Throwable {
            Iterator it2;
            Object object;
            try {
                object = this.realOne.perform(ctx);
                Object var4_3 = null;
                System.out.println("Processed command: " + this.realOne);
                it2 = ReplicationListener.this.expectedCommands.iterator();
            }
            catch (Throwable throwable) {
                block7: {
                    Object var4_4 = null;
                    System.out.println("Processed command: " + this.realOne);
                    Iterator it2 = ReplicationListener.this.expectedCommands.iterator();
                    while (it2.hasNext()) {
                        PrepareCommand prepareCommand;
                        Class replicableCommandClass = (Class)it2.next();
                        if (this.realOne.containsCommandType(replicableCommandClass)) {
                            it2.remove();
                            continue;
                        }
                        if (!(this.realOne.getSingleModification() instanceof PrepareCommand) || !(prepareCommand = (PrepareCommand)this.realOne.getSingleModification()).containsModificationType(replicableCommandClass)) continue;
                        it2.remove();
                    }
                    if (!ReplicationListener.this.expectedCommands.isEmpty()) break block7;
                    ReplicationListener.this.latch.countDown();
                }
                throw throwable;
            }
            while (it2.hasNext()) {
                PrepareCommand prepareCommand;
                Class replicableCommandClass = (Class)it2.next();
                if (this.realOne.containsCommandType(replicableCommandClass)) {
                    it2.remove();
                    continue;
                }
                if (!(this.realOne.getSingleModification() instanceof PrepareCommand) || !(prepareCommand = (PrepareCommand)this.realOne.getSingleModification()).containsModificationType(replicableCommandClass)) continue;
                it2.remove();
            }
            if (ReplicationListener.this.expectedCommands.isEmpty()) {
                ReplicationListener.this.latch.countDown();
            }
            return object;
        }
    }

    private class MarshallerDelegate
    implements RpcDispatcher.Marshaller {
        RpcDispatcher.Marshaller marshaller;

        private MarshallerDelegate(RpcDispatcher.Marshaller marshaller) {
            this.marshaller = marshaller;
        }

        public byte[] objectToByteBuffer(Object obj) throws Exception {
            return this.marshaller.objectToByteBuffer(obj);
        }

        public Object objectFromByteBuffer(byte[] bytes) throws Exception {
            Object result = this.marshaller.objectFromByteBuffer(bytes);
            if (result instanceof ReplicateCommand && ReplicationListener.this.expectedCommands != null) {
                ReplicateCommand replicateCommand = (ReplicateCommand)result;
                return new ReplicateCommandDelegate(replicateCommand);
            }
            return result;
        }
    }
}

