/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.pojo.PojoCacheException;
import org.jboss.cache.pojo.impl.AbstractHandler;
import org.jboss.cache.pojo.impl.InternalHelper;
import org.jboss.cache.pojo.impl.PojoCacheImpl;
import org.jboss.cache.pojo.impl.PojoInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ObjectGraphHandler
extends AbstractHandler {
    private PojoCacheImpl cache;
    private InternalHelper internal_;
    private static final Log log = LogFactory.getLog(ObjectGraphHandler.class);

    public ObjectGraphHandler(PojoCacheImpl cache, InternalHelper internal) {
        this.cache = cache;
        this.internal_ = internal;
    }

    @Override
    protected Fqn<?> getFqn(Object obj) {
        return null;
    }

    @Override
    protected boolean handles(Class<?> clazz) {
        return false;
    }

    @Override
    protected Object get(Fqn<?> fqn, Class<?> clazz, PojoInstance pojoInstance) throws CacheException {
        Object obj = this.cache.find(fqn);
        if (obj == null) {
            throw new PojoCacheException("ObjectGraphHandler.get(): null object from internal ref node. Internal ref node: " + fqn);
        }
        return obj;
    }

    @Override
    protected void put(Fqn<?> fqn, Fqn<?> referencingFqn, Object obj) throws CacheException {
        this.setupRefCounting(fqn, referencingFqn);
    }

    boolean isMultipleReferenced(Fqn<?> internalFqn) {
        PojoInstance pojoInstance = null;
        try {
            pojoInstance = this.internal_.getPojoInstance(internalFqn);
        }
        catch (CacheException e) {
            throw new PojoCacheException("Exception in isMultipleReferenced", e);
        }
        return InternalHelper.isMultipleReferenced(pojoInstance);
    }

    @Override
    protected Object remove(Fqn<?> fqn, Fqn<?> referencingFqn, Object pojo) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("remove(): removing object fqn: " + referencingFqn + " Will just de-reference it."));
        }
        this.removeFromReference(fqn, referencingFqn);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromReference(Fqn<?> originalFqn, Fqn<?> referencingFqn) throws CacheException {
        Fqn<?> fqn = originalFqn;
        synchronized (fqn) {
            if (this.decrementRefCount(originalFqn, referencingFqn) == -1) {
                this.cache.detach(originalFqn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupRefCounting(Fqn<?> fqn, Fqn<?> referencingFqn) throws CacheException {
        Fqn<?> fqn2 = fqn;
        synchronized (fqn2) {
            this.incrementRefCount(fqn, referencingFqn);
        }
    }

    private int incrementRefCount(Fqn<?> originalFqn, Fqn<?> referencingFqn) throws CacheException {
        return this.internal_.incrementRefCount(originalFqn, referencingFqn);
    }

    private int decrementRefCount(Fqn<?> originalFqn, Fqn<?> referencingFqn) throws CacheException {
        return this.internal_.decrementRefCount(originalFqn, referencingFqn);
    }
}

