/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.cache.Fqn;
import org.jboss.cache.pojo.PojoCacheException;
import org.jboss.cache.pojo.collection.CachedArray;
import org.jboss.cache.pojo.collection.CachedArrayRegistry;
import org.jboss.cache.pojo.impl.MethodDeclarations;
import org.jboss.cache.pojo.interceptors.PojoTxSynchronizationHandler;
import org.jboss.cache.pojo.interceptors.dynamic.AbstractCollectionInterceptor;
import org.jboss.cache.pojo.interceptors.dynamic.CacheFieldInterceptor;
import org.jboss.cache.pojo.util.MethodCall;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PojoUtil {
    public void attachInterceptor(Object pojo, InstanceAdvisor advisor, Interceptor interceptor) {
        this._attachInterceptor(pojo, advisor, interceptor);
        Method method = MethodDeclarations.undoAttachInterceptor;
        MethodCall mc = new MethodCall(method, new Object[]{pojo, advisor, interceptor}, this);
        this.addUndo(mc);
    }

    public void detachInterceptor(InstanceAdvisor advisor, Interceptor interceptor) {
        this._detachInterceptor(advisor, interceptor);
        Method method = MethodDeclarations.undoDetachInterceptor;
        MethodCall mc = new MethodCall(method, new Object[]{advisor, interceptor}, this);
        this.addUndo(mc);
    }

    private void addUndo(MethodCall mc) {
        PojoTxSynchronizationHandler handler = PojoTxSynchronizationHandler.current();
        if (handler != null) {
            handler.addToList(mc);
        }
    }

    public void detachCollectionInterceptor(AbstractCollectionInterceptor interceptor) {
        interceptor.detach(true);
        Method method = MethodDeclarations.undoDetachCollectionInterceptor;
        MethodCall mc = new MethodCall(method, new Object[]{interceptor}, this);
        this.addUndo(mc);
    }

    public void attachArray(Object array, CachedArray cached) {
        CachedArrayRegistry.register(array, cached);
        Method method = MethodDeclarations.undoAttachArray;
        MethodCall mc = new MethodCall(method, new Object[]{array, cached}, this);
        this.addUndo(mc);
    }

    public void detachArray(Object array, CachedArray cached) {
        CachedArrayRegistry.unregister(array);
        Method method = MethodDeclarations.undoDetachArray;
        MethodCall mc = new MethodCall(method, new Object[]{array, cached}, this);
        this.addUndo(mc);
    }

    public void undoAttachInterceptor(Object pojo, InstanceAdvisor advisor, Interceptor interceptor) {
        this._detachInterceptor(advisor, interceptor);
    }

    public void undoDetachInterceptor(InstanceAdvisor advisor, Interceptor interceptor) {
        Object pojo = ((CacheFieldInterceptor)interceptor).getAopInstance().get();
        if (pojo == null) {
            throw new PojoCacheException("PojoUtil.detachInterceptor(): null pojo");
        }
        this._attachInterceptor(pojo, advisor, interceptor);
    }

    public void undoDetachCollectionInterceptor(AbstractCollectionInterceptor interceptor) {
        interceptor.attach(null, false);
    }

    public void undoAttachArray(Object array, CachedArray cached) {
        CachedArrayRegistry.unregister(array);
    }

    public void undoDetachArray(Object array, CachedArray cached) {
        CachedArrayRegistry.register(array, cached);
    }

    public void inMemorySubstitution(Object obj, Field field, Object newValue) {
        Object[] args;
        Method method = MethodDeclarations.undoInMemorySubstitution;
        try {
            args = new Object[]{obj, field, field.get(obj)};
        }
        catch (Throwable t) {
            throw new PojoCacheException("Severe error building undo list", t);
        }
        this._inMemorySubstitution(obj, field, newValue);
        MethodCall mc = new MethodCall(method, args, this);
        this.addUndo(mc);
    }

    public void undoInMemorySubstitution(Object obj, Field field, Object oldValue) {
        this._inMemorySubstitution(obj, field, oldValue);
    }

    private void _attachInterceptor(Object pojo, InstanceAdvisor advisor, Interceptor interceptor) {
        advisor.appendInterceptor(interceptor);
    }

    private void _inMemorySubstitution(Object obj, Field field, Object newValue) {
        try {
            field.set(obj, newValue);
        }
        catch (IllegalAccessException e) {
            throw new PojoCacheException("PojoUtil.inMemorySubstitution(): Can't swap out the class of field \" +field.getLastElementAsString()," + e);
        }
    }

    private void _detachInterceptor(InstanceAdvisor advisor, Interceptor interceptor) {
        advisor.removeInterceptor(interceptor.getName());
        Object pojo = ((CacheFieldInterceptor)interceptor).getAopInstance().get();
        if (pojo == null) {
            throw new PojoCacheException("PojoUtil.detachInterceptor(): null pojo");
        }
    }

    public int incrementReferenceCount(Fqn<?> sourceFqn, int count, List<?> refList) {
        int ret = this._incrementReferenceCount(sourceFqn, count, refList);
        Method method = MethodDeclarations.undoIncrementReferenceCount;
        Object[] args = new Object[]{sourceFqn, count, refList};
        MethodCall mc = new MethodCall(method, args, this);
        this.addUndo(mc);
        return ret;
    }

    public int undoIncrementReferenceCount(Fqn sourceFqn, int count, List refList) {
        return this._decrementReferenceCount(sourceFqn, count, refList);
    }

    private int _incrementReferenceCount(Fqn sourceFqn, int count, List refList) {
        refList.add(sourceFqn);
        return count + 1;
    }

    public int decrementReferenceCount(Fqn<?> sourceFqn, int count, List<?> refList) {
        int ret = this._decrementReferenceCount(sourceFqn, count, refList);
        Method method = MethodDeclarations.undoDecrementReferenceCount;
        Object[] args = new Object[]{sourceFqn, count, refList};
        MethodCall mc = new MethodCall(method, args, this);
        this.addUndo(mc);
        return ret;
    }

    public int undoDecrementReferenceCount(Fqn sourceFqn, int count, List refList) {
        return this._incrementReferenceCount(sourceFqn, count, refList);
    }

    private int _decrementReferenceCount(Fqn sourceFqn, int count, List refList) {
        refList.remove(sourceFqn);
        return count - 1;
    }
}

